const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");

class OrderService extends ServiceBase {
  constructor() {
    super("dborder", ServiceBase.getDaoName(OrderService));
    this.logCtl = system.getObject("web.common.oplogCtl");
    this.appproductDao = system.getObject("db.dbapp.appproductDao");
    this.ordertmproductDao = system.getObject("db.dborder.ordertmproductDao");
    this.receiptvoucherDao = system.getObject("db.dborder.receiptvoucherDao");
    this.execClient = system.getObject("util.execClient");
  }
  async op1688ChannelPushOrder(action_body, pobj, req) {
    try {
      //var reqUrl = "https://inte-mcp.chanjet.com/gsb/getOrder?token=" + action_body.token; //测试环境
      var reqUrl = "https://mcp.chanjet.com/gsb/getOrder?token=" + action_body.token; //线上环境
      var rtn = await this.execClient.execGet("", reqUrl);
      var logParam = {
        appid: req.app.id,
        appkey: req.app.uappKey,
        requestId: req.requestId || "",
        op: "/igirl-channel/zhichan/igirl-channel/app/base/service/impl/dborder/orderSve/opChannelCallbackData",
        content: "请求地址：" + reqUrl,
        clientIp: pobj.clientIp,
        optitle: "渠道回调信息返回结果：" + rtn.stdout,
      };

      this.logCtl.info(logParam);
      var result = JSON.parse(rtn.stdout);
      // var result = { "returnValue": [{ "bizStatusExt": "audit_pass", "memberId": "b2b-1624961198", "productName": "【商标注册】自助注册申请", "gmtCreate": "20191119162048000+0800", "gmtServiceEnd": null, "bizStatus": "B", "paymentAmount": 0.0, "executePrice": 0, "orderItemNum": "W19111938409910_1", "gmtServiceBegin": null, "gmtConfirm": "20191119162051000+0800", "settleItemDtos": [], "payCustomerUid": "1875826463", "signCustomerUid": "1875826463" }, { "bizStatusExt": "audit_pass", "memberId": "b2b-1624961198", "productName": "【商标注册】自助注册申请", "gmtCreate": "20191119161008000+0800", "gmtServiceEnd": null, "bizStatus": "B", "paymentAmount": 0.0, "executePrice": 0, "orderItemNum": "W19111938409527_1", "gmtServiceBegin": null, "gmtConfirm": "20191119161011000+0800", "settleItemDtos": [], "payCustomerUid": "1875826463", "signCustomerUid": "1875826463" }, { "bizStatusExt": "audit_pass", "memberId": "b2b-1624961198", "productName": "【商标注册】自助注册申请", "gmtCreate": "20191119130813000+0800", "gmtServiceEnd": null, "bizStatus": "B", "paymentAmount": 0.0, "executePrice": 0, "orderItemNum": "W19111938403044_1", "gmtServiceBegin": null, "gmtConfirm": "20191119130816000+0800", "settleItemDtos": [], "payCustomerUid": "1875826463", "signCustomerUid": "1875826463" }, { "bizStatusExt": "audit_pass", "memberId": "b2b-1624961198", "productName": "【商标注册】自助注册申请", "gmtCreate": "20191119125011000+0800", "gmtServiceEnd": null, "bizStatus": "B", "paymentAmount": 0.0, "executePrice": 0, "orderItemNum": "W19111938402638_1", "gmtServiceBegin": null, "gmtConfirm": "20191119125017000+0800", "settleItemDtos": [], "payCustomerUid": "1875826463", "signCustomerUid": "1875826463" }, { "bizStatusExt": "audit_pass", "memberId": "b2b-1624961198", "productName": "【商标注册】自助注册申请", "gmtCreate": "20191119110329000+0800", "gmtServiceEnd": null, "bizStatus": "B", "paymentAmount": 0.0, "executePrice": 0, "orderItemNum": "W19111938399256_1", "gmtServiceBegin": null, "gmtConfirm": "20191119110332000+0800", "settleItemDtos": [], "payCustomerUid": "1875826463", "signCustomerUid": "1875826463" }, { "bizStatusExt": "audit_pass", "memberId": "b2b-1624961198", "productName": "【商标注册】自助注册申请", "gmtCreate": "20191119104737000+0800", "gmtServiceEnd": null, "bizStatus": "B", "paymentAmount": 0.0, "executePrice": 0, "orderItemNum": "W19111938398567_1", "gmtServiceBegin": null, "gmtConfirm": "20191119104740000+0800", "settleItemDtos": [], "payCustomerUid": "1875826463", "signCustomerUid": "1875826463" }, { "bizStatusExt": "audit_pass", "memberId": "b2b-1624961198", "productName": "【商标注册】自助注册申请", "gmtCreate": "20191118191753000+0800", "gmtServiceEnd": null, "bizStatus": "B", "paymentAmount": 0.0, "executePrice": 0, "orderItemNum": "W19111838384729_1", "gmtServiceBegin": null, "gmtConfirm": "20191118191755000+0800", "settleItemDtos": [], "payCustomerUid": "1875826463", "signCustomerUid": "1875826463" }], "successed": true, "errorMsg": null };
      if (result && result.successed && result.successed == true && result.returnValue && result.returnValue.length) {
        await this.addOrderNeed(action_body, req, result.returnValue);
      }//操作需求
      return system.getResultSuccess();
    } catch (e) {
      console.log(e.stack, "渠道回调信息返回结果：error......1.....");
      this.logCtl.error({
        appid: req.app.id,
        appkey: req.app.uappKey,
        requestId: req.requestId || "",
        op: "/igirl-channel/zhichan/igirl-channel/app/base/service/impl/dborder/orderSve/opChannelCallbackData",
        content: "error：" + e.stack,
        clientIp: pobj.clientIp,
        optitle: "渠道回调信息返回结果：" + rtn.stdout,
      });
    }
  }
  async op1688ChannelPushOrderTest(action_body, pobj, req) {
    try {

      var returnValue = [
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_01",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_02",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_03",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_04",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_05",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_06",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_07",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_08",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_09",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_10",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_11",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_12",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_13",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_14",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_15",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_16",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_17",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_18",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_19",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_20",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        }
      ];
      await this.addOrderNeed(action_body, req, returnValue);
      return system.getResultSuccess();
    } catch (e) {
      console.log(e.stack, "渠道回调信息返回结果：error...........");
      this.logCtl.error({
        appid: req.app.id,
        appkey: req.app.uappKey,
        requestId: req.requestId || "",
        op: "/igirl-channel/zhichan/igirl-channel/app/base/service/impl/dborder/orderSve/opChannelCallbackData",
        content: "请求地址：" + reqUrl + "，error：" + e.stack,
        clientIp: pobj.clientIp,
        optitle: "渠道回调信息返回结果：" + rtn.stdout,
      });
    }
  }
  async addOrderNeed(action_body, req, returnValue) {
    var addOrderList = [];
    var productItem = await this.appproductDao.findOneByChannelItemCode(action_body.channelItemCode, req.app.id);//获取产品
    if (!productItem) {
      return;
    }
    var self = this;
    //创建订单
    var ordercode = await this.getBusUid("ts");
    for (let index = 0; index < returnValue.length; index++) {
      const element = returnValue[index];
      if (element) {
        if (element.bizStatusExt == "service" || element.bizStatusExt == "audit_pass") {
          var orderCount = await self.findCount({ where: { needNo: element.orderItemNum } });
          if (orderCount > 0) {
            continue;
          }
          var payTime = null;
          if (element.gmtCreate && element.gmtCreate.length > 14) {
            payTime = element.gmtCreate.substr(0, 4) + "-" + element.gmtCreate.substr(4, 2) +
              "-" + element.gmtCreate.substr(6, 2) + " " + element.gmtCreate.substr(8, 2) + ":" +
              element.gmtCreate.substr(10, 2) + ":" + element.gmtCreate.substr(12, 2);
          }
          await self.db.transaction(async function (t) {
            //创建订单
            var ordercode = await self.getBusUid("tm");
            var orderParams = {
              app_id: req.app.id,//                                                                                                                                                                                                
              orderNo: ordercode,// 订单号                                                                                                                                                                                        
              channelServiceNo: element.orderItemNum,// 渠道服务单号 
              payTime: payTime,//
              itemCode: productItem.itemCode,//                                                                                                                                                                                                 
              itemName: productItem.itemName,//                                                                                                                                                                                                 
              channelItemCode: productItem.channelItemCode,// 渠道产品编码                                                                                                                                                                               
              channelItemName: productItem.channelItemName,// 渠道产品名称                                                                                                                                                                               
              salesNum: 1,//项目订单数量（即服务项目的倍数，默认值为1）          
              salesDiliverNum: 0,//项目订单交付数量（即与项目订单数量相对应）                                                                                                                             
              minitermNum: 10,//订单小项数量                                                                                                                                
              minitermDiliverNum: 0,//订单小项交付数量                                                                                                                                
              orderType: "dkxd",// 订单类型，zzdd: 自主订单,dkxd: 代客下单                                                                                                                                             
              orderPayStatus: "yfk",// 订单付款状态dfk: 待付款, zfpz: 已上传支付凭证, yfk: 已付款, ddqx: 订单取消, tkclz: 退款处理中, bfytk: 部分已退款, ytk: 已退款,zfshbtg:支付审核不通过  
              totalServiceCharge: productItem.totalServiceCharge || 0,// 服务费总额（产品配置的服务费*订单件数）                                                                                                                                       
              totalPublicExpense: productItem.totalPublicExpense || 0,// 官费总额（产品配置的官费*订单件数）                                                                                                                                             
              totalSum: element.executePrice || 0,// 订单总额(产品价格×优惠费率×订单件数)                                                                                                                                           
              refundSum: 0,// 退款金额                                                                                                                                                                                     
              // notes: apply.notes, //备注                                                                                                                                                                                          
              appPayType: "00",// 支付类型：00第三方支付，10平台代收款                                                                                                                                             
              payAccountType: "other",// 帐户类型（ 支付类型）:cash: 现金, bank: 银行,wx:微信,alipay:支付,other:其它                                                                                                                                                                                    
              createuser_id: req.user.id,
              owner_id: req.user.id,//                                                                                                                                                                                                 
              creator: req.user.nickname || "",
              owner: req.user.nickname || "",//                                                                                                                                                                                                  
              ownerMoblie: req.user.userMoblie || "",//                                                                                                                                                                                                 
              invoiceApplyStatus: "00",// 发票状态:00: 未申请, 10: 已申请,20:已开票                                                                                                                                                                               
              channelUserId: req.user.channelUserId || "",// 渠道用户id  
              needNo: element.orderItemNum || null,//需求单号
              picUrl: productItem.picUrl,//                                                                                                                             
              productType_id: productItem.productType_id,//产品类型Id                                                                                                               
              productOneType_id: productItem.productOneType_id,//产品大类Id                                                                                                               
              serviceItemSnapshot: JSON.stringify(productItem),//产品快照        
            };
            var orderItem = await self.dao.create(orderParams, t);//创建订单

            var receiptvoucherItem = await self.receiptvoucherDao.addReceiptvoucher(orderParams, req, t);//创建订单支付信息
            if (productItem.itemCode == "zzsbzc") {
              var orderProductObj = {
                app_id: req.app.id,//   
                productType_id: productItem.productType_id,//产品类型Id                                                                                                               
                productOneType_id: productItem.productOneType_id,//产品大类Id      
                itemCode: productItem.itemCode,//                                                                                                                                                                                                 
                itemName: productItem.itemName,//                                                                                                                                       
                orderServicePayStatus: "yfk",//支付状态:dfk: 待付款, yfk: 已支付                                                                                  
                appDataOpType: req.app.appDataOpType,// 应用数据操作类型：00独立，10全委托，20部分委托     
                sourceOrderNo: ordercode,//来源单号   
                deliveryOrderNo: await self.getBusUid("jf"),
                channelServiceNo: element.orderItemNum || null,// 渠道服务单号                                                                                                                                                                               
                needNo: element.orderItemNum || null,//需求单号
                sourceType: "00",
                channelUserId: req.user.channelUserId || "",// 渠道用户id  
                createuser_id: req.user.id,//                                                                                                                           
                createuser: req.user.nickname,//             
              };
              //创建服务单
              var orderTm = await self.ordertmproductDao.create(orderProductObj, t);//创建商标订单
            }
          });
        }
      }
    }
  }

  async pushFqBusiness(action_body, pobj, req) {
    var rc = system.getObject("util.aliyunClient");
    var item = await this.dao.getItemByChannelServiceNo(action_body.channelServiceNo, req.app.id);
    if (!item) {
      return system.getResult(null, "没有找到相关订单信息");
    }
    if (item.itemCode != "fzsbzc") {
      return system.getResult(null, "订单类型有误，请推送商标注册-专家辅助申请的订单");
    }
    if (item.buyerMoblie) {
      return system.getResult(null, "订单已经推送过，请勿重覆推送");
    }
    var rtn = null;
    var reqUrl = "https://yunfuapi.gongsibao.com/crm/order/submit";
    try {
      var body = {
        idempotentId: item.channelServiceNo,// 是 业务 ID
        idempotentSource: req.app.appSourceCode ? "tm_" + req.app.appSourceCode : "tm_1688",// 是 业务来源（ali、jd）
        idempotentSourceName: req.app.name || "1688应用",// 是 阿里，京东
        city: "",// 否 所属城市
        phone: action_body.buyerMoblie,// 是 手机号
        userId: item.channelUserId,// 否 用户 ID
        companyName: "",// 否 公司名称
        orderPrice: item.totalSum,// 是 订单金额
        productId: "5dc936eb296d1572b9bc5b8d",// 是 产品 ID
        productQuantity: item.salesNum,// 是 产品数量
      };
      rtn = await rc.post(reqUrl, body);
      this.logCtl.info({
        appid: req.app.id,
        appkey: req.app.uappKey,
        requestId: req.requestId || "",
        op: "/igirl-channel/zhichan/igirl-channel/app/base/service/impl/dborder/orderSve/pushFqBusiness",
        content: "请求地址：" + reqUrl + "，参数：" + JSON.stringify(body) + "，返回结果：" + JSON.stringify(rtn),
        clientIp: pobj.clientIp,
        optitle: "推送订单商机到FQ信息",
      });

      if (rtn.code != 200 && rtn.success != true) {
        return system.getResult(null, "推送失败，失败原因：" + rtn.errorMsg + "，selfrequestId=" + req.requestId + "，requestId=" + rtn.requestId);
      }
      await this.updateByWhere({ buyerMoblie: action_body.buyerMoblie }, { where: { channelServiceNo: action_body.channelServiceNo } });
      return system.getResultSuccess(null, "推送成功");
    } catch (e) {
      //日志记录
      this.logCtl.error({
        appid: req.app.id,
        appkey: req.app.uappKey,
        requestId: req.requestId || "",
        op: "/igirl-channel/zhichan/igirl-channel/app/base/service/impl/dborder/orderSve/pushFqBusiness",
        content: "error：" + e.stack,
        clientIp: pobj.clientIp,
        optitle: "推送订单商机到FQ出错",
      });
    }
  }
}
module.exports = OrderService;
