const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");

class CustomerInfoService extends ServiceBase {
  constructor() {
    super("dborder", ServiceBase.getDaoName(CustomerInfoService));
    this.ordertmproductSve = system.getObject("service.dborder.ordertmproductSve");
    this.trademarkDao = system.getObject("db.dbtrademark.trademarkDao");
  }
  /**
   * 修改申请人信息（订单详情页面使用）
   * @param {*} obj 
   * obj.deliveryOrderNo 交付订单号，
   * obj.customerType 申请人类型，
   * obj.name 公司名称或个人名称，
   * obj.code 社会统一信用代码，
   * obj.applyAddr 公司地址，
   * obj.zipCode 邮编
   * obj.identityCardPic 身份证图片,         
   * obj.businessLicensePic 营业执照图片,  
   * obj.identityCardPdf 身份证pdf,         
   * obj.businessLicensePdf 营业执照pdf,  
   * obj.user  用户数据
   */
  async updateCustomerInfo(obj){
    var user = obj.user;
    if(!user || !user.id){
      return system.getResultFail(-100, "未知用户");
    }
    var deliveryOrderNo = obj.deliveryOrderNo;
    if(!deliveryOrderNo){
      return system.getResultFail(-101, "deliveryOrderNo参数错误");
    }
    // 1.获取交付单信息
    var ordertmproduct = await this.ordertmproductSve.dao.model.findOne({
      where:{deliveryOrderNo:deliveryOrderNo},
      raw:true
    });
    if(!ordertmproduct || !ordertmproduct.id){
      return system.getResultFail(-102, "商标交付单不存在");
    }
    // 2.获取交付单状态，判断是否可修改
    if(ordertmproduct.deliveryStatus=='ddj' || ordertmproduct.deliveryStatus=='ywc'){
      var deliveryStatusName = "待递交";
      if(ordertmproduct.deliveryStatus=='ywc'){
        deliveryStatusName="已完成";
      }
      return system.getResultFail(-103, "该商标交付单状态为"+deliveryStatusName+",不能进行修改");
    }
    var customerinfo = await this.dao.model.findOne({
      where:{
        deliveryOrderNo:deliveryOrderNo
      },
      raw:true
    });
    if(!customerinfo || !customerinfo.id){
      return system.getResultFail(-104, "未知申请人");
    }
    var self = this;
    return await self.db.transaction(async function (t) {
      var ciObj={ id:customerinfo.id,updateuser_id:user.id };
      if(obj.customerType){
        ciObj["customerType"]=obj.customerType;
      }
      if(obj.name){
        ciObj["name"]=obj.name;
      }
      if(obj.code){
        ciObj["code"]=obj.code;
      }
      if(obj.identityCardNo){
        ciObj["identityCardNo"]=obj.identityCardNo;
      }
      if(obj.applyAddr){
        ciObj["applyAddr"]=obj.applyAddr;
      }
      if(obj.zipCode){
        ciObj["zipCode"]=obj.zipCode;
      }
      if(obj.businessLicensePic){
        ciObj["businessLicensePic"]=obj.businessLicensePic;
      }
      if(obj.identityCardPic){
        ciObj["identityCardPic"]=obj.identityCardPic;
      }
      if(obj.businessLicensePdf){
        ciObj["businessLicensePdf"]=obj.businessLicensePdf;
      }
      if(obj.identityCardPdf){
        ciObj["identityCardPdf"]=obj.identityCardPdf;
      }
      await self.dao.update(ciObj,t);//修改申请人信息
      var customerinfo2 = await self.dao.model.findOne({
        where:{
          id:customerinfo.id
        },
        raw:true
      });
      if(ordertmproduct.gzwtsUrl && customerinfo2.businessLicensePdf && (customerinfo2.customerType=="ent" || customerinfo2.identityCardPdf)){
        // otpObj["deliveryStatus"]="dsh";
        if(ordertmproduct.deliveryStatus=="dsccl"){
          await self.ordertmproductSve.update({id:ordertmproduct.id,deliveryStatus:"dsh"},t);
        }
        await self.trademarkDao.model.update({officialType:"dsh"},{where:{deliveryOrderNo:deliveryOrderNo},transaction:t});
      }
      return system.getResultSuccess();
    })
  }
  /**
   * 修改交官文件
   * @param {*} obj 
   * obj.deliveryOrderNo 交付单号，
   * obj.gzwtsUrl 盖章委托书，
   * obj.smwjUrl 说明文件,
   * obj.identityCardPic 身份证图片,         
   * obj.businessLicensePic 营业执照图片,  
   * obj.identityCardPdf 身份证pdf,         
   * obj.businessLicensePdf 营业执照pdf,  
   * obj.user  用户数据
   */
  async updateOfficial(obj){
    var user = obj.user;
    if(!user || !user.id){
      return system.getResultFail(-100, "未知用户");
    }
    var deliveryOrderNo = obj.deliveryOrderNo;
    if(!deliveryOrderNo){
      return system.getResultFail(-101, "deliveryOrderNo参数错误");
    }
    // 1.获取交付单信息
    var ordertmproduct = await this.ordertmproductSve.dao.model.findOne({
      where:{deliveryOrderNo:deliveryOrderNo},
      raw:true
    });
    if(!ordertmproduct || !ordertmproduct.id){
      return system.getResultFail(-102, "商标交付单不存在");
    }
    // 2.获取交付单状态，判断是否可修改
    if(ordertmproduct.deliveryStatus=='ddj' || ordertmproduct.deliveryStatus=='ywc'){
      var deliveryStatusName = "待递交";
      if(ordertmproduct.deliveryStatus=='ywc'){
        deliveryStatusName="已完成";
      }
      return system.getResultFail(-103, "该商标交付单状态为"+deliveryStatusName+",不能进行修改");
    }
    var customerinfo = await this.dao.model.findOne({
      where:{
        deliveryOrderNo:deliveryOrderNo
      },
      raw:true
    });
    if(!customerinfo || !customerinfo.id){
      return system.getResultFail(-104, "未知申请人");
    }
    var self = this;
    return await self.db.transaction(async function (t) {
      var ciObj={ id:customerinfo.id,updateuser_id:user.id };
      
      if(obj.businessLicensePic){
        ciObj["businessLicensePic"]=obj.businessLicensePic;
      }
      if(obj.identityCardPic){
        ciObj["identityCardPic"]=obj.identityCardPic;
      }
      if(obj.businessLicensePdf){
        ciObj["businessLicensePdf"]=obj.businessLicensePdf;
      }
      if(obj.identityCardPdf){
        ciObj["identityCardPdf"]=obj.identityCardPdf;
      }

      await self.dao.update(ciObj,t);//申请人信息 修改营业执照、身份证文件
      var customerinfo2 = await self.dao.model.findOne({
        where:{
          id:customerinfo.id
        },
        raw:true
      });
      var otpObj={
        id:ordertmproduct.id,
        updateuser_id:user.id,
        updateuser:user.nickname
      };
      if(obj.gzwtsUrl){
        otpObj["gzwtsUrl"]=obj.gzwtsUrl;
      }
      if(obj.smwjUrl){
        otpObj["smwjUrl"]=obj.smwjUrl;
      }
      if((ordertmproduct.gzwtsUrl || otpObj["gzwtsUrl"]) && customerinfo2.businessLicensePdf && (customerinfo2.customerType=="ent" || customerinfo2.identityCardPdf)){
        if(ordertmproduct.deliveryStatus=="dsccl"){
          otpObj["deliveryStatus"]="dsh";
        }
        await self.trademarkDao.model.update({officialType:"dsh"},{where:{deliveryOrderNo:deliveryOrderNo},transaction:t});
      
      }
      await self.ordertmproductSve.update(otpObj,t);//商标交付单 修改盖章委托书、说明文件
      return system.getResultSuccess();
    })
  }
}
module.exports=CustomerInfoService;
