const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("trademark", {
    tbCode           :DataTypes.STRING(50),     //提报号(自动生成)                                                                                                                                                                                                                                                                                                                                                                                                                                                  
    nclOneCodes      :DataTypes.STRING(10),     //尼斯大类                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
    nclSmallCodes    :DataTypes.TEXT('long'),   //尼斯小类                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
    submitTime       :DataTypes.DATE,           //提报时间                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
    tmRegistNum      :DataTypes.STRING(50),     //注册号                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
    officialTypeName :DataTypes.STRING(50),     //                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
    officialType     : {
          type: DataTypes.ENUM,
          values: Object.keys(uiconfig.config.pdict.official_type),
          set: function (val) {
            this.setDataValue("officialType", val);
            this.setDataValue("officialTypeName", uiconfig.config.pdict.official_type[val]);
          }
    },     //商标官文类型：1: 商标注册申请书, 2: 商标注册申请补正通知书, 3: 商标注册申请受理通知书, 4: 商标注册申请不予受理通知书, 
          //5: 商标注册同日申请补送使用证据通知书,6: 商标注册同日申请协商通知书商标注册同日申请抽签通知书, 
          //7: 商标驳回通知书, 8: 商标部分驳回通知书, 9: 商标注册申请初步审定公告通知书,                                                                                                                                                                                                                                                                                                                                 
          //10: 商标异议答辩通知书, 11: 异议裁定书, 12: 纸质版商标注册证, 13: 电子版商标注册证  
          // "dsccl": "待上传材料", "dsh": "待审核", "shbtg": "审核不通过", "ddj": "待递交", "ydj": "已递交", "djyc": "递交异常"                                                                                                                                                                                                                                                                                                                                                                                                            //  
    tbKey            :DataTypes.STRING(50),     //                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
    tbErrorCount     :DataTypes.INTEGER,        //                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
    deliveryOrderNo  :DataTypes.STRING(64),     //交付订单号 
    bizNo            :DataTypes.STRING(64),     //业务单号，用于对接第三方业务单号                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
    app_id           :DataTypes.INTEGER,        //                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
    createuser_id    :DataTypes.INTEGER,        //                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
    updateuser_id    :DataTypes.INTEGER,        //   
    owner_id         :DataTypes.INTEGER,        //                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
    creator          :DataTypes.STRING(50),     //                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
    updator          :DataTypes.STRING(50),     //         
    owner            :DataTypes.STRING(50),     //      
    ownerMoblie      :DataTypes.STRING(20),     //                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
    opNotes          :DataTypes.STRING(500),    //                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
    subErrorMsg      :DataTypes.STRING(4000),   // 提报错误信息                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
    payPublicExpense :DataTypes.INTEGER,        // 支付官费,0否，1是                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
    nclCount         :DataTypes.INTEGER,        // 尼斯数量                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
    nclPublicExpense :DataTypes.DECIMAL(12, 2),  // 尼斯官费总额
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      //freezeTableName: true,
      // define the table's name
      tableName: 'b_trademark',
      validate: {

      },
      indexes: [
     
      ]
    });
}
