const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("ordertmproduct", {
    app_id: DataTypes.INTEGER,//
    productType_id: DataTypes.INTEGER,//产品类型Id
    productOneType_id: DataTypes.INTEGER,//产品大类Id
    itemCode: DataTypes.STRING(64),//产品编码
    itemName: DataTypes.STRING(100),//产品名称
    tmName: DataTypes.STRING(1000),//商标名称
    tmType: {
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tm_type),
    },//p:普通商标,j:集体商标,z:证明商标,t:特殊商标
    tmFormTypeName: DataTypes.STRING(50),//
    tmFormType: {
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tm_form_type),
      set: function (val) {
        this.setDataValue("tmFormType", val);
        this.setDataValue("tmFormTypeName", uiconfig.config.pdict.tm_form_type[val]);
      }
    },//商标类型形式：1:立体,3:字,4:图,5:字图,6:颜色,7:彩色
    nclOneCodes: DataTypes.STRING,//尼斯大类列表：格式以,隔开
    payStatusName: DataTypes.STRING(50),//
    payStatus: {
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.order_service_pay_status),
      set: function (val) {
        this.setDataValue("payStatus", val);
        this.setDataValue("payStatusName", uiconfig.config.pdict.order_service_pay_status[val]);
      }
    },//支付状态:dfk:待付款,yzf:已支付
    deliveryStatusName: DataTypes.STRING(50),//
    deliveryStatus: {
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.delivery_status),
      set: function (val) {
        this.setDataValue("deliveryStatus", val);
        this.setDataValue("deliveryStatusName", uiconfig.config.pdict.delivery_status[val]);
      }
    },//商标交付状态：dsccl:待上传材料,dsh:待审核,ddj:待递交, ydj: 已递交,ywc:已完成
    appDataOpType: {
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.app_data_op_type),
    },//应用数据操作类型：00独立，10全委托，20部分委托
    sourceOrderNo: DataTypes.STRING(64),//来源单号
    deliveryOrderNo: DataTypes.STRING(64),//交付订单号
    channelServiceNo: DataTypes.STRING(64),//渠道服务单号
    channelOrderNo: DataTypes.STRING(1024),//渠道订单号列表，多个以,隔开
    needNo: DataTypes.STRING(64),//需求单号
    sourceType: DataTypes.STRING(10),//来源类型：00订单，10需求需要用户确认方案
    picUrl: DataTypes.STRING(500),         //商标图样
    colorizedPicUrl: DataTypes.STRING(500),//商标彩色图样
    gzwtsUrl: DataTypes.STRING(500),       //盖章委托书
    sywjUrl: DataTypes.STRING(500),        //声音文件
    smwjUrl: DataTypes.STRING(500),        //说明文件
    channelUserId: DataTypes.STRING(64),//渠道用户ID
    notes: DataTypes.STRING(255),//备注
    createuser_id: DataTypes.INTEGER,//
    updateuser_id: DataTypes.INTEGER,//
    auditor_id: DataTypes.INTEGER,//
    createuser: DataTypes.STRING(100),//
    updateuser: DataTypes.STRING(100),//
    auditor: DataTypes.STRING(100),//   
    nclOneCount: DataTypes.INTEGER,        // 尼斯大类数量
    nclCount: DataTypes.INTEGER,        // 尼斯数量
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      //freezeTableName: true,
      // define the table's name
      tableName: 'b_order_tm_product',
      validate: {

      },
      indexes: [
      ]
    });
}
