const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("appuser", {
    app_id          : DataTypes.INTEGER,        //  应用id               
    channelUserId   : DataTypes.STRING(64),         //  渠道用户ID         
    channelUserName : DataTypes.STRING(64),     //  渠道用户登录名  
    uUserName       : DataTypes.STRING(64),         //  
    uAppId          : DataTypes.INTEGER,        //     
    userMoblie      : DataTypes.STRING(20),     //  用户手机号        
    nickname        : DataTypes.STRING(50),     //  昵称                 
    orgName         : DataTypes.STRING(255),    //  组织结构名称     
    orgPath         : DataTypes.STRING(255),    //  组织结构路径     
    isEnabled       : DataTypes.INTEGER,        //  是否启用           
    loginNum        : DataTypes.INTEGER,        //  登录次数  
    lastLoginTime   : DataTypes.DATE,           //  上次登录时间       
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      //freezeTableName: true,
      // define the table's name
      tableName: 'c_app_user',
      validate: {

      },
      indexes: [
      ]
    });
}
