const system = require("../../../system");
const Dao = require("../../dao.base");
class ReceiptVoucherDao extends Dao {
  constructor() {
    super(Dao.getModelName(ReceiptVoucherDao));
  }
  async getItemSourceOrderNo(sourceOrderNo) {
    return this.model.findAll({
      where: {
        sourceOrderNo: sourceOrderNo
      },
      raw: true
    });
  }
  async addReceiptvoucher(orderParams, req, t) {
    var param = {
      app_id: req.app.id,//  
      totalSum: orderParams.totalSum || 0,// 订单总额(产品价格×优惠费率×订单件数)   
      channelServiceNo: orderParams.channelServiceNo,// 渠道服务单号    
      auditStatus: "tg",
      sourceType: "order",
      sourceOrderNo: orderParams.orderNo,// 来源订单号                                      
      payDate: orderParams.payTime,//
      createuser_id: req.user.id,
      creator: orderParams.creator || "",
      accountType: "other",
    };
    return this.create(param, t);//创建订单
  }
}
module.exports = ReceiptVoucherDao;
