const system = require("../../../system");
const Dao = require("../../dao.base");
class AppProductDao extends Dao {
  constructor() {
    super(Dao.getModelName(AppProductDao));
  }
  async findOneByCode(itemCode, appId) {
    return this.model.findOne({
      where: {
        itemCode: itemCode,
        app_id: appId
      },
      attributes: ["id",
        "app_id",           //  应用id                                                           
        "itemCode",           //  产品编码                                                       
        "itemName",           //  产品名称                                                       
        "picUrl",            //  产品图片地址                                                 
        "channelItemCode",    //  渠道产品编码                                                 
        "channelItemName",    //  渠道产品名称                                                       
        "status",            //  状态 0禁用 1启用                                             
        "verifyPrice",       //  是否验证价格 0不验证 1验证                              
        "proPrice",          //  产品价格                                                       
        "serviceCharge",     //  服务费                                                          
        "publicExpense",     //  官费                                                             
        "rateConfig",        //  税率                                                             
        "discountsRateConfig",// 优惠税率                                                       
        "channelProfitRate",//  渠道利润分成比率(只分订单中毛利润总额的分成)  
        "sort",
        "productType_id",
        "productOneType_id"],
      raw: true
    });
  }
  async findOneByChannelItemCode(channelItemCode, appId) {
    return this.model.findOne({
      where: {
        channelItemCode: channelItemCode,
        app_id: appId
      },
      attributes: ["id",
        "app_id",           //  应用id                                                           
        "itemCode",           //  产品编码                                                       
        "itemName",           //  产品名称                                                       
        "picUrl",            //  产品图片地址                                                 
        "channelItemCode",    //  渠道产品编码                                                 
        "channelItemName",    //  渠道产品名称                                                       
        "status",            //  状态 0禁用 1启用                                             
        "verifyPrice",       //  是否验证价格 0不验证 1验证                              
        "proPrice",          //  产品价格                                                       
        "serviceCharge",     //  服务费                                                          
        "publicExpense",     //  官费                                                             
        "rateConfig",        //  税率                                                             
        "discountsRateConfig",// 优惠税率                                                       
        "channelProfitRate",//  渠道利润分成比率(只分订单中毛利润总额的分成)  
        "sort",
        "productType_id",
        "productOneType_id"],
      raw: true
    });
  }  
}
module.exports = AppProductDao;
