const config = require('../../config/aliRpc');
const RPCClient = require('@alicloud/pop-core').RPCClient;

class AliRpc {
    constructor(apiVersion) {
        this.apiVersion = apiVersion || config.apiVersion;
    }

    getClient() {
        return new RPCClient({
            accessKeyId: config.accessKeyId,
            accessKeySecret: config.accessKeySecret,
            endpoint: config.endpoint,
            apiVersion: this.apiVersion
        });
    }

}

module.exports = AliRpc;