var system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const uuidv4 = require('uuid/v4');
const logCtl = system.getObject("service.common.oplogSve");
//商标查询操作
class UtilsNeedSve extends AppServiceBase {
  constructor() {
    super();
    this.execlient = system.getObject("util.execClient");
    this.channelApiUrl = settings.channelApiUrl();
    this.centerChannelUrl = settings.centerChannelUrl();
    this.appInfo = {
      aliyuntmtransfer: { appkey: settings.appKey, secret: settings.secret }
    };
  }


  async getCenterToken() {
    var self = this;
    var reqTokenUrl = this.centerChannelUrl + "/api/opreceive/accessAuth/getAppTokenByAppKey";
    var reqParam = self.appInfo["aliyuntmtransfer"];
    if (!reqParam.appkey || !reqParam.secret) {
      return system.getResult(null, "reqType类型有误，请求失败");
    }
    var param = {
      "actionType": "getAppTokenByAppKey",
      "actionBody": {
        "appkey": reqParam.appkey,
        "secret": reqParam.secret
      }
    };
    var rtn = await this.execlient.execPost(param, reqTokenUrl);
    if (!rtn.stdout) {
      return system.getResult(null, "获取token失败");
    }
    var tokenResult = JSON.parse(rtn.stdout);
    return tokenResult;
  }

  getUUID() {
    var uuid = uuidv4();
    var u = uuid.replace(/\-/g, "");
    return u;
  }

  async reqcenterchannel(pobj) {
    var sobj = {
      "actionType": pobj.action_type,
      "actionBody": pobj
    }
    var self = this;
    var tokenInfo = await this.getCenterToken();
    if (tokenInfo.status != 0) {
      return this.getResult(self.getUUID(), "getTokenInfo fail")
    }
    var userpin = "";
    if (pobj.phone && !pobj.mobile) {
      pobj.mobile = pobj.phone;
    }
    if (pobj.mobile) {
      //获取用户userpin
      var userparam = {
        actionType: "getLoginByUserName",
        actionBody: {
          "channelUserId": pobj.mobile,
          "mobile": pobj.mobile,
          "userName": pobj.mobile
        }
      };
      // pobj.actionBody.channelUserId = pobj.mobile;//渠道用户id，没有则用手机号
      // pobj.actionBody.mobile = pobj.mobile;//用户手机号
      var url = settings.centerChannelUrl() + "/api/opreceive/accessAuth/springBoard";
      var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
      if (userpinResultTmp.status != 0 && userpinResultTmp.status != 2060) {
        return system.getResultFail(-99, "获取userpin失败");
      }
      userpin = userpinResultTmp.data.userpin;
      if (!userpin) {
        return system.getResultFail(-88, "获取userpin失败!!");
      }

    }
    //带userpin请求
    url = settings.centerChannelUrl() + "/api/opreceive/need/springBoard";
    var token = tokenInfo.data.token;
    var rtn = null;
    var self = this;
    if (userpin) {
      rtn = await self.execlient.execDataPostByTokenUserPin(sobj, url, token, userpin);
    } else {
      rtn = await self.execlient.execPostTK(sobj, url, token);
      if (rtn.status == 0) {
        return this.getResult(rtn.requestId)
      } else {
        return this.getResult(rtn.requestId, rtn.msg)
      }
    }
    if (!rtn || !rtn.stdout) {
      return this.getResult(self.getUUID(), "网络错误")
    }

    var result = JSON.parse(rtn.stdout);
    if (result.status == 0) {
      return this.getResult(result.requestId)
    } else {
      return this.getResult(result.requestId, result.msg)
    }
  }

  // -------------提交Icp需求--------庄冰2020.10.21-------百度Icp接入使用--------start------------------
  async getCenterTokenByApp(appinfo) {
    var self = this;
    var reqTokenUrl = this.centerChannelUrl + "/api/opreceive/accessAuth/getAppTokenByAppKey";
    var reqParam = appinfo;
    if (!reqParam || !reqParam.uapp_key || !reqParam.uapp_secret) {
      return system.getResult(null, "reqType类型有误，请求失败");
    }
    var param = {
      "actionType": "getAppTokenByAppKey",
      "actionBody": {
        "appkey": reqParam.uapp_key,
        "secret": reqParam.uapp_secret
      }
    };

    var rtn = await this.execlient.execPost(param, reqTokenUrl);
    if (!rtn.stdout) {
      return system.getResult(null, "获取token失败");
    }
    var tokenResult = JSON.parse(rtn.stdout);
    return tokenResult;
  }
  /**
   * @description 与reqcenterchannel方法的差别在于获取token方法不一样
   * @param {*} pobj 
   */
  async reqcenterchannel2(pobj) {
    var sobj = {
      "actionType": pobj.action_type,
      "actionBody": pobj
    }
    if (!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret) {
      return this.getResult(self.getUUID(), "无效应用")
    }
    var self = this;
    var tokenInfo = await this.getCenterTokenByApp(pobj.appInfo);
    if (tokenInfo.status != 0) {
      return this.getResult(self.getUUID(), "getTokenInfo fail")
    }
    var userpin = "";
    if (pobj.phone && !pobj.mobile) {
      pobj.mobile = pobj.phone;
    }
    if (pobj.mobile) {
      //获取用户userpin
      var userparam = {
        actionType: "getLoginByUserName",
        actionBody: {
          "channelUserId": pobj.mobile,
          "mobile": pobj.mobile,
          "userName": pobj.mobile
        }
      };
      // pobj.actionBody.channelUserId = pobj.mobile;//渠道用户id，没有则用手机号
      // pobj.actionBody.mobile = pobj.mobile;//用户手机号
      var url = settings.centerChannelUrl() + "/api/opreceive/accessAuth/springBoard";
      var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
      if (userpinResultTmp.status != 0 && userpinResultTmp.status != 2060) {
        return system.getResultFail(-99, "获取userpin失败");
      }
      userpin = userpinResultTmp.data.userpin;
      if (!userpin) {
        return system.getResultFail(-88, "获取userpin失败!!");
      }

    }
    //带userpin请求
    url = settings.centerChannelUrl() + "/api/opreceive/need/springBoard";
    var token = tokenInfo.data.token;
    var rtn = null;
    var self = this;
    if (userpin) {
      rtn = await self.execlient.execDataPostByTokenUserPin(sobj, url, token, userpin);
    } else {
      rtn = await self.execlient.execPostTK(sobj, url, token);
      if (rtn.status == 0) {
        return this.getResult(rtn.requestId)
      } else {
        return this.getResult(rtn.requestId, rtn.msg)
      }
    }
    if (!rtn || !rtn.stdout) {
      return this.getResult(self.getUUID(), "网络错误")
    }

    var result = JSON.parse(rtn.stdout);
    if (result.status == 0) {
      return this.getResult(result.requestId)
    } else {
      return this.getResult(result.requestId, result.msg)
    }
  }
  //百度icp 2.3 请求
  async icpOrderStatus(pobj) {
    var self = this;
    if (!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret) {
      return this.getResult(self.getUUID(), "无效应用")
    }
    // 获取app token
    // var tokenInfo = await this.getCenterToken();
    var tokenInfo = await this.getCenterTokenByApp(pobj.appInfo);
    if (tokenInfo.status != 0) {
      return this.getResult(self.getUUID())
    }
    var token = tokenInfo.data.token;
    // 引用属性，channel依赖bizId order依赖intentionBizId
    pobj.intentionBizId = pobj.bizId
    // 获取userpin
    var userparam = {
      actionType: "getLoginByUserName",
      actionBody: {}
    };
    if (pobj.isDirectBuy == 1) {//直购
      userparam.actionBody.channelUserId = pobj.phone
      userparam.actionBody.mobile = pobj.phone
      userparam.actionBody.userName = pobj.phone
      pobj.publishMobile = pobj.phone
      pobj.channelTypeCode = pobj.consultType;
      if (pobj.area) {
        switch (pobj.area) {
          case "1":
            pobj.area = "北京";
            break;
          case "2":
            pobj.area = "上海";
            break;
          case "3":
            pobj.area = "福建";
            break;
          case "4":
            pobj.area = "广西";
            break;
          case "5":
            pobj.area = "广东";
            break;
          case "6":
            pobj.area = "安徽";
            break;
          case "7":
            pobj.area = "河南";
            break;
          case "8":
            pobj.area = "湖北";
            break;
          case "9":
            pobj.area = "浙江";
            break;
          case "10":
            pobj.area = "江苏";
            break;
          case "11":
            pobj.area = "山东";
            break;
          case "12":
            pobj.area = "陕西";
            break;
          case "13":
            pobj.area = "宁夏";
            break;
          case "14":
            pobj.area = "甘肃";
            break;
          case "15":
            pobj.area = "新疆";
            break;
          case "16":
            pobj.area = "青海";
            break;
          case "17":
            pobj.area = "天津";
            break;
          case "18":
            pobj.area = "重庆";
            break;
          case "19":
            pobj.area = "河北";
            break;
          case "20":
            pobj.area = "山西";
            break;
          case "21":
            pobj.area = "辽宁";
            break;
          case "22":
            pobj.area = "吉林";
            break;
          case "23":
            pobj.area = "黑龙江";
            break;
          case "24":
            pobj.area = "江西";
            break;
          case "25":
            pobj.area = "湖南";
            break;
          case "26":
            pobj.area = "四川";
            break;
          case "27":
            pobj.area = "贵州";
            break;
          case "28":
            pobj.area = "云南";
            break;
          case "29":
            pobj.area = "内蒙古";
            break;
          case "30":
            pobj.area = "西藏";
            break;
          case "31":
            pobj.area = "含外资";
            break;
          case "32":
            pobj.area = "全外资";
            break;
          case "33":
            pobj.area = "香港";
            break;
          case "34":
            pobj.area = "海南";
            break;
          case "QUANGUO":
            pobj.area = "全国";
            break;
          case "GUANGZHOU":
            pobj.area = "广州";
            break;
          case "SHENZHEN":
            pobj.area = "深圳";
            break;
          default:
            pobj.area = "";
            break;
        }
      }
      pobj.province = pobj.area;
    } else {
      var sobj = {
        "actionType": "getItemByChannelSolutionNo",
        "actionBody": pobj
      }
      // getItemByChannelSolutionNo
      var url = settings.centerChannelUrl() + "/api/opreceive/need/springBoard";
      var result = await this.execlient.execPostTK(sobj, url, token);
      if (result.status != 0) {
        return this.getResult(result.requestId, result.msg)
      }
      userparam.actionBody.channelUserId = result.data.channelUserId
      userparam.actionBody.mobile = result.data.publishMobile
      userparam.actionBody.userName = result.data.publishMobile
      pobj.publishMobile = result.data.publishMobile;
      pobj.channelNeedNo = result.data.channelNeedNo;
      pobj.needNo = result.data.needNo;
      pobj.channelTypeCode = result.data.channelTypeCode;
      pobj.province = result.data.solutionProvince;//北京(新购)?
    }
    var url = settings.centerChannelUrl() + "/api/opreceive/accessAuth/springBoard";
    var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
    if (userpinResultTmp.status != 0) {
      return this.getResult(userpinResultTmp.requestId, userpinResultTmp.msg)
    }
    // icpNotify
    var url = settings.centerChannelUrl() + "/api/opreceive/need/springBoard";
    var sobj = {
      "actionType": "icpNotifyNew",
      "actionBody": pobj
    }
    var rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpinResultTmp.data.userpin);
    if (!rtn || !rtn.stdout) {
      return this.getResult(self.getUUID(), "网络错误")
    }
    var result = JSON.parse(rtn.stdout);
    if (result.status != 0) {
      return this.getResult(result.requestId, result.msg)
    }
    return this.getResult(result.requestId)
  }
  //百度icp 2.4 请求 关闭icp订单
  async icpOrderClose(pobj) {
    var self = this;
    if (!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret) {
      return this.getResult(self.getUUID(), "无效应用")
    }
    // 获取app token
    // var tokenInfo = await this.getCenterToken();
    var tokenInfo = await this.getCenterTokenByApp(pobj.appInfo);
    if (tokenInfo.status != 0) {
      return this.getResult(self.getUUID())
    }
    var token = tokenInfo.data.token;
    var sobj = {
      "actionType": "getSolutionByChannelOrderNo",
      "actionBody": pobj
    }
    // getSolutionByChannelOrderNo
    var url = settings.centerChannelUrl() + "/api/opreceive/need/springBoard";
    var result = await this.execlient.execPostTK(sobj, url, token);
    if (result.status != 0 || !result.data) {
      return this.getResult(result.requestId, result.msg)
    }
    //阿里方案没有手机号，就从订单信息里拿
    if (!result.data.solutionContent || !result.data.solutionContent.customerInfo || !result.data.solutionContent.customerInfo.publishMobile) {
      // getOrderInfoByChannelOrderNo
      var sobj1 = {
        "actionType": "getOrderInfoByChannelOrderNo",
        "actionBody": pobj
      }
      var url1 = settings.centerChannelUrl() + "/api/opreceive/need/springBoard";
      var result1 = await this.execlient.execPostTK(sobj1, url1, token);
      if (result1.status != 0 || !result1.data) {
        return this.getResult(result1.requestId, result1.msg)
      }
       // 获取userpin
       var userparam = {
        actionType: "getLoginByUserName",
        actionBody: {
          channelUserId: result1.data.channelUserId,
          mobile: result1.data.channelUserId,
          userName: result1.data.channelUserId
        }
      };
      // return this.getResult(result.requestId, "方案客户信息有误")
    } else {
      // 获取userpin
      var userparam = {
        actionType: "getLoginByUserName",
        actionBody: {
          channelUserId: result.data.solutionContent.customerInfo.publishMobile,
          mobile: result.data.solutionContent.customerInfo.publishMobile,
          userName: result.data.solutionContent.customerInfo.publishMobile
        }
      };
    }
    var url = settings.centerChannelUrl() + "/api/opreceive/accessAuth/springBoard";
    var userpinResultTmp = await this.execlient.execPostTK(userparam, url, token);
    if (userpinResultTmp.status != 0) {
      return this.getResult(userpinResultTmp.requestId, userpinResultTmp.msg)
    }
    var closeobj = {
      "actionType": "icpOrderClose",
      "actionBody": pobj
    }
    var url = settings.centerChannelUrl() + "/api/opreceive/need/springBoard";
    var rtn = await this.execlient.execDataPostByTokenUserPin(closeobj, url, token, userpinResultTmp.data.userpin);
    if (!rtn || !rtn.stdout) {
      return this.getResult(self.getUUID(), "网络错误")
    }
    var result = JSON.parse(rtn.stdout);
    if (result.status != 0) {
      return this.getResult(result.requestId, result.msg)
    }
    return this.getResult(result.requestId)
  }
  // -------------提交Icp需求--------庄冰2020.10.21-------百度Icp接入使用--------end------------------
  async paySuccess(pobj) {
    var sobj = {
      "actionType": pobj.action_type,
      "actionBody": pobj
    }
    var tokenInfo = await this.getCenterToken();
    if (tokenInfo.status != 0) {
      return this.getResult(self.getUUID())
      // return { "message": "success", "data": {}, "code": 200 }
    }
    var userpin = "";
    if (pobj.phone) {
      //获取用户userpin
      var userparam = {
        actionType: "getLoginByUserName",
        actionBody: {
          "channelUserId": pobj.phone,
          "mobile": pobj.phone,
          "userName": pobj.phone
        }
      };
      var self = this;
      // pobj.actionBody.channelUserId = pobj.mobile;//渠道用户id，没有则用手机号
      // pobj.actionBody.mobile = pobj.mobile;//用户手机号
      var url = settings.centerChannelUrl() + "/api/auth/accessAuth/springBoard";
      var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
      if (userpinResultTmp.status != 0 && userpinResultTmp.status != 2060) {
        // return { "message": "网络错误", "data": {}, "code": -102 }
        return this.getResult(self.getUUID(), "网络错误")
      }
      userpin = userpinResultTmp.data.userpin;
      if (!userpin) {
        // return { "message": "网络错误", "data": {}, "code": -102 }
        return this.getResult(self.getUUID(), "网络错误")
      }
    }
    //带userpin请求
    url = settings.centerChannelUrl() + "/api/opreceive/ic/springBoard";
    var token = tokenInfo.data.token;
    var rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpin);
    if (!rtn || !rtn.stdout) {
      // return { "message": "网络错误", "data": {}, "code": -102 }
      return this.getResult(self.getUUID(), "网络错误")
    }
    var result = JSON.parse(rtn.stdout);
    if (result.status == 0) {
      // return { "message": "true", "data": {}, "code": 200 }
      return this.getResult(result.requestId)
    } else {
      // return { "message": result.msg, "data": {}, "code": -102 }
      return this.getResult(result.requestId, result.msg)
    }
  }

  async orderClose(pobj) {
    var sobj = {
      "actionType": pobj.action_type,
      "actionBody": pobj
    }
    var self = this;
    var tokenInfo = await this.getCenterToken();
    if (tokenInfo.status != 0) {
      return this.getResult(self.getUUID())
    }

    var url = settings.centerChannelUrl() + "/api/opreceive/ic/springBoard";
    var token = tokenInfo.data.token;
    var rtn = await self.execlient.execPostTK(sobj, url, token);
    if (rtn.status == 0) {
      return this.getResult(rtn.requestId)
    } else {
      return this.getResult(rtn.requestId, rtn.msg)
    }
  }
  //商标建案后通知启服通保存TM_单号
  async tmNotifyChannel(pobj) {
    var tokenInfo = await this.getCenterToken();
    if (tokenInfo.status != 0) {
      return this.getResult(self.getUUID())
    }
    var token = tokenInfo.data.token;
    pobj.intentionBizId = pobj.bizId
    // 获取userpin
    var userparam = {
      actionType: "getLoginByUserName",
      actionBody: {}
    };
    var sobj = {
      "actionType": "getItemByChannelNeedNo",
      "actionBody": pobj
    }
    // getItemByChannelSolutionNo
    var url = settings.centerChannelUrl() + "/api/opreceive/need/springBoard";
    var result = await this.execlient.execPostTK(sobj, url, token);
    if (result.status != 0) {
      return this.getResult(result.requestId, result.msg)
    }
    userparam.actionBody.channelUserId = result.data.channelUserId
    userparam.actionBody.mobile = result.data.publishMobile
    userparam.actionBody.userName = result.data.publishMobile
    pobj.publishMobile = result.data.publishMobile;
    pobj.channelNeedNo = result.data.channelNeedNo;
    pobj.needNo = result.data.needNo;
    pobj.channelTypeCode = result.data.channelTypeCode;
    pobj.province = result.data.solutionProvince;
    var url = settings.centerChannelUrl() + "/api/opreceive/accessAuth/springBoard";
    var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
    if (userpinResultTmp.status != 0) {
      return this.getResult(userpinResultTmp.requestId, userpinResultTmp.msg)
    }
    var url = settings.centerChannelUrl() + "/api/opreceive/need/springBoard";
    var sobj = {
      "actionType": "tmNotifySub",
      "actionBody": pobj
    }
    var rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpinResultTmp.data.userpin);
    if (!rtn || !rtn.stdout) {
      return this.getResult(this.getUUID(), "网络错误")
    }
    var result = JSON.parse(rtn.stdout);
    if (result.status != 0) {
      return this.getResult(result.requestId, result.msg)
    }
    return this.getResult(result.requestId)
  }
  //icp 2.3 请求
  async queryOrderState(pobj) {
    var self = this;
    // 获取app token
    var tokenInfo = await this.getCenterToken();
    if (tokenInfo.status != 0) {
      return this.getResult(self.getUUID())
    }
    var token = tokenInfo.data.token;
    // 引用属性，channel依赖bizId order依赖intentionBizId
    pobj.intentionBizId = pobj.bizId
    // 获取userpin
    var userparam = {
      actionType: "getLoginByUserName",
      actionBody: {}
    };
    if (pobj.isDirectBuy === "true") {//直购
      if (!pobj.mobile) {
        var sobj = {
          "actionType": "getSolutionByChannelSolutionNo",
          "actionBody": pobj
        }
        var url = settings.centerChannelUrl() + "/api/opreceive/need/springBoard";
        var result = await this.execlient.execPostTK(sobj, url, token);
        if (result.status != 0) {
          return this.getResult(result.requestId, result.msg)
        }
        pobj.mobile = result.data.solutionContent.customerInfo.publishMobile
      }
      userparam.actionBody.channelUserId = pobj.mobile
      userparam.actionBody.mobile = pobj.mobile
      userparam.actionBody.userName = pobj.mobile
      pobj.publishMobile = pobj.mobile
      pobj.channelTypeCode = pobj.bizId.startsWith("EDI") ? 7 : 5;
      //pobj.province = pobj.companyLocation+`（${pobj.actionType}）`
      pobj.province = pobj.area
    } else {
      var sobj = {
        "actionType": "getItemByChannelSolutionNo",
        "actionBody": pobj
      }
      // getItemByChannelSolutionNo
      var url = settings.centerChannelUrl() + "/api/opreceive/need/springBoard";
      var result = await this.execlient.execPostTK(sobj, url, token);
      if (result.status != 0) {
        if (pobj.bizId.startsWith("TM_")) {
          let pushres = await this.execPostUrl({ "actionProcess": "AliTm", "appCode": "100099", "sign": await this.getFQbossSign(pobj), actionBody: pobj }, settings.fqbossTmUrl())
          console.log("商标没查到方案，直接推送fqboos----->", pushres)
          return this.getResult(result.requestId, pushres.message)
        }
        return this.getResult(result.requestId, result.msg)
      }
      userparam.actionBody.channelUserId = result.data.channelUserId
      userparam.actionBody.mobile = result.data.publishMobile
      userparam.actionBody.userName = result.data.publishMobile
      pobj.publishMobile = result.data.publishMobile;
      pobj.channelNeedNo = result.data.channelNeedNo;
      pobj.needNo = result.data.needNo;
      pobj.channelTypeCode = result.data.channelTypeCode;
      pobj.province = result.data.solutionProvince;//北京(新购)?
    }
    var url = settings.centerChannelUrl() + "/api/opreceive/accessAuth/springBoard";
    var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
    if (userpinResultTmp.status != 0) {
      return this.getResult(userpinResultTmp.requestId, userpinResultTmp.msg)
    }
    // icpNotify
    var url = settings.centerChannelUrl() + "/api/opreceive/need/springBoard";
    var sobj = {
      "actionType": "icpNotify",
      "actionBody": pobj
    }
    var rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpinResultTmp.data.userpin);
    if (!rtn || !rtn.stdout) {
      return this.getResult(self.getUUID(), "网络错误")
    }
    var result = JSON.parse(rtn.stdout);
    if (result.status != 0) {
      return this.getResult(result.requestId, result.msg)
    }
    return this.getResult(result.requestId)
  }

  // 2020 0925 lin 新增 阿里文网文 服务商侧提供接口2.1 提交用户需求给服务商
  async submitNeedAliEsp(pobj) {
    var tokenInfo = await this.getCenterToken();
    if (tokenInfo.status != 0) {
      return this.getResult(this.getUUID())
    }
    var token = tokenInfo.data.token;
    var userpin = "";
    if (pobj.mobile) {
      //获取用户userpin
      var userparam = {
        actionType: "getLoginByUserName",
        actionBody: {
          // 为什么2.1 有userId 但是不用 还要用mobile。因为模式不支持
          "channelUserId": pobj.mobile,
          "mobile": pobj.mobile,
          "userName": pobj.userName ? pobj.userName : pobj.mobile
        }
      };
      var self = this;
      var url = settings.centerChannelUrl() + "/api/auth/accessAuth/springBoard";
      var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
      if (userpinResultTmp.status != 0 && userpinResultTmp.status != 2060) {
        return this.getResult(self.getUUID(), "网络错误")
      }
      userpin = userpinResultTmp.data.userpin;
      if (!userpin) {
        // return { "message": "网络错误", "data": {}, "code": -102 }
        return this.getResult(self.getUUID(), "网络错误")
      }
    }
    //带userpin请求
    url = settings.centerChannelUrl() + "/api/opreceive/edi/springBoard";
    // 2020 0927 lin 新增 type 由 esp.wangwen 转换为 wangwen
    if (pobj.type == "esp.wangwen") {
      pobj.type == "wangwen"
    }
    var sobj = {
      "actionType": pobj.action_type,
      "actionBody": pobj
    }
    var rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpin);
    if (!rtn || !rtn.stdout) {
      return this.getResult(self.getUUID(), "网络错误")
    }
    var result = JSON.parse(rtn.stdout);
    if (result.status == 0) {
      return this.getResult(result.requestId)
    } else {
      return this.getResult(result.requestId, result.msg)
    }
  }

  // 2020 0926 lin 新增 阿里文网文 服务商侧提供接口2.2 关闭需求通知服务商
  async needCloseAliEsp(pobj) {
    var tokenInfo = await this.getCenterToken();
    if (tokenInfo.status != 0) {
      return this.getResult(self.getUUID())
    }
    var token = tokenInfo.data.token;
    var userpin = "";
    if (pobj.mobile) {
      //获取用户userpin
      var userparam = {
        actionType: "getLoginByUserName",
        actionBody: {
          "channelUserId": pobj.mobile,
          "mobile": pobj.mobile,
          "userName": pobj.userName ? pobj.userName : pobj.mobile
        }
      };
      var self = this;
      var url = settings.centerChannelUrl() + "/api/auth/accessAuth/springBoard";
      var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
      if (userpinResultTmp.status != 0 && userpinResultTmp.status != 2060) {
        return this.getResult(self.getUUID(), "网络错误")
      }
      userpin = userpinResultTmp.data.userpin;
      if (!userpin) {
        // return { "message": "网络错误", "data": {}, "code": -102 }
        return this.getResult(self.getUUID(), "网络错误")
      }
    }
    //带userpin请求
    url = settings.centerChannelUrl() + "/api/opreceive/edi/springBoard";
    var sobj = {
      "actionType": pobj.action_type,
      "actionBody": pobj
    }
    var rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpin);
    if (!rtn || !rtn.stdout) {
      return this.getResult(self.getUUID(), "网络错误")
    }
    var result = JSON.parse(rtn.stdout);
    if (result.status == 0) {
      return this.getResult(result.requestId)
    } else {
      return this.getResult(result.requestId, result.msg)
    }
  }

  // 2020 0927 lin 新增 阿里文网文 服务商侧提供接口2.3 服务单通知服务商
  async produceNoticeAliEsp(pobj) {
    var tokenInfo = await this.getCenterToken();
    if (tokenInfo.status != 0) {
      return this.getResult(this.getUUID())
    }
    var token = tokenInfo.data.token;
    var userpin = "";
    //带userpin请求
    var url = settings.centerChannelUrl() + "/api/opreceive/edi/springBoard";
    var sobj = {
      "actionType": pobj.action_type,
      "actionBody": pobj
    }
    var rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpin);
    if (!rtn || !rtn.stdout) {
      return this.getResult(self.getUUID(), "网络错误")
    }
    var result = JSON.parse(rtn.stdout);
    if (result.status == 0) {
      return this.getResult(result.requestId)
    } else {
      return this.getResult(result.requestId, result.msg)
    }
  }

  // 2020 0928 lin 新增 阿里文网文 服务商侧提供接口2.4 ⽤户⽅案反馈通知服务商
  async soulutionFeebackAliEsp(pobj) {
    var tokenInfo = await this.getCenterToken();
    if (tokenInfo.status != 0) {
      return this.getResult(self.getUUID())
    }
    var token = tokenInfo.data.token;
    var userpin = "";
    //带userpin请求
    var url = settings.centerChannelUrl() + "/api/opreceive/edi/springBoard";
    var sobj = {
      "actionType": pobj.action_type,
      "actionBody": pobj
    }
    var rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpin);
    if (!rtn || !rtn.stdout) {
      return this.getResult(self.getUUID(), "网络错误")
    }
    var result = JSON.parse(rtn.stdout);
    if (result.status == 0) {
      return this.getResult(result.requestId)
    } else {
      return this.getResult(result.requestId, result.msg)
    }
  }
}
module.exports = UtilsNeedSve;
