var system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const uuidv4 = require('uuid/v4');
const logCtl = system.getObject("service.common.oplogSve");
const regCfg = require("./regCfg")
//gongshang zhuce
class RegCenterOrderService extends AppServiceBase {
	constructor() {
		super();
		this.execlient = system.getObject("util.execClient");
		this.channelApiUrl = settings.channelApiUrl();
		this.centerChannelUrl = settings.centerChannelUrl();
		this.appInfo = {
			aliyuntmtransfer: { appkey: settings.appKey, secret: settings.secret }
		};
	}

	// -------------提交reg需求--------laolan 2020.12.17-------百度reg接入使用--------start------------------
	async getCenterTokenByApp(appinfo) {
		var reqTokenUrl = this.centerChannelUrl + "/api/opreceive/accessAuth/getAppTokenByAppKey";
		var reqParam = appinfo;
		if (!reqParam || !reqParam.uapp_key || !reqParam.uapp_secret) {
			return system.getResult(null, "reqType类型有误，请求失败");
		}
		var param = {
			"actionType": "getAppTokenByAppKey",
			"actionBody": {
				"appkey": reqParam.uapp_key,
				"secret": reqParam.uapp_secret
			}
		};

		var rtn = await this.execlient.execPost(param, reqTokenUrl);
		if (!rtn.stdout) {
			return system.getResult(null, "获取token失败");
		}
		var tokenResult = JSON.parse(rtn.stdout);
		return tokenResult;
	}

	async reqcenterchannel2(pobj) {
		console.log('reqcenterchannel2----', pobj)
		var sobj = {
			"actionType": pobj.action_type,
			"actionBody": pobj
		}
		if (!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret) {
			return {
				"requestId": regCfg.getUUID(),
				"success": false,
				"errorMsg": "无效应用",
				"errorCode": "ok"
			};
		}
		var tokenInfo = await this.getCenterTokenByApp(pobj.appInfo);
		if (tokenInfo.status != 0) {
			return {
				"requestId": regCfg.getUUID(),
				"success": false,
				"errorMsg": "getTokenInfo fail",
				"errorCode": "ok"
			};
		}
		var userpin = "";
		//传手机号
		if (pobj.phone && !pobj.mobile) {
			pobj.mobile = pobj.phone;
		} else {//没传手机号就自己去查渠道唯一码
			var reqData = {
				actionType: "selectNeedInfo",
				actionBody: {
					channelNeedNo: pobj.intentionBizId
				}
			}
			var needInfoUrl = settings.centerChannelUrl() + "/api/action/regapi/springBoard";
			var needInfoRes = await this.execlient.execPostTK(reqData, needInfoUrl, tokenInfo.data.token);
			if (needInfoRes.status == 0) {
				pobj.mobile = needInfoRes.data.channelUserId
			}
		}

		if (pobj.mobile) {
			//有传手机号就直接获取用户userpin
			var userparam = {
				actionType: "getLoginByUserName",
				actionBody: {
					"channelUserId": pobj.mobile,
					"mobile": pobj.mobile,
					"userName": pobj.mobile
				}
			};
			// pobj.actionBody.channelUserId = pobj.mobile;//渠道用户id，没有则用手机号
			// pobj.actionBody.mobile = pobj.mobile;//用户手机号
			var url = settings.centerChannelUrl() + "/api/opreceive/accessAuth/springBoard";
			var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
			if (userpinResultTmp.status != 0 && userpinResultTmp.status != 2060) {
				return system.getResultFail(-99, "获取userpin失败");
			}
			userpin = userpinResultTmp.data.userpin;
			if (!userpin) {
				return system.getResultFail(-88, "获取userpin失败!!");
			}

		}
		//带userpin请求
		url = settings.centerChannelUrl() + "/api/action/regapi/springBoard";
		var token = tokenInfo.data.token;
		var rtn = null;
		if (userpin) {
			rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpin);
		} else {
			rtn = await this.execlient.execPostTK(sobj, url, token);
			if (rtn.status == 0) {
				return {
					"requestId": rtn.requestId,
					"success": true,
					"errorMsg": "",
					"errorCode": "ok"
				};
			} else {
				return {
					"requestId": rtn.requestId,
					"success": false,
					"errorMsg": rtn.msg,
					"errorCode": "ok"
				};
			}
		}
		if (!rtn || !rtn.stdout) {
			return {
				"requestId": regCfg.getUUID(),
				"success": false,
				"errorMsg": "网络错误",
				"errorCode": "ok"
			};
		}

		var result = JSON.parse(rtn.stdout);
		if (result.status == 0) {
			return {
				"requestId": result.requestId,
				"success": true,
				"errorMsg": "",
				"errorCode": "ok"
			};
		} else {
			return {
				"requestId": result.requestId,
				"success": false,
				"errorMsg": result.msg,
				"errorCode": "ok"
			};
		}
	}
	//百度reg 2.3 请求
	async regOrderStatus(pobj) {
		if (!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret) {
			return {
				"requestId": regCfg.getUUID(),
				"success": false,
				"errorMsg": "无效应用",
				"errorCode": "ok"
			};
		}
		// 获取app token
		var tokenInfo = await this.getCenterTokenByApp(pobj.appInfo);
		if (tokenInfo.status != 0) {
			return {
				"requestId": regCfg.getUUID(),
				"success": false,
				"errorMsg": "",
				"errorCode": "ok"
			};
		}
		var token = tokenInfo.data.token;
		// 获取userpin
		var userparam = {
			actionType: "getLoginByUserName",
			actionBody: {}
		};
		// 引用属性，channel依赖bizId order依赖intentionBizId
		pobj.intentionBizId = pobj.bizId || pobj.orderNo
		if (pobj.isDirectBuy == 1) {//直购
			userparam.actionBody.channelUserId = pobj.phone
			userparam.actionBody.mobile = pobj.phone
			userparam.actionBody.userName = pobj.phone
			pobj.publishMobile = pobj.phone
			pobj.channelTypeCode = pobj.consultType;
			// pobj.engagedIndustry = pobj.engagedIndustry;
			// pobj.bizScope = pobj.bizScope;
			// pobj.hasAddress = 
			if (pobj.area) {
				// pobj.area = regCfg.baiduArea[pobj.area]
				pobj.area = pobj.area
			}
      pobj['province'] = pobj.area;
      
      var url = settings.centerChannelUrl() + "/api/opreceive/accessAuth/springBoard";
      var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
      if (userpinResultTmp.status != 0) {
        return {
          "requestId": userpinResultTmp.requestId,
          "success": false,
          "errorMsg": userpinResultTmp.msg,
          "errorCode": "ok"
        };
      }

      // regOrderStatus
			var url = settings.centerChannelUrl() + "/api/action/regapi/springBoard";
			var sobj = {
				"actionType": "regOrderStatus",
				"actionBody": pobj
			}
			var rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpinResultTmp.data.userpin);
			if (!rtn || !rtn.stdout) {
				return {
					"requestId": self.getUUID(),
					"success": false,
					"errorMsg": "网络错误",
					"errorCode": "ok"
				};
			}
			var result = JSON.parse(rtn.stdout);
			if (result.status != 0) {
				return {
					"requestId": result.requestId,
					"success": false,
					"errorMsg": result.msg,
					"errorCode": "ok"
				};
			}
			return {
				"requestId": result.requestId,
				"success": true,
				"errorMsg": "",
				"errorCode": "ok"
			};
		} else {
			var userpin = "";
			//传手机号
			if (pobj.phone && !pobj.mobile) {
				pobj.mobile = pobj.phone;
			} else {//没传手机号就自己去查渠道唯一码
				var reqData = {
					actionType: "selectNeedInfo",
					actionBody: {
						channelNeedNo: pobj.intentionBizId
					}
				}
				var needInfoUrl = settings.centerChannelUrl() + "/api/action/regapi/springBoard";
				var needInfoRes = await this.execlient.execPostTK(reqData, needInfoUrl, tokenInfo.data.token);
				if (needInfoRes.status == 0) {
					pobj.mobile = needInfoRes.data.channelUserId
				}
			}

			if (pobj.mobile) {
				//有传手机号就直接获取用户userpin
				var userparam = {
					actionType: "getLoginByUserName",
					actionBody: {
						"channelUserId": pobj.mobile,
						"mobile": pobj.mobile,
						"userName": pobj.mobile
					}
				};

				var url = settings.centerChannelUrl() + "/api/opreceive/accessAuth/springBoard";
				var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
				if (userpinResultTmp.status != 0 && userpinResultTmp.status != 2060) {
					return system.getResultFail(-99, "获取userpin失败");
				}
				userpin = userpinResultTmp.data.userpin;
				if (!userpin) {
					return system.getResultFail(-88, "获取userpin失败!!");
				}
			}

			var sobj = {
				"actionType": "getItemByChannelSolutionNo",
				"actionBody": pobj
			}
			// getItemByChannelSolutionNo
			var url = settings.centerChannelUrl() + "/api/action/regapi/springBoard";
			var result = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpin);
			if (result && result.stdout) {
				result = result.stdout
				result = JSON.parse(result)
			}
			if (result.status != 0) {
				return {
					"requestId": result.requestId,
					"success": false,
					"errorMsg": result.msg,
					"errorCode": "ok"
				};
			}
			console.log('regOrderStatus--start--')
			// regOrderStatus
			var url = settings.centerChannelUrl() + "/api/action/regapi/springBoard";
			var sobj = {
				"actionType": "regOrderStatus",
				"actionBody": pobj
			}
			var rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpinResultTmp.data.userpin);
			if (!rtn || !rtn.stdout) {
				return {
					"requestId": self.getUUID(),
					"success": false,
					"errorMsg": "网络错误",
					"errorCode": "ok"
				};
			}
			var result = JSON.parse(rtn.stdout);
			if (result.status != 0) {
				return {
					"requestId": result.requestId,
					"success": false,
					"errorMsg": result.msg,
					"errorCode": "ok"
				};
			}
			return {
				"requestId": result.requestId,
				"success": true,
				"errorMsg": "",
				"errorCode": "ok"
			};
		}
	}
	//百度reg 2.4 请求 关闭reg订单
	async regOrderClose(pobj) {
		if (!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret) {
			return {
				"requestId": regCfg.getUUID(),
				"success": false,
				"errorMsg": "无效应用",
				"errorCode": "ok"
			};
		}
		// 获取app token
		// var tokenInfo = await this.getCenterToken();
		var tokenInfo = await this.getCenterTokenByApp(pobj.appInfo);
		if (tokenInfo.status != 0) {
			return {
				"requestId": regCfg.getUUID(),
				"success": false,
				"errorMsg": "",
				"errorCode": "ok"
			};
		}
		var token = tokenInfo.data.token;
		var sobj = {
			"actionType": "getSolutionByChannelOrderNo",
			"actionBody": pobj
		}
		// getItemByChannelSolutionNo
		var userpin = "";
		//传手机号
		if (pobj.phone && !pobj.mobile) {
			pobj.mobile = pobj.phone;
		} else {//没传手机号就自己去查渠道唯一码
			var reqData = {
				actionType: "selectNeedInfo",
				actionBody: {
					orderNo: pobj.orderNo
				}
			}
			var needInfoUrl = settings.centerChannelUrl() + "/api/action/regapi/springBoard";
			var needInfoRes = await this.execlient.execPostTK(reqData, needInfoUrl, tokenInfo.data.token);
			if (needInfoRes.status == 0) {
				pobj.mobile = needInfoRes.data.channelUserId
			}
		}

		if (pobj.mobile) {
			//有传手机号就直接获取用户userpin
			var userparam = {
				actionType: "getLoginByUserName",
				actionBody: {
					"channelUserId": pobj.mobile,
					"mobile": pobj.mobile,
					"userName": pobj.mobile
				}
			};

			var url = settings.centerChannelUrl() + "/api/opreceive/accessAuth/springBoard";
			var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
			if (userpinResultTmp.status != 0 && userpinResultTmp.status != 2060) {
				return system.getResultFail(-99, "获取userpin失败");
			}
			userpin = userpinResultTmp.data.userpin;
			if (!userpin) {
				return system.getResultFail(-88, "获取userpin失败!!");
			}
		}

		var sobj = {
			"actionType": "getItemByChannelSolutionNo",
			"actionBody": pobj
		}
		var url = settings.centerChannelUrl() + "/api/action/regapi/springBoard";
		var result = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpin);
		if (result && result.stdout) {
			result = result.stdout
			result = JSON.parse(result)
		}
		if (result.status != 0) {
			return {
				"requestId": result.requestId,
				"success": false,
				"errorMsg": result.msg,
				"errorCode": "ok"
			};
		}
		if (!result.data.solutionContent || !result.data.solutionContent.customerInfo || !result.data.solutionContent.customerInfo.publishMobile) {
			return {
				"requestId": result.requestId,
				"success": false,
				"errorMsg": "方案客户信息有误",
				"errorCode": "ok"
			};
		}
		// 获取userpin
		var userparam = {
			actionType: "getLoginByUserName",
			actionBody: {
				channelUserId: result.data.solutionContent.customerInfo.publishMobile,
				mobile: result.data.solutionContent.customerInfo.publishMobile,
				userName: result.data.solutionContent.customerInfo.publishMobile
			}
		};
		var url = settings.centerChannelUrl() + "/api/opreceive/accessAuth/springBoard";
		var userpinResultTmp = await this.execlient.execPostTK(userparam, url, token);
		if (userpinResultTmp.status != 0) {
			return {
				"requestId": userpinResultTmp.requestId,
				"success": false,
				"errorMsg": userpinResultTmp.msg,
				"errorCode": "ok"
			};
		}
		var closeobj = {
			"actionType": "regOrderClose",
			"actionBody": pobj
		}
		var url = settings.centerChannelUrl() + "/api/action/regapi/springBoard";
		var rtn = await this.execlient.execDataPostByTokenUserPin(closeobj, url, token, userpinResultTmp.data.userpin);
		if (!rtn || !rtn.stdout) {
			return {
				"requestId": regCfg.getUUID(),
				"success": false,
				"errorMsg": "网络错误",
				"errorCode": "ok"
			};
		}
		var result = JSON.parse(rtn.stdout);
		if (result.status != 0) {
			return {
				"requestId": result.requestId,
				"success": false,
				"errorMsg": result.msg,
				"errorCode": "ok"
			};
		}
		return {
			"requestId": result.requestId,
			"success": true,
			"errorMsg": "",
			"errorCode": "ok"
		};
	}
	// -------------提交reg需求--------laolan 2020.12.17-------百度reg接入使用--------end------------------
}
module.exports = RegCenterOrderService;
