const system = require("../../../system");
var settings = require("../../../../config/settings");
var APIBase = require("../../api.base");

class TradetransferAPI extends APIBase {
  constructor() {
    super();
    this.execlient = system.getObject("util.execClient");
    this.channelApiUrl = settings.channelApiUrl();
    this.utilsNeedSve = system.getObject("service.utilsSve.utilsNeedSve");
    this.utilsServiceSve = system.getObject("service.utilsSve.utilsServiceSve");
  }

  async create(pobj,query,req) {
    console.log(pobj);
    // 校验必填 pannong 2.1
    var checkResult = await this.serviceCreateCheck(pobj,req.headers);
    if(checkResult.status != 0) {
      return checkResult;
    }
    var result = await this.utilsServiceSve.submitService(pobj,req.headers);
    return result
  }

  async serviceCreateCheck(pobj,headers) {
    if(!headers.appkey) {
      return system.getResult(null, "headers.appkey cannot be empty");
    }
    if(!headers.sign) {
      return system.getResult(null, "headers.sign cannot be empty");
    }
    if(!pobj.bizId) {
      return system.getResult(null, "bizId cannot be empty");
    }
    if(!pobj.contactName) {
      return system.getResult(null, "contactName cannot be empty");
    }
    if(!pobj.contactMobile) {
      return system.getResult(null, "contactName cannot be empty");
    }
    if(!pobj.timeUnit) {
      return system.getResult(null, "contactName cannot be empty");
    }
    if(!pobj.quantity) {
      return system.getResult(null, "contactName cannot be empty");
    }
    if(!pobj.companyInfo) {
      return system.getResult(null, "contactName cannot be empty");
    }
    if(!pobj.companyInfo.companyName) {
      return system.getResult(null, "companyName cannot be empty");
    }
    if(!pobj.companyInfo.taxpayerType) {
      return system.getResult(null, "taxpayerType cannot be empty");
    }
    if(!pobj.companyInfo.acctgSystemId) {
      return system.getResult(null, "acctgSystemId cannot be empty");
    }
    if(!pobj.companyInfo.companyForm) {
      return system.getResult(null, "companyForm cannot be empty");
    }
    if(!pobj.companyInfo.industry) {
      return system.getResult(null, "industry cannot be empty");
    }
    if(!pobj.companyInfo.taxpayerNumber) {
      return system.getResult(null, "taxpayerNumber cannot be empty");
    }
    if(!pobj.companyInfo.companyArea) {
      return system.getResult(null, "companyArea cannot be empty");
    }
    return system.getResultSuccess()
  }
}
module.exports = TradetransferAPI;
