const system = require("../../../system");
var settings = require("../../../../config/settings");
var APIBase = require("../../api.base");

class TradetransferAPI extends APIBase {
  constructor() {
    super();
    this.execlient = system.getObject("util.execClient");
    this.channelApiUrl = settings.channelApiUrl();
    this.utilsNeedSve = system.getObject("service.utilsSve.utilsNeedSve");
    this.regCenterOrderSve = system.getObject("service.utilsSve.regCenterOrderSve");

  }

  /**
      * 接口跳转-POST请求
      * actionProcess  执行的流程
      * actionType     执行的类型
      * actionBody     执行的参数
      */
  async springBoard(pobj, qobj, req) {
    console.log(pobj, ".....pobj....springBoard");
    console.log(req, ".....req....springBoard");
    if (!pobj.action_type) {
      pobj = req.body;
    }
    if (!pobj.action_type) {
      return system.getResult(null, "actionType参数不能为空");
    }
    console.log(pobj);
    var result = await this.opActionProcess(pobj, pobj.action_type);
    return result;
  }

  async opActionProcess(pobj, action_type) {
    var opResult = null;
    switch (action_type) {
      case "submitNeed"://提交需求
        opResult = await this.utilsNeedSve.reqcenterchannel(pobj);
        break;
      // -------------提交Icp需求--------庄冰2020.10.21-------百度Icp接入使用--------start------------------
      case "submitIcpNeed"://提交Icp需求
        opResult = await this.utilsNeedSve.reqcenterchannel2(pobj);
        break;
      case "icpFeedbackSubmitNew"://接收方案反馈信息
        opResult = await this.utilsNeedSve.reqcenterchannel2(pobj);
        break;
      case "icpOrderStatus"://icp订单状态变更
        opResult = await this.utilsNeedSve.icpOrderStatus(pobj);
        break;
      case "icpOrderClose"://关闭icp订单
        opResult = await this.utilsNeedSve.icpOrderClose(pobj);
        break;
      // -------------提交Icp需求--------庄冰2020.10.21-------百度Icp接入使用--------end------------------
      case "needClose"://关闭需求
        opResult = await this.utilsNeedSve.reqcenterchannel(pobj);
        break;
      case "receiveFeedback"://接收方案反馈信息
        opResult = await this.utilsNeedSve.reqcenterchannel(pobj);
        break;
      case "icpFeedbackSubmit"://接收方案反馈信息
        opResult = await this.utilsNeedSve.reqcenterchannel(pobj);
        break;
      case "paySuccess"://支付回调
        opResult = await this.utilsNeedSve.paySuccess(pobj);
        break;
      case "queryOrderState":// 通知状态变更
        opResult = await this.utilsNeedSve.queryOrderState(pobj);
        break;
      case "submitNeedAliEsp":// 2020 0925 lin 新增 阿里文网文 服务商侧提供接口2.1 提交用户需求给服务商 -- 业务与submitNeed 删除此接口
        opResult = await this.utilsNeedSve.submitNeedAliEsp(pobj);
        break;
      case "needCloseAliEsp":// 2020 0926 lin 新增 阿里文网文 服务商侧提供接口2.2 关闭需求通知服务商 -- 业务与needClose 删除此接口
        opResult = await this.utilsNeedSve.needCloseAliEsp(pobj);
        break;
      case "produceNoticeAliEsp":// 2020 0927 lin 新增 阿里文网文 服务商侧提供接口2.3 服务单通知服务商
        opResult = await this.utilsNeedSve.produceNoticeAliEsp(pobj);
        break;
      case "soulutionFeebackAliEsp":// 2020 0928 lin 新增 阿里文网文 服务商侧提供接口2.4 ⽤户⽅案反馈通知服务商
        opResult = await this.utilsNeedSve.soulutionFeebackAliEsp(pobj);
        break;

      // -------------提交reg需求--------laolan 2020.12.16-------百度reg接入使用--------start------------------
      case "submitRegNeed"://提交reg需求
        opResult = await this.regCenterOrderSve.reqcenterchannel2(pobj);
        break;
      case "regFeedbackSubmit"://接收方案需求信息
        opResult = await this.regCenterOrderSve.reqcenterchannel2(pobj);
        break;
      case "regOrderStatus"://接收方案反馈信息
        opResult = await this.regCenterOrderSve.regOrderStatus(pobj);
        break;
      case "regOrderClose"://关闭reg订单
        opResult = await this.regCenterOrderSve.regOrderClose(pobj);
        break;
      // -------------提交reg需求--------laolan 2020.12.16-------百度reg接入使用--------end------------------
      case "submitTmNeed"://提交需求
        opResult = await this.utilsNeedSve.reqcenterchannel2(pobj);
        break;
      case "tmFeedbackSubmit"://商标用户反馈
        opResult = await this.utilsNeedSve.reqcenterchannel2(pobj);
        break;
      case "tmStatusNotify"://商标状态通知
        opResult = await this.utilsNeedSve.reqcenterchannel2(pobj);
        break;
      default:
        opResult = system.getResult(null, "action_type参数错误");
        break;
    }
    return opResult;
  }




}
module.exports = TradetransferAPI;
