const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("tradetransfer", {
    tm_number: DataTypes.STRING,   //注册号
    ali_bizid: DataTypes.STRING,  //'阿里订单号'
    user_name: DataTypes.STRING,  //买家姓名
    mobile: DataTypes.STRING, //买方电话
    tracklog:DataTypes.STRING, 
    contact_name: DataTypes.STRING, //买家联系人姓名
    contact_mobile: DataTypes.STRING, //联系人联系方式
    contact_email: DataTypes.STRING, //买家联系方式
    cardno: DataTypes.STRING, //证件编号
    complete: DataTypes.STRING, //是否补充完成，补充完成的话会展示给购买人确认资料。
    user_type_name: DataTypes.STRING, //买家用户类型
    user_type: {            // "买家用户类型",
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tranferperson_type),    //
      set: function (val) {
        this.setDataValue("user_type", val);
        this.setDataValue("user_type_name", uiconfig.config.pdict.tranferperson_type[val]);
      }
    },
    buyer_address: DataTypes.STRING, //买家地址
    buyer_businesslicense: DataTypes.STRING, //买家营业执照
    buyer_name: DataTypes.STRING,//买家姓名
    buyer_idcard: DataTypes.STRING,//买家身份证
    seller_businesslicense: DataTypes.STRING,//卖家营业执照
    seller_idcard: DataTypes.STRING,//卖家身份证
    seller_proxy: DataTypes.STRING,//代理委托书
    seller_apply:DataTypes.STRING,//申请书

    transfer_receive_ack: DataTypes.STRING,//商标局受理回执

    ncl_one: DataTypes.STRING,    //尼斯大类
    price: DataTypes.STRING,    //价格
    fq_ordernum: DataTypes.STRING,    //合作方订单号
    tm_cert_url: DataTypes.STRING,    //商标证书
    transfer_cert_url: DataTypes.STRING,    //转让证明
    notarization_url: DataTypes.STRING,    //公证书
    notarization_flow_id: DataTypes.STRING,  //公证流程ｉｄ
    transfer_status_name: DataTypes.STRING,    //流程状态名称
    transfer_status: {
      type: DataTypes.ENUM,    //
      values: Object.keys(uiconfig.config.pdict.transfer_status),    //
      set: function (val) {
        this.setDataValue("transfer_status", val);
        this.setDataValue("transfer_status_name", uiconfig.config.pdict.transfer_status[val]);
      }
    },
    aliorder_status_name: DataTypes.STRING,    //阿里订单状态名称
    aliorder_status: {
      type: DataTypes.ENUM,    //
      values: Object.keys(uiconfig.config.pdict.aliorder_status),    //
      set: function (val) {
        this.setDataValue("aliorder_status", val);
        this.setDataValue("aliorder_status_name", uiconfig.config.pdict.aliorder_status[val]);
      }
    },
    owner_id: DataTypes.STRING,    //业务员id
    owner_name: DataTypes.STRING,    //业务员姓名
    owner_mobile: DataTypes.STRING,    //业务员电话
    mail_zip_url: DataTypes.STRING,   //邮寄文件链接　
    logistics: DataTypes.STRING,    //邮寄单编号

    remark: DataTypes.STRING, 
    buyer_businesslicense_en:DataTypes.STRING,
    seller_businesslicense_en:DataTypes.STRING,
    buyer_proxy:DataTypes.STRING,
    seller_type: {            // "卖家用户类型",
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tranferperson_type),    //
      set: function (val) {
        this.setDataValue("seller_type", val);
        this.setDataValue("seller_type_name", uiconfig.config.pdict.tranferperson_type[val]);
      }
    },
    seller_type_name:DataTypes.STRING
    //communicationLog: DataTypes.TEXT  //沟通记录
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'trade_transfer',
      validate: {

      },
      indexes: [
        // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
        //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
        //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
        //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
      ]
    });
}
