const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("notarizationflow", {
    ali_bizid: DataTypes.STRING,  //'阿里订单号'
    fq_ordernum: DataTypes.STRING,    //合作方订单号
    //材料信息
    tmRegisterCertificate: DataTypes.STRING,      // "商标注册证", 
    businessLicense: DataTypes.STRING,      // "机构营业执照（卖家营业执照证件）", 
    buyerIdentification: DataTypes.STRING,      // "受让人身份证明材料", 
    tmAcceptCertificate: DataTypes.STRING,      // "商标受理通知书", 
    sellerFrontOfIdCard: DataTypes.STRING,      // "卖家身份证正面", 
    sellerBackOfIdCard: DataTypes.STRING,      // "卖家身份证反面",
    tmRegisterChangeCertificate: DataTypes.STRING,      // "商标注册证变更证明"，
    //买家信息
    buyerType: {            // "买方类型",
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tranferperson_type),    //
      set: function (val) {
        this.setDataValue("buyerType", val);
        this.setDataValue("buyerTypeName", uiconfig.config.pdict.tranferperson_type[val]);
      }
    },
    buyerTypeName: DataTypes.STRING,      // "买方类型",
    buyerCompanyＮame: DataTypes.STRING,      // "买方企业名称",
    buyerName: DataTypes.STRING,      // "买家姓名", 
    certificateNo: DataTypes.STRING,      // "证件号",
    certificateType: {           // "证件类型（目前仅支持身份证，支持汉字），枚举取值：1、身份证2、护 照"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.certificate_type),    //
      set: function (val) {
        this.setDataValue("buyerType", val);
        this.setDataValue("buyerTypeName", uiconfig.config.pdict.certificate_type[val]);
      }
    },
    certificateTypeＮame: DataTypes.STRING,　　　// "证件类型
    //卖家信息
    sellerType: {            // "卖方类型",
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tranferperson_type),
      set: function (val) {
        this.setDataValue("sellerType", val);
        this.setDataValue("sellerTypeName", uiconfig.config.pdict.tranferperson_type[val]);
      }
    },
    sellerTypeName: DataTypes.STRING,      // "卖方类型",
    legalPersonPhone: DataTypes.STRING,      // "法定代表人手机号", 
    companyContactName: DataTypes.STRING,      // "企业联系人姓名，可以和法人姓名一致", 
    verifyPhone: DataTypes.STRING,      // "验证手机号",
    phone: DataTypes.STRING,      // "手机号", 
    businessLicenseId: DataTypes.STRING,      // "统一社会信用代码（营业执照）", 
    sellerCompanyName: DataTypes.STRING,      // "企业名称", 
    sellerCompanyAddress: DataTypes.STRING,      // "卖方公司地址", 
    legalPersonIdCard: DataTypes.STRING,      // "法定代表人身份证号码", 
    companyContactPhone: DataTypes.STRING,      // "企业联系人电话，可以和法人手机号一致", 
    legalPersonName: DataTypes.STRING,      // "法定代表人姓名"
    //商标信息
    tmRegisterNo: DataTypes.STRING,      // "商标注册号", 
    tmClassification: DataTypes.STRING,      // "商标第几类"

    owner_id: DataTypes.STRING,    //业务员id
    owner_name: DataTypes.STRING,    //业务员姓名
    owner_mobile: DataTypes.STRING,    //业务员电话
    notaryStatus: {            // "公证订单状态",
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tranferperson_type),
      set: function (val) {
        this.setDataValue("notaryStatus", val);
        this.setDataValue("notaryStatusName", uiconfig.config.pdict.tranferperson_type[val]);
      }
    },
    notaryStatusName: DataTypes.STRING,      // "公证订单状态",
    desc: DataTypes.STRING,  //备注
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'notarization_flow',
      validate: {

      },
      indexes: [
        // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
        //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
        //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
        //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
      ]
    });
}
