module.exports={
  "bizName":"servicesitem",
  "list":{
    columnMetaData:[
      {"width":"200","label":"项目操作码","prop":"code","isShowTip":true,"isTmpl":false},
      {"width":"200","label":"项目类型","prop":"itemTypeName","isShowTip":true,"isTmpl":false},
      {"width":"200","label":"项目名称","prop":"name","isShowTip":true,"isTmpl":false},
      {"width":"200","label":"项目渠道","prop":"channel.channelName","isShowTip":true,"isTmpl":false},
      {"width":"200","label":"渠道编码","prop":"channelCode","isShowTip":true,"isTmpl":false},
      {"width":"200","label":"是否推荐","prop":"isRecommendName","isShowTip":true,"isTmpl":false},
      {"width":"200","label":"是否发布","prop":"isPubed","isShowTip":true,"isTmpl":false},
      {"width":"200","label":"排序","prop":"sort","isShowTip":true,"isTmpl":false},
      {"width":"null","label":"操作","name":"null","isShowTip":false,"isTmpl":true,"isBtns":"true"},
    ]
  },
  "form":[
    {
      "title":"项目操作码",
      "validProp":"code",
      "rule": [
           { "required": true, "message": '请输入项目操作码', "trigger": 'blur' },
       ],
       "ctls":[
         {"type":"input","label":"项目操作码","prop":"code","placeHolder":"请输入项目操作码","style":""},
       ]
    },
    {
      "title":"项目渠道",
       ctls:[
         {"type":"select","refModel":"channel","isMulti":false,"label":"项目渠道","prop":"channel_id","labelField":"channelName","valueField":"id","style":""},
       ]
    },
   {
      "title":"项目大类",
      "validProp":"itemType",
      "rule": [
           { "required": true, "message": '请选择类型', "trigger": 'blur' },
       ],
       "ctls":[
         {"type":"select","dicKey":"productCata","prop":"itemType","labelField":"label","valueField":"value","style":""},
       ]
    },
    {
      "title":"项目小类",
       ctls:[
         {"type":"select","dicKey":"serviceSmallClassType","prop":"serviceSmallClassType","labelField":"label","valueField":"value","style":""},
       ]
    },  
    {
      "title":"",
       "ctls":[
          {"type":"switch","prop":"isSubProduct","acText":"提报产品","inactText":"不提报产品","placeHolder":" ","style":""},
       ]
    },    
    {
      "title":"产品操作地址",
       "ctls":[
         {"type":"input","label":"项目名称","prop":"productOpUrl","placeHolder":"是提报产品才填写此值","style":""},
       ]
    },    
    {
       "title":"是否面议",
       "validProp":"isNegotiable",
       "rule": [
            { "required": true, "message": '请选择类型', "trigger": 'blur' },
        ],
        "ctls":[
          {"type":"select","dicKey":"isRecommend","prop":"isNegotiable","labelField":"label","valueField":"value","style":""},
        ]
     },
    {
      "title":"项目名称",
      "validProp":"name",
      "rule": [
           { "required": true, "message": '请输入项目名称', "trigger": 'blur' },
       ],
       "ctls":[
         {"type":"input","label":"项目名称","prop":"name","placeHolder":"请输入项目名称","style":""},
       ]
    },
     {
        "title":"是否推荐",
        "validProp":"isRecommend",
        "rule": [
             { "required": true, "message": '请选择类型', "trigger": 'blur' },
         ],
         "ctls":[
           {"type":"select","dicKey":"isRecommend","prop":"isRecommend","labelField":"label","valueField":"value","style":""},
         ]
      },
    {
      "title":"排序",
      "validProp":"sort",
      "rule": [
          { "validator":"validatex","trigger": 'blur' },
           { "required": true, "message": '请输入排序，越小越靠前显示，可以为负数', "trigger": 'blur' },
           { "type": 'number', "message": '排序必须为数字值'}
       ],
       "ctls":[
         {"type":"number","label":"排序","prop":"sort","disabled":false,"placeHolder":"请输入排序，越小越靠前显示，可以为负数","style":""},
       ]
    },
    {
      "title":"咨询电话",
      "validProp":"hotline",
      "rule": [
           { "required": true, "message": '请输入咨询电话', "trigger": 'blur' },
           { "validator":"validatex","trigger": 'blur' },
       ],
      "ctls":[
         {"type":"input","label":"项目操作码","prop":"hotline","placeHolder":"请输入咨询电话","style":""},
       ]
    },
    {
      "title":"件数",
      "validProp":"nclOneCodesNum",
      "rule": [
          { "validator":"validatex","trigger": 'blur' },
           { "required": true, "message": '请输入服务项目构成的件数', "trigger": 'blur' },
           { "type": 'number', "message": '件数必须为数字值'}
       ],
       "ctls":[
         {"type":"number","label":"项目服务费","prop":"nclOneCodesNum","disabled":false,"placeHolder":"请输入项目服务费","style":""},
       ]
    },
    {
      "title":"项目服务费",
      "validProp":"serviceCharge",
      "rule": [
          { "validator":"validatex","trigger": 'blur' },
           { "required": true, "message": '请输入项目服务费', "trigger": 'blur' },
           { "type": 'number', "message": '项目服务费必须为数字值'}
       ],
       "ctls":[
         {"type":"number","label":"项目服务费","prop":"serviceCharge","disabled":false,"placeHolder":"请输入项目服务费","style":""},
       ]
    },
    {
      "title":"项目官费",
      "validProp":"publicExpense",
      "rule": [
           { "validator":"validatex","trigger": 'blur' },
           { "type": 'number', "message": '项目官费必须为数字值'},
           { "required": true, "message": '请输入项目官费', "trigger": 'blur' },

       ],
       "ctls":[
         {"type":"number","label":"项目官费","prop":"publicExpense","disabled":false,"placeHolder":"请输入项目官费","style":""},
       ]
    },
    {
      "title":"平台使用费",
      "validProp":"platformCost",
      "rule": [
           { "validator":"validatex","trigger": 'blur' },
           { "type": 'number',"min":0,"max":100, "message": '平台使用费最高100元/件'},
           { "required": true, "message": '请输入平台使用费', "trigger": 'blur' },

       ],
       "ctls":[
         {"type":"number","label":"平台费用","prop":"platformCost","disabled":false,"placeHolder":"请输入平台费用","style":""},
       ]
    },
    {
      "title":"委托平台交付服务底价",
       "ctls":[
         {"type":"number","label":"委托平台交付服务底价","disabled":true,"prop":"platformWorkFloorPrice","placeHolder":"","style":""},
       ]
    },
    {
      "title":"指导报价",
      "validProp":"guidePrice",
      "rule": [
           { "validator":"validatex","trigger": 'blur' },
           { "type": 'number', "message": '报价价格必须为数字值'},
           { "required": true, "message": '请输入报价价格', "trigger": 'blur' },
       ],
       "ctls":[
         {"type":"number","label":"指导报价","prop":"guidePrice","disabled":false,"placeHolder":"请输入报价价格,必须大于平台底价","style":""},
       ]
    },

    {
      "title":"合伙人自助服务底价",
       "ctls":[
         {"type":"number","label":"指导价格","disabled":false,"prop":"selfWorkFloorPrice","disabled":true,"placeHolder":"","style":""},
       ]
    },
    {
      "title":"委托平台服务分润比率【成单金额-税（成单金额*0.07）-官费-平台使用费】*【输入比率】=平台分润",
      "validProp":"platformProfitRatio",
      "rule": [
           {  "type": 'number',"min": 0.00, "max": 100.00, "message": '委托平台服务分润比率必须是1-100之间的整数数字'},
           { "required": true, "message": '请输入委托平台服务分润比率', "trigger": 'blur' },
       ],
       "ctls":[
         {"type":"number","label":"指导价格","disabled":false,"prop":"platformProfitRatio","disabled":false,"placeHolder":"请输入0-100之间的百分比数字","style":""},
       ]
    },
    {
      "title":"服务折扣率",
      "validProp":"servicesReducedRate",
      "rule": [
           {  "type": 'number',"min": 0.00, "max": 100.00, "message": '委托平台服务分润比率必须是1-100之间的整数数字'},
           { "required": true, "message": '请输入服务折扣率', "trigger": 'blur' },
       ],
       "ctls":[
         {"type":"number","label":"服务折扣率","disabled":false,"prop":"servicesReducedRate","disabled":false,"placeHolder":"请输入0-100之间的百分比数字","style":""},
       ]
    },
    {
      "title":"项目移动端图片",
       "ctls":[
         {"type":"upload","label":"移动端图片","prop":"mobilePic","placeHolder":"请输入移动端图片","style":""},
       ]
    },
    {
      "title":"详情图片",
       "ctls":[
         {"type":"upload","label":"web端图片","prop":"mobileContentImg","placeHolder":"","style":""},
       ]
    },
    {
      "title":"常见问题",
      "ctls":[
        {"type":"upload","label":"web端图片","prop":"answerConent","placeHolder":"","style":""},
      ]
    },
    {
      "title":"项目简介",
       "ctls":[
         {"type":"textarea","label":"项目简介","prop":"shortDesc","placeHolder":"请输入项目简介","style":""},
       ]
    },
    {
      "title":"",
       "ctls":[
          {"type":"switch","prop":"isPubed","acText":"发布","inactText":"不发布","placeHolder":" ","style":""},
       ]
    },
    {
      "title":"",
       "ctls":[
          {"type":"switch","prop":"isSeckill","acText":"秒杀","inactText":"不秒杀","placeHolder":" ","style":""},
       ]
    },
    {
      "title":"秒杀结束时间",
       "ctls":[
          {"type":"datetime","label":"秒杀结束时间","prop":"seckillEndTime","placeHolder":"请输入秒杀时间","style":""},
       ]
    },

  ],
  "search":[
    {
      "title":"项目名称",
       ctls:[
         {"type":"input","label":"项目名称","prop":"name","placeHolder":"请输入项目名称","style":""},
       ]
    },
    {
      "title":"项目类型",
      ctls:[
        {"type":"select","dicKey":"productCata","prop":"itemType","labelField":"label","valueField":"value","style":""},
      ]
    },
    {
      "title":"项目渠道",
       ctls:[
         {"type":"select","refModel":"channel","isMulti":false,"label":"项目渠道","prop":"channelCode","labelField":"channelName","valueField":"channelCode","style":""},
       ]
    },
    {
      "title":"是否推荐",
      ctls:[
        {"type":"select","dicKey":"isRecommend","prop":"isRecommend","labelField":"label","valueField":"value","style":""},
      ]
    },
  ],
  "auth":{
    "add":[
      {"icon":"el-icon-plus","title":"新增","type":"default","key":"new","isOnGrid":true},
      {"icon":"el-icon-plus","title":"上架","type":"default","key":"extraup","isOnGrid":true},
      {"icon":"el-icon-plus","title":"复制","type":"default","key":"copyOp","isOnGrid":true},
      {"icon":"el-icon-save","title":"保存","type":"default","key":"save","isOnForm":true},
    ],
    "edit":[
      {"icon":"el-icon-edit","title":"修改","type":"default","key":"edit","isInRow":true},
    ],
    "delete":[
      // {"icon":"el-icon-remove","title":"删除","type":"default","key":"delete","isInRow":true},
    ],
    "common":[
      {"icon":"el-icon-cancel","title":"取消","type":"default","key":"cancel","isOnForm":true},
    ],
  }
}
