const system = require("../system");
const settings = require("../../config/settings");
const uuidv4 = require('uuid/v4');
class CtlBase {
  constructor() {
    this.cacheManager = system.getObject("db.common.cacheManager");
    this.redisClient = system.getObject("util.redisClient");
  }
  getUUID() {
    var uuid = uuidv4();
    var u = uuid.replace(/\-/g, "");
    return u;
  }
  notify(req, msg) {
    if (req.session) {
      req.session.bizmsg = msg;
    }
  }

  static getServiceName(ClassObj) {

    return ClassObj["name"].substring(0, ClassObj["name"].lastIndexOf("Ctl")).toLowerCase() + "Sve";
  }

  async timestampConvertDate(time) {
    if (time == null) {
      return "";
    }
    var date = new Date(Number(time * 1000));
    var y = 1900 + date.getYear();
    var m = "0" + (date.getMonth() + 1);
    var d = "0" + date.getDate();
    return y + "-" + m.substring(m.length - 2, m.length) + "-" + d.substring(d.length - 2, d.length);
  }
  async universalTimeConvertLongDate(time) {
    if (time == null) {
      return "";
    }
    var d = new Date(time);
    return d.getFullYear() + '-' + (d.getMonth() + 1) + '-' + d.getDate() + ' ' + d.getHours() + ':' + d.getMinutes() + ':' + d.getSeconds();
  }
  async universalTimeConvertShortDate(time) {
    if (time == null) {
      return "";
    }
    var d = new Date(time);
    return d.getFullYear() + '-' + (d.getMonth() + 1) + '-' + d.getDate();
  }




  async setContextParams(pobj, qobj, req) {
    pobj.userid = req.session.user ? req.session.user.id : null;
  }

  async doexec(methodname, pobj, query, req) {
    try {
      await this.setContextParams(pobj, query, req);
      // //检查appkey
      // let key = await this.cacheManager["InitAppKeyCache"].getAppKeyVal(pobj.appKey);
      // if(key==null){
      //   return system.getResultFail(system.tokenFail,"appKey授权有误");
      // }
      var rtn = await this[methodname](pobj, query, req);
      //     await this. apitradeSvr .create({
      //     appkey: pobj.appKey,
      //     tradeType: "consume",
      //     op: pobj.classname + "/" + methodname,
      //     params: JSON.stringify(pobj),
      //     clientIp: pobj.clientIp,
      //     agent: pobj.agent,
      //   });
      return rtn;
    } catch (e) {
      console.log(e.stack, "出现异常，请联系管理员.......");
      // this.logCtl.error({
      //   optitle: "api调用出错",
      //   op: pobj.classname + "/" + methodname,
      //   content: e.stack,
      //   clientIp:  pobj.clientIp
      // });
      return system.getResultFail(-200, "出现异常，请联系管理员");
    }
  }
}
module.exports = CtlBase;
