var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class OpCacheAPI extends APIBase {
    constructor() {
        super();
        this.cacheSve = system.getObject("service.common.cacheSve");
    }
    //返回
    async opCacheData(params) {
        if (params.action_type == "findAndCountAll") {
            return await this.cacheSve.findAndCountAll(params.body);
        } else if (params.action_type == "delCache") {
            return await this.cacheSve.delCache(params.body);
        } else if (params.action_type == "clearAllCache") {
            return await this.cacheSve.clearAllCache(params.body);
        } else {
            return system.getResultFail();
        }
    }
    //接受缓存计数通知接口
    async recvNotificationForCacheCount(p,q,req){
        return this.cacheSve.recvNotificationForCacheCount(p);
    }
    exam(){
        return "xxx";
    }
    classDesc() {
        return {
            groupName: "meta",
            groupDesc: "元数据服务包",
            name: "OpCacheAPI",
            desc: "关于系统缓存的操作类",
            exam: "",
        };
    }
    methodDescs() {
        return [
            {
                methodDesc: "生成访问token",
                methodName: "opCacheData",
                paramdescs: [
                    {
                        paramDesc: "访问action_type类型：findAndCountAll为查询，delCache为删除，clearAllCache为清理",
                        paramName: "action_type",
                        paramType: "string",
                        defaultValue: null,
                    },
                    {
                        paramDesc: "访问body参数",
                        paramName: "body",
                        paramType: "json",
                        defaultValue: null,
                    }
                ],
                rtnTypeDesc: "xxxx",
                rtnType: "xxx"
            }
        ];
    }
}
module.exports = OpCacheAPI;