var system = require("../../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctlms.base");
const logCtl = system.getObject("web.common.oplogCtl");

var cacheBaseComp = null;
class OrderCtl extends CtlBase {
  constructor() {
    super();
    this.orderSve = system.getObject("service.order.orderSve");
  }

  async allPage(pobj, pobj2, req) {
    var condition = {
      currentPage: pobj.currentPage || 1,
      pageSize: pobj.pageSize || 10,
      merchantId: pobj.merchantId,
      orderId: this.trim(pobj.orderNo),
      channelOrderNo: this.trim(pobj.channelOrderNo),
      status: pobj.status,
      assignBegin: this.trim(pobj.assignBegin),
      assignEnd: this.trim(pobj.assignEnd),
    }

    this.doTimeCondition(condition, ["createdBegin", "createdEnd"]);
    this.doTimeCondition(condition, ["assignBegin", "assignEnd"]);

    try {
      return await this.orderSve.allOrderList(condition);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async close(pobj, pobj2, req) {
    try {
      return await this.orderSve.closeById({
        id: pobj.id
      });
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async assign(pobj, pobj2, req) {
    try {
      var params = {
        assignUcname: req.loginUser.ucname,
        id: pobj.id,
        deliver_id: this.trim(pobj.deliverId),
        deliverName: this.trim(pobj.deliverName),
        deliverDivide: system.y2f(Number(pobj.deliverDivide)),
      }
      return await this.orderSve.assign(params);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async orderEdit(pobj, pobj2, req) {
    try {
      var params = {
        id: pobj.id,
        merchantId: this.trim(pobj.merchantId),
        price: system.y2f(Number(pobj.price)),
      }
      return await this.orderSve.orderEdit(params);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async allInfo(pobj, pobj2, req) {
    try {
      var params = {
        id: pobj.id
      }
      return await this.orderSve.orderInfoAll(params, true);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async deliverInfo(pobj, pobj2, req) {
    try {
      var params = {
        id: pobj.id
      }
      return await this.orderSve.orderInfoAll(params);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async deliverEdit(pobj, pobj2, req) {
    try {
      return await this.orderSve.deliverEdit(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }

  }

  async deliverClose(pobj, pobj2, req) {
    try {
      return await this.orderSve.deliverClose(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async handlePage(pobj, pobj2, req) {
    try {
      var condition = {
        id: pobj.id,
        currentPage: pobj.currentPage || 1,
        pageSize: pobj.pageSize || 1,
        orderId: this.trim(pobj.orderId),
        status: this.trim(pobj.status),
        deliverId: "", //  TODO 传入具体办理人
      }
      this.doTimeCondition(condition, ["createdBegin", "createdEnd"]);

      return await this.orderSve.handlePage(condition);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async deliverHandle(pobj, pobj2, req) {
    try {
      var handleObj = {
        id: pobj.id,
        status: pobj.status,

        name: this.trim(pobj.name),
        creditCode: this.trim(pobj.creditCode),
        businessPlace: this.trim(pobj.businessPlace),
        businessScope: this.trim(pobj.businessScope),
        regDate: this.trim(pobj.regDate),
        businessImg: this.trim(pobj.businessImg),

        gongzhang: this.trim(pobj.gongzhang),
        caiwuzhang: this.trim(pobj.caiwuzhang),
        fapiaozhang: this.trim(pobj.fapiaozhang),
        hetongzhang: this.trim(pobj.hetongzhang),
        farenzhang: this.trim(pobj.farenzhang),

        isBank: this.trim(pobj.isBank),
        bankName: this.trim(pobj.bankName),
        bankNo: this.trim(pobj.bankNo),
        bank: this.trim(pobj.bank),
        bankImg: this.trim(pobj.bankImg),

        caImg: this.trim(pobj.caImg),
        taxRegDay: this.trim(pobj.taxRegDay),
        taxOrg: this.trim(pobj.taxOrg),

        courierNo: this.trim(pobj.courierNo),
        courierImg: this.trim(pobj.courierImg),
      }

      return await this.orderSve.deliverHandle(handleObj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async deliverAudit(pobj, pobj2, req) {
    try {
      var auditObj = {};
      auditObj.id = pobj.id;
      auditObj.auditUser = req.loginUser.ucname;
      auditObj.status = pobj.status;

      auditObj.auditRemark = this.trim(pobj.auditRemark);
      auditObj.content = this.trim(pobj.content);
      auditObj.addressee = this.trim(pobj.addressee);
      auditObj.mobile = this.trim(pobj.mobile);
      auditObj.addr = this.trim(pobj.addr);
      auditObj.auditResult = this.trim(pobj.auditResult);

      return await this.orderSve.deliverAudit(auditObj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }


  async orderComplete(pobj, pobj2, req) {
    try {
      var handleObj = {
        id: pobj.id,
        deliverType: this.trim(pobj.deliverType),
        deliverNo: this.trim(pobj.deliverNo),
        deliverImg: this.trim(pobj.deliverImg),
      }
      return await this.orderSve.orderComplete(handleObj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  // async orderList(pobj, pobj2, req) {
  //   try {
  //     // 订单状态 00待处理 10出执照 20已刻章 30银行开户 40税务报道 50已邮寄
  //     var condition = {
  //       currentPage: pobj.currentPage,
  //       pageSize: pobj.pageSize,
  //       merchantId: pobj.merchantId,
  //       orderNo: this.trim(pobj.orderNo),
  //       channelOrderNo: this.trim(pobj.channelOrderNo),
  //       status: pobj.status,
  //       createdBegin: this.trim(pobj.createdBegin),
  //       createdEnd: this.trim(pobj.createdEnd),
  //     }

  //     this.doTimeCondition(condition, ["createdBegin", "createdEnd"]);

  //     var page = await this.service.pageByCondition(condition);
  //     console.log(page);
  //     return system.getResultSuccess(page);
  //   } catch (error) {
  //     console.log(error);
  //     return system.getResultFail(500, "接口异常：" + error.message);
  //   }
  // }

  // async createStep(pobj, pobj2, req) {
  //   var id = Number(pobj.orderId);
  //   var status = pobj.status;
  //   try {
  //     switch (status) {
  //       case "05": //"执照办理中"
  //       case "15": //"刻章办理中" 
  //       case "25": //"银行开户中" 
  //       case "35": //"税务报到中" 
  //         return await this.service.changeStatus(id, status);
  //       case "10": { //"已出执照" 
  //         var params = {
  //           orderId: pobj.orderId,
  //           name: this.trim(pobj.name), // 个体工商户名称
  //           creditCode: this.trim(pobj.creditCode), // 统一社会信用代码
  //           businessPlace: this.trim(pobj.businessPlace), // 经营场所
  //           businessScope: this.trim(pobj.businessScope), // 经营范围
  //           regDate: this.trim(pobj.regDate), // 注册日期
  //           businessImg: this.trim(pobj.businessImg), // 执照照片
  //         };
  //         return await this.service.createLicense(pobj);
  //       }
  //       case "20": { //"已刻章" 
  //         var params = {
  //           orderId: pobj.orderId,
  //           gongzhang: this.trim(pobj.gongzhang),
  //           caiwuzhang: this.trim(pobj.caiwuzhang),
  //           businessImg: this.trim(pobj.businessImg),
  //           fapiaozhang: this.trim(pobj.fapiaozhang),
  //           hetongzhang: this.trim(pobj.hetongzhang),
  //           farenzhang: this.trim(pobj.farenzhang),
  //         };
  //         return await this.businessmenSve.putSealInfo(params);
  //       }
  //       case "30": { //"银行已开户"
  //         var params = {
  //           orderId: pobj.orderId,
  //           isBank: Number(pobj.isBank) == 1,
  //           bankName: this.trim(pobj.bankName),
  //           bankNo: this.trim(pobj.bankNo),
  //           bank: this.trim(pobj.bank),
  //           bankImg: this.trim(pobj.bankImg),
  //         }
  //         return await this.businessmenSve.putBankInfo(params);
  //       }
  //       case "40": { //"已税务报到" 
  //         var params = {
  //           orderId: pobj.orderId,
  //           caImg: this.trim(pobj.caImg),
  //           taxRegDay: this.trim(pobj.taxRegDay),
  //           taxOrg: this.trim(pobj.taxOrg),
  //         }
  //         return await this.businessmenSve.putTaxInfo(params);
  //       }
  //       case "50": { //"已邮寄" 
  //         var params = {
  //           orderId: pobj.orderId,
  //           courierNo: this.trim(pobj.courierNo),
  //           courierImg: this.trim(pobj.courierImg),
  //         }
  //         return await this.businessmenSve.putExpressInfo(params);
  //       }
  //       default : {
  //         return system.getResult(null, "状态错误");
  //       }
  //     }
  //   } catch (error) {
  //     console.log(error);
  //     return system.getResultFail(500, "接口异常：" + error.message);
  //   }
  // }
}
module.exports = OrderCtl;