var gulp = require('gulp');
var fs = require("fs");
var tap = require('gulp-tap');
var minimist = require('minimist');
var merge = require('merge-stream');
var rename = require('gulp-rename');
var del = require("del");
var concat = require('gulp-concat');
var gulpif=require("gulp-if");
var knownOptions = {
  string: 'name',
  string: 'bizfile',
  default: { name: process.env.NODE_ENV || 'Test' }
};
var options = minimist(process.argv.slice(2), knownOptions);
var name = options.name;
var bizfile = options.bizfile;
const BUILD_PATH = "./extra/build";
const DEST_PATH = "./extra/dest";
const CTL_PATH = "./app/base/controller/impl";
const SERVICE_PATH = "./app/base/service/impl";
const DAO_PATH = "./app/base/db/impl";
const PAGE_PATH = "./app/front/vues/pages";
const VUECOM_PATH = "./app/front/vues";
const CSS_PATH = "./app/front/entry/public/css";
const IMG_PATH = "./extra/imgs";
const DEST_IMGPATH="./app/front/entry/public/imgs";
const METABIZ_PATH = "./app/base/db/metadata/bizs/wx76a324c5d201d1a4";
gulp.task('makefile', function (done) {
  // 将你的默认的任务代码放在这
  del("./extra/dest/*");
  var tmpName = name.toLowerCase();
  var fstream = gulp.src("./extra/build/*.js")
    .pipe(tap(function (file) {
      var sfile = file.contents.toString('utf-8');
      var rpstr = sfile.replace(/\$\{Name\}/g, name);
      file.contents = new Buffer(rpstr, "utf-8");
    })).pipe(
      rename(function (path) {
        path.basename = path.basename.replace("templ", tmpName);
      })
    ).pipe(gulp.dest("./extra/dest"));
  return fstream;
  // var pageStream=gulp.src("./extra/build/page/**/*").pipe(
  //   gulp.dest("./extra/dest")
  // );
  // return merge(fstream, pageStream);
});

gulp.task('page', function (cbk) {
  var tmpName = name.toLowerCase();
  return gulp.src("./extra/build/page/templPage/*.*")
    .pipe(
      rename(function (path) {
        path.basename = path.basename.replace("templ", tmpName);
      })
    ).pipe(tap(function (file) {
      var sfile = file.contents.toString();
      var rpstr = sfile.replace(/\$\{COMNAME\}/g, "gsb_" + tmpName);
      file.contents = new Buffer(rpstr, "utf-8");
    })).pipe(
      gulp.dest("./extra/dest/" + tmpName + "/")
    );
});

gulp.task("cpctl", function (cbk) {
  var tmpName=name.toLowerCase();
  return gulp.src("./extra/dest/" + tmpName + "Ctl.js").pipe(
    rename(function (path) {
      path.basename=path.basename.substring(0,1).toLowerCase() + path.basename.substring(1);
    })
  ).pipe(gulp.dest(CTL_PATH));
});
gulp.task("cpsve", function (cbk) {
  var tmpName=name.toLowerCase();
  return gulp.src("./extra/dest/" + tmpName + "Sve.js").pipe(
    rename(function (path) {
      path.basename = path.basename.substring(0, 1).toLowerCase() + path.basename.substring(1);
    })
  ).pipe(gulp.dest(SERVICE_PATH));
});
gulp.task("cpdao", function (cbk) {
  var tmpName=name.toLowerCase();
  return gulp.src("./extra/dest/" + tmpName + "Dao.js").pipe(
    rename(function (path) {
      path.basename = path.basename.substring(0, 1).toLowerCase() + path.basename.substring(1);
    })
  ).pipe(gulp.dest(DAO_PATH));
});
gulp.task("cppage", function (cbk) {
  var tmpName=name.toLowerCase();
  return gulp.src("./extra/dest/" + tmpName + "/*.*").pipe(gulp.dest(PAGE_PATH + "/" + tmpName + "/"));
});
gulp.task("cpbizfile", function (cbk) {
  return gulp.src("./extra/build/page/meta.js").pipe(
    rename(function (path) {
      if (bizfile) {
        path.basename = bizfile;
      } else {
        path.basename = name;
      }
    })
  ).pipe(gulp.dest(METABIZ_PATH + "/"));
});

gulp.task("simple", gulp.series(['page', 'cppage', 'cpbizfile'], function (done) {
  done();
}));
gulp.task('all', gulp.series(['makefile', 'page', 'cpctl', 'cpsve', 'cpdao', 'cppage', 'cpbizfile'], function (done) {
  done();
}));

var minifycss = require('gulp-minify-css')
gulp.task("pagecss",function(cbk){
  function defaultcondition(file){
    if(file.path.indexOf("spring")>=0){
      return false;
    }else if(file.path.indexOf("summer")>=0){
      return false;
    }else if(file.path.indexOf("autumn")>=0){
      return false;
    }else if(file.path.indexOf("winter")>=0){
      return false;
    }else{
      return true;
    }
}
  return gulp.src(VUECOM_PATH+"/**/*/*.css").pipe(
    gulpif(defaultcondition,concat("pagecom.css"))

  ).pipe(minifycss()).pipe(gulp.dest(CSS_PATH+"/"));
});
gulp.task("springcss",function(cbk){
  function springcondition(file){
    if(file.path.indexOf("spring")>=0){
      return true;
    }
    return false;
  }
  return gulp.src(VUECOM_PATH+"/**/*/*.css").pipe(
    gulpif(springcondition,concat("spring.css"))
  ).pipe(minifycss()).pipe(gulp.dest(CSS_PATH+"/"));
});
gulp.task("summercss",function(cbk){
  function summercondition(file){
    if(file.path.indexOf("summer")>=0){
      return true;
    }
    return false;
  }
  return gulp.src(VUECOM_PATH+"/**/*/*.css").pipe(
    gulpif(summercondition,concat("summer.css"))
  ).pipe(minifycss()).pipe(gulp.dest(CSS_PATH+"/"));
});
gulp.task("autumncss",function(cbk){
  function autumncondition(file){
    if(file.path.indexOf("autumn")>=0){
      return true;
    }
    return false;
  }
  return gulp.src(VUECOM_PATH+"/**/*/*.css").pipe(
    gulpif(autumncondition,concat("autumn.css"))
  ).pipe(minifycss()).pipe(gulp.dest(CSS_PATH+"/"));
});
gulp.task("wintercss",function(cbk){
  function wintercondition(file){
    if(file.path.indexOf("winter")>=0){
      return true;
    }
    return false;
  }
  return gulp.src(VUECOM_PATH+"/**/*/*.css").pipe(
    gulpif(wintercondition,concat("winter.css"))
  ).pipe(minifycss()).pipe(gulp.dest(CSS_PATH+"/"));
});
gulp.task('allcss', gulp.series(['pagecss', 'springcss', 'summercss', 'autumncss', 'wintercss'], function (done) {
  done();
}));
gulp.task('watch', function () {
  gulp.watch(VUECOM_PATH+"/**/*/*.css",gulp.series(['allcss']));
});

gulp.task("basehandle",function(cbk){
    return gulp.src(VUECOM_PATH+"/base/**/*.vue").
    pipe(tap(function (file) {
      file.contents=new Buffer(require(file.path).replace(/\n/g,""), "utf-8");
    })).pipe(gulp.dest(VUECOM_PATH+"/allie/base/"));
});

var gulp = require('gulp'),
    imagemin = require('gulp-imagemin');

pngquant = require('imagemin-pngquant'),
gulp.task('testimg', function () {
   del("./extra/testimgs/*");
   return gulp.src(IMG_PATH+'/**/*.{png,jpg,gif,ico}')
        .pipe(imagemin({
          optimizationLevel: 1, //类型：Number  默认：3  取值范围：0-7（优化等级）
          progressive: true, //类型：Boolean 默认：false 无损压缩jpg图片
          interlaced: true, //类型：Boolean 默认：false 隔行扫描gif进行渲染
          multipass: true,//类型：Boolean 默认：false 多次优化svg直到完全优化
          use:[pngquant({
            quality: [0.3]
          })]
        }))
        //.pipe(gulp.dest(DEST_IMGPATH));
        .pipe(gulp.dest("./extra/testimgs/"));
});