﻿var url=require("url");
var System=require("../../base/system");
const settings=require("../settings");
const logCtl=System.getObject("web.oplogCtl");
module.exports = function (app) {
	app.get('/', function(req,res){
     //转到首页
		 res.render("main",{});
	});
	// app.get('/p', function (req, res) {
	// 	res.render("patentyc", {});
	// });
	app.all("/web/*",function(req,res,next){
		if(req.url.indexOf("getRouteConfigWithoutProduct")>0 ||
		    req.url.indexOf("getRsConfig")>0 ||
			req.url.indexOf("getDicConfig")>0 ||
			req.url.indexOf("fetchVcode")>0 ||
			req.url.indexOf("register")>0 ||
			req.url.indexOf("login")>0 ||
			req.url.indexOf("loopplay")>0 ||
			req.url.indexOf("newschannel")>0 ||
			req.url.indexOf("article")>0 ||
			req.url.indexOf("channelquery")>0 ||
			req.url.indexOf("metaCtl")>0 ||
			req.url.indexOf("patentycCtl")>0 ||
			req.url.indexOf("regionalpatentmonitoringCtl")>0 ||
		    req.url.indexOf("getOssConfig")>0){
      return next();
		}
		if(!req.session.user){
			var x={
				status:-99,
				msg:"no login"
			};
			res.end(JSON.stringify(x));
		}else{
			//console.log(req.headers);
			next();
		}
	});
	app.get('/web/:qname/:method', function(req,res){
		  console.log(req.headers);
			req.codepath=req.headers["codepath"];

  	  var classPath=req.params["qname"];
			var methodName=req.params["method"];
			var params=[];
      params.push(req.query);
			params.push(req);
			var p=null;
			var invokeObj= System.getObject("web."+classPath);
			if(invokeObj[methodName]){
				p=invokeObj[methodName].apply(invokeObj,params);
			}
			p.then(r=>{
				res.end(JSON.stringify(r));
			}).then(()=>{
				params.pop();
				logCtl.info({
					 optitle:"web get接口调用info:",
					 op:classPath+"/"+methodName,
					 content:params.length==0?"":"参数："+JSON.stringify(params),
					 clientIp:System.get_client_ip(req),
					 agent:req.headers["user-agent"],
				 });
			}).catch(e=>{
				console.log(e);
				logCtl.error({
					 optitle:"web get接口调用异常error:",
					 op:classPath+"/"+methodName,
					 content:e.stack,
					 clientIp:System.get_client_ip(req),
					 agent:req.headers["user-agent"],
				 });
			});
	});
	app.post('/web/:qname/:method',  function(req,res){
			req.codepath=req.headers["codepath"];
		  var classPath=req.params["qname"];
	    var methodName=req.params["method"];
			var params=[];
      params.push(req.query);
			params.push(req.body);
			params.push(req);
			var p=null;
			var invokeObj= System.getObject("web."+classPath);
			if(invokeObj[methodName]){
				p=invokeObj[methodName].apply(invokeObj,params);
			}
			p.then(r=>{
				res.end(JSON.stringify(r));
			}).then(()=>{
				params.pop();
				logCtl.info({
					 optitle:"web post接口调用info:",
					 op:classPath+"/"+methodName,
					 content:params.length==0?"":"参数："+JSON.stringify(params),
					 clientIp:System.get_client_ip(req),
					 agent:req.headers["user-agent"],
				 });
			}).catch(e=>{
				var s=System.getResult2(null,null,null,e.message);
				logCtl.error({
					 optitle:"web post接口调用异常error:",
					 op:classPath+"/"+methodName,
					 content:e.stack,
					 clientIp:System.get_client_ip(req),
					 agent:req.headers["user-agent"],
				 });
				 res.end(JSON.stringify(s));
			});

	});
};
