var url = require("url");
var System = require("../../base/system");
const settings = require("../settings");
const logCtl = System.getObject("web.oplogCtl");
module.exports = function (app) {
    app.all("/applet/*", function (req, res, next) {
        return next();
    });

    app.get('/applet/:qname/:method', async function (req, res) {
        console.log("get");
        try {
            console.log(req.headers);
            req.codepath = req.headers["codepath"];
            var classPath = req.params["qname"];
            var methodName = req.params["method"];
            var tClientIp = System.get_client_ip(req);
            var params = [];
            params.push(req.query);
            var db = System.getObject("db.connection").getCon();
            var cacheManager = System.getObject("db.cacheManager");
            var key = req.query.key;
            if (key) {
                var userInfo = await cacheManager["BMUserCache"].get(key);
                if (userInfo) {
                    req["loginUser"] = JSON.parse(userInfo);
                }
            }
            params.push(req);
            var p = null;
            var invokeObj = System.getObject("applet." + classPath);
            if (invokeObj[methodName]) {
                p = invokeObj[methodName].apply(invokeObj, params);
            }
            p.then(r => {
                res.end(JSON.stringify(r));
            });
        } catch (e) {
            console.log(e);
            logCtl.error({
                optitle: "applet get接口调用异常error:",
                op: classPath + "/" + methodName,
                content: e.stack,
                clientIp: tClientIp,
                agent: req.headers["user-agent"],
            });
        }

    });

    app.post('/applet/:qname/:method', async function (req, res) {
        console.log("post");
        req.codepath = req.headers["codepath"];
        var classPath = req.params["qname"];
        var methodName = req.params["method"];
        var params = [];
        // for(let k in req.query){
        // 	params.push(req.query[k]);
        // }
        params.push(req.query);
        params.push(req.body);
        var tClientIp = System.get_client_ip(req);
        req.body.clientIp = tClientIp;
        var db = System.getObject("db.connection").getCon();
        var cacheManager = System.getObject("db.cacheManager");
        
        params.push(req);
        var key = req.body.key;
        if (key) {  
            params.push(JSON.parse(await cacheManager["BMUserCache"].get(key)));
        }
        var p = null;
        var invokeObj = System.getObject("applet." + classPath);
        if (invokeObj[methodName]) {
            p = invokeObj[methodName].apply(invokeObj, params);
        }
        p.then(r => {
            res.end(JSON.stringify(r));
        }).then(() => {
            params.pop();   
            if(params && params[1] && params[1].file) { 
            } else {
                logCtl.info({   
                    optitle: "applet post接口调用info:",
                    op: classPath + "/" + methodName,
                    content: JSON.stringify(req.body),
                    clientIp: tClientIp,
                    agent: req.headers["user-agent"],
                });
            }
        }).catch(e => {
            console.log(e);
            logCtl.error({
                optitle: "applet post接口调用异常error:",
                op: classPath + "/" + methodName,
                content: e.stack,
                clientIp: tClientIp,
                agent: req.headers["user-agent"],
            });
        });
    });
};