const system=require("../../system");
const ServiceBase=require("../sve.base");
const md5 = require("md5");
class BmuserbizService extends ServiceBase{
  constructor(){
     super(ServiceBase.getDaoName(BmuserbizService));
     //this.appDao=system.getObject("db.appDao");
     this.restClient = system.getObject("util.restClient");

  }

  async saveByStep(userbiz) {
    if(!userbiz || !userbiz.id) {
      return;
    }
    var biz = await this.findById(userbiz.id);
    var step = biz.step;
    if(step == 1) {
      biz.idcard_front = userbiz.idcard_front;
      biz.idcard_back = userbiz.idcard_back;
      biz.idcard = userbiz.idcard;
      biz.realName = userbiz.realName;
      biz.step = 2;
    } else if(step == 2) {
      biz.bank_front = userbiz.bank_front;
      biz.bank_back = userbiz.bank_back;
      biz.bank = userbiz.bank;
      biz.bankno = userbiz.bankno;
      biz.bankaddr = userbiz.bankaddr;
      biz.step = 3;

      // var stdout = await this.checkBank(biz) || {code:1};
      // if(stdout.code != 0) {
      //   return stdout.msg || "银行三要素（姓名、身份证、银行卡）验证失败"
      // }
    } else if(step == 3) {
      biz.person_img = userbiz.person_img;
      biz.legal_name = userbiz.legal_name;
      biz.legal_mobile = userbiz.legal_mobile;
      biz.step = 4;
    } else if(step == 4) {
      biz.companyNames = userbiz.companyNames;
      biz.businessScope = userbiz.businessScope;
      biz.step = 5;
    } else {
      return biz;
    }
    await biz.save();
    return biz;
  }

  async checkBank(biz) {
    var params = {
      accNo : biz.bankno,
      idName: biz.realName,
      idNo: biz.idcard,
      nonceStr: await this.getUidStr(16),
    }
    params.sign = md5("accNo=" + params.accNo + "&idName=" + params.idName + "&idNo=" + params.idNo + "&nonceStr=" + params.nonceStr + "&key=wxf616c0a459d66081").toUpperCase();
    console.log(JSON.stringify(params));
    var rs = await this.restClient.execPost(params, "https://bpohhr.gongsibao.com/api/econtractApi/validateUser");
    return JSON.parse(rs.stdout);
  }
}
module.exports=BmuserbizService;
