const system=require("../../system");
const ServiceBase=require("../sve.base");
class BmrequirementsapplyService extends ServiceBase{
  constructor(){
     super(ServiceBase.getDaoName(BmrequirementsapplyService));
     //this.appDao=system.getObject("db.appDao");
     this.bmrequirementsDao = system.getObject("db.bmrequirementsDao");
     this.dictUtils = system.getObject("util.dictUtils");

  }

  async pageByCondition(params) {
    var currentPage = Number(params.currentPage || 0);
    var pageSize = Number(params.pageSize || 10);

    var where = {};

    if (params.user_id) {
      where.user_id = params.user_id;
    }

    var orderby = [
      ["id", 'desc']
    ];

    var attributes = ["id", "req_id", "user_id", "created_at"];

    var page = await this.getPageList(currentPage, pageSize, where, orderby, attributes);
    if (page && page.rows) {
      await this.setRequirements(page.rows);
      for (var row of page.rows) {
        this.handleDate(row, ["created_at"], null, -8);
      }
    }
    return page;
  }

  async setRequirements(list) {
    if(!list || list.length == 0) {
      return;
    }
    var reqIds = [];
    for(var item of list) {
      reqIds.push(item.req_id);
    }

    if (reqIds.length == 0) {
      return;
    }
    var reqMap = await this.bmrequirementsDao.findMapByIds(reqIds);
    for(var item of list) {
      reqIds.push(item.req_id);
      item.requirements = reqMap["id_" + item.req_id] || {};
      if(item.requirements) {
        this.handleDate(item.requirements, ["publish_time", "created_at"], null, -8);
        item.requirements.statusName = this.dictUtils.getReqStatusName(item.requirements.status);
      }
    }
  }

}
module.exports=BmrequirementsapplyService;
