const system = require("../../system");
const ServiceBase = require("../sve.base");
class BmrequirementsService extends ServiceBase {
  constructor() {
    super(ServiceBase.getDaoName(BmrequirementsService));
    //this.appDao=system.getObject("db.appDao");
    this.dictUtils = system.getObject("util.dictUtils");
  }

  async getById(id) {
    return await this.dao.getById(id);
  }

  async pageByCondition(params) {
    var currentPage = Number(params.currentPage || 0);
    var pageSize = Number(params.pageSize || 10);

    var where = {};

    if (params.name) {
      where.name = {
        [this.db.Op.like]: "%" + params.name + "%"
      };
    }

    var orderby = [
      ["id", 'desc']
    ];

    var attributes = ["id", "name", "type", "teamName", "budget", "desc", "status", "publish_time", "created_at"];

    var page = await this.getPageList(currentPage, pageSize, where, orderby, attributes);
    if (page && page.rows) {
      for (var row of page.rows) {
        this.handleDate(row, ["publish_time", "created_at"], null, -8);
        row.statusName = this.dictUtils.getReqStatusName(row.status);
      }
    }
    return page;
  }
}
module.exports = BmrequirementsService;