const system=require("../../system");
const ServiceBase=require("../sve.base");
class BmorderService extends ServiceBase{
  constructor(){
     super(ServiceBase.getDaoName(BmorderService));
     //this.appDao=system.getObject("db.appDao");
     this.bmuserbizDao = system.getObject("db.bmuserbizDao");
  }
  
  async saveOrderBiz(orderData) {
    var order = orderData.order;
    var userbiz = orderData.userbiz;

    var self = this;
    return this.db.transaction(async function (t) {
      // 创建订单
      order = await self.dao.create(order, t);
      userbiz.orderId = order.id;

      // 创建用户材料
      userbiz = await self.bmuserbizDao.create(userbiz, t);
      return order;
    });
  }


  async pageByCondition(params) {
    var currentPage = Number(params.currentPage || 0);
    var pageSize = Number(params.pageSize || 10);

    var where = {};

    if (params.userId) {
      where.userId = params.userId;
    }

    var orderby = [
      ["id", 'desc']
    ];

    var attributes = ["id", "merchantId", "companyId", "userId", "orderNo", "status", "ownerId", "created_at", "updated_at"];

    var page = await this.getPageList(currentPage, pageSize, where, orderby, attributes);
    if (page && page.rows) {
      await this.setBizs(page.rows);
      await this.setStatusName(page.rows);
      for (var row of page.rows) {
        this.handleDate(row, ["created_at", "updated_at"], null, -8);
      }
    }
    return page;
  }

  async setBizs(list) {
    if (!list || list.length == 0) {
      return;
    }

    var ids = [];
    for (var item of list) {
      ids.push(item.id || 0);
    }
    var bizMap = await this.bmuserbizDao.findMapByOrderIds(ids);
    for (var item of list) {
      item.userbiz = bizMap["id_" + (item.id || 0)];
    }
  }

  async setStatusName(list) {
    if (!list || list.length == 0) {
      return;
    }

    for (var item of list) {
      switch(item.status) {
        case 0 : {
          item.statusName = "信息提交"
          break;
        }
      }
    }
  }

}
module.exports=BmorderService;
