const CacheBase = require("../cache.base");
const system = require("../../system");

class BMUserCache extends CacheBase {
    constructor() {
        super();
        this.bmuserDao = system.getObject("db.bmuserDao");
        this.globalKeyPrefix = "applet_bmuser";
    }
    async del(openid) {
        var key = this.globalKeyPrefix + "_" + openid;
        await this.redisClient.delete(key);
    }
    async set(openid, value) {
        var key = this.globalKeyPrefix + "_"  + openid;
        this.redisClient.set(key, value);
        return key;
    }
    async get(openid) {
        var key = this.globalKeyPrefix + "_"  + openid;
        const value = await this.redisClient.get(key);
        if (value) {
            return value;
        } else {
            var user = await this.bmuserDao.findOne({openId: openid});
            if(user) {
                user = JSON.stringify(user);
                await this.redisClient.set(key, user);
                return user;
            } else {
                return null;
            }
        }
    }
}
module.exports = BMUserCache;