var System = require("../../system");
var settings = require("../../../config/settings");
const ApiBase = require("../api.base");
//const cyjAppKey="ccb00829347e4048833af213e502c8c5";
class GsbIcSearchApi extends ApiBase {
  constructor() {
    super();
    this.iccompanynameSearchUrl = settings.apiconfig.iccompanynameSearchUrl(settings.env);
  };
  buildDate(date) {
    var date = new Date(date);
    var time = Date.parse(date);
    time = time / 1000;
    return time;
  };

  async getConvertSemiangleStr(str) {
    var result = "";
    str = str.replace(/\s+/g, "");
    var len = str.length;
    for (var i = 0; i < len; i++) {
      var cCode = str.charCodeAt(i);
      //全角与半角相差（除空格外）：65248（十进制）
      cCode = (cCode >= 0xFF01 && cCode <= 0xFF5E) ? (cCode - 65248) : cCode;
      //处理空格
      cCode = (cCode == 0x03000) ? 0x0020 : cCode;
      result += String.fromCharCode(cCode);
    }
    return result;
  };
  async companynamesearch(obj) {
    var data = await this.checkKey(obj.appKey);
    if (data && data.status && data.status == -1) {
      return data;
    }
    var companyName = obj.companyName == null ? "" : obj.companyName;
    companyName = await this.getConvertSemiangleStr(companyName);
    var pageSize = obj.pageSize == null ? 15 : obj.pageSize;
    if (obj.currentPage == null) {
      var from = 0;
    } else {
      var from = Number((obj.currentPage - 1) * obj.pageSize);
    }

    var reqUrl = this.iccompanynameSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "query_string": {
                "default_field": "company_name",
                "query": '\"' + companyName + '\"'
              }
            }
          ]
        }
      },
      "from": from,
      "size": pageSize,
      "_source": [
        "company_id",
        "company_province",
        "company_domain",
        "company_name",
        "legal_person",
        "reg_status",
        "reg_unit",
        "reg_capital",
        "estibish_time",
        "reg_location",
        "credit_code"
      ],
      "sort": [
        {
          "reg_capital": "desc"
        }
      ]
    };
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      var sources = [];
      var data = {
        "result": 1,
        "totalSize": j.hits.total,
        "pageSize": pageSize,
        "currentPage": obj.currentPage - 1, "list": sources
      };
      j.hits.hits.forEach(function (c) {
        if (c._source.estibish_time != null) {
          var time = new Date(c._source.estibish_time * 1000);
          c._source.estibish_time = time.toLocaleDateString();
        }
        var source = {
          entId: c._source.company_id,
          province: c._source.company_province,
          domainEntName: c._source.company_domain,
          entName: c._source.company_name,
          entLegalperson: c._source.legal_person,
          entStatus: c._source.reg_status,
          capitalUnit: c._source.reg_unit,
          capitalStandard: c._source.reg_capital,
          foundedTime: c._source.estibish_time,
          regLocation: c._source.reg_location,
          creditCode: c._source.credit_code,
        };
        sources.push(source);
      });
      j.hits.hits = data;
      var a = { status: 0, msg: "操作成功", data: data };
      return a;
    } catch (e) {
      return { status: -1, msg: "操作失败", data: null };
    }
  };
}
module.exports = GsbIcSearchApi;
// var capi=new GsbTmSearchApi();
// capi.xzSearch({}).then(function(result){
//   console.log((result));
// }).catch(function(e){
//   console.log(e);
// });
