var system = require("../../../system")
const CtlBase = require("../../ctlms.base");
class InvoiceCtl extends CtlBase {
  constructor() {
    super();
    this.invoiceSve = system.getObject("service.invoice.invoiceSve");
  }

  /**
   * 申请发票校验
   * @param {*} pobj 
   */
  async verification(pobj) {
    try {
      return await this.invoiceSve.apiVerification(pobj); 
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }

  /**
   * 申请发票校验试算
   * @param {*} pobj 
   */
  async verificationAndCalculation(pobj) {
    try {
      return await this.invoiceSve.apiVerificationAndCalculation(pobj); 
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }

  /**
   * 查询明细（平台）
   * @param {*} pobj 
   */
  async queryInvoice(pobj) {
    try {
      return await this.invoiceSve.apiQueryInvoiceAdmin(pobj); 
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }
   /**
   * 发票明细（交付商）
   * @param {*} pobj 
   */
  async queryInvoiceDeliverer(pobj) {
    try {
      return await this.invoiceSve.apiQueryInvoiceDeliverer(pobj); 
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }

  /**
   * 发票试算接口
   * @param {*} pobj 
   */
  async calcInvoice(pobj) {
    try {
      return await this.invoiceSve.apiCalcInvoice(pobj); 
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }

  /**
   * 发票申请保存
   * @param {*} pobj 
   */
  async saveInvoice(pobj) {
    try {
      return await this.invoiceSve.apiSaveInvoiceAdm(pobj); 
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }

  /**
   * 平台审批
   * @param {*} pobj
   */
  async platformAssignment(pobj){
    try {
      let nextStatus = this.trim(pobj.nextStatus);
      if(nextStatus=="1030"){ //平台交付商分配
        pobj.id=this.trim(pobj.id);
        pobj.delivererAmount=system.y2f(pobj.delivererAmount);
        pobj.merchantId=this.trim(pobj.merchantId);
        pobj.delivererId=this.trim(pobj.delivererId);
        pobj.delivererName=this.trim(pobj.delivererName);
      }else if(nextStatus=="1070"){//平台提交审批
        pobj.id=this.trim(pobj.id);
        pobj.auditContent=this.trim(pobj.auditContent);
        pobj.delivererContent=this.trim(pobj.delivererContent);
        pobj.mailAddr=this.trim(pobj.mailAddr);
        pobj.mailMobile=this.trim(pobj.mailMobile);
        pobj.mailTo=this.trim(pobj.mailTo);
      }else if(nextStatus=="1090"){//平台完成
        pobj.id=this.trim(pobj.id);
        pobj.auditContent=this.trim(pobj.auditContent);
        pobj.delivererContent=this.trim(pobj.delivererContent);
        pobj.mailAddr=this.trim(pobj.mailAddr);
        pobj.mailMobile=this.trim(pobj.mailMobile);
        pobj.mailTo=this.trim(pobj.mailTo);
      }else if(nextStatus=="1300"){//平台第二次审核不通过
        pobj.id=this.trim(pobj.id);
      }
      return await this.invoiceSve.apiPlatformAssignment(pobj); 
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }

  /**
   * 交付商审批
   * @param {*} pobj
   */
  async delivererAssignment(pobj){
    try {
      let nextStatus = this.trim(pobj.nextStatus);
      if(nextStatus=="1050"){ //交付商审批
        pobj.id=this.trim(pobj.id);
        pobj.invoiceNo=this.trim(pobj.invoiceNo);
        pobj.invoiceImg=this.trim(pobj.invoiceImg);
      }else if(nextStatus=="1060"){ //交付商提交审批
        pobj.id=this.trim(pobj.id);
      }else if(nextStatus=="1080"){ //交付商邮寄
        pobj.id=this.trim(pobj.id);
        pobj.mailNo=this.trim(pobj.mailNo);
      }else if(nextStatus=="1040"){ //交付商拒绝处理
        pobj.breakReason=this.trim(pobj.breakReason);
      }
      return await this.invoiceSve.apiDelivererAssignment(pobj); 
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }

  /**
   * 完税证明
   * @param {*} pobj 
   */
  async txPayment(pobj){
    try {
      return await this.invoiceSve.apiTxPayment(pobj); 
    } catch (error) {
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }

  /**
   * 查看完税证明
   * @param {*} pobj 
   */
  async queryTxPayment(pobj){
    try {
      return await this.invoiceSve.apiQueryTxPayment(pobj); 
    } catch (error) {
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }


  /**
   * 发票列表（交付商）
   * @param {*} pobj 
   */
  async delivererInvoices(pobj){
    try {
      return await this.invoiceSve.apiDelivererInvoices(pobj);
    } catch (error) {
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }

  /**
   * 发票审核列表（交付商）
   * @param {*} pobj 
   */
  async delivererApplyInvoices(pobj){
    try {
      return await this.invoiceSve.apiDelivererApplyInvoices(pobj); 
    } catch (error) {
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }

  /**
   * 发票列表（平台）
   * @param {*} pobj 
   */
  async queryInvoices(pobj){
    try {
      return await this.invoiceSve.apiQueryInvoices(pobj); 
    } catch (error) {
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }
  
  /**
   * 发票申请列表（平台）
   * @param {*} pobj 
   */
  async queryApplyInvoices(pobj){
    try {
      return await this.invoiceSve.apiQueryApplyInvoices(pobj); 
    } catch (error) {
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }
  /**
   * 平台更新邮寄号（平台）
   * @param {*} pobj 
   */
  async upEmNo(pobj){
    try {
      return await this.invoiceSve.apiUpEmNo(pobj); 
    } catch (error) {
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }

  async redrush(pobj, pobj2, req, res) {
    try {
      return await this.invoiceSve.apiRedrush(pobj); 
    } catch (error) {
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }
}
module.exports = InvoiceCtl;