var system = require("../../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctlms.base");

var cacheBaseComp = null;
class BusinessmenCtl extends CtlBase {
  constructor() {
    super();
    this.businessmenSve = system.getObject("service.business.businessmenSve");

  }

  async allPage(pobj, pobj2, req) {
    try {
      var condition = {
        currentPage: pobj.currentPage,
        pageSize: pobj.pageSize,
        merchantId: pobj.merchantId,
        orderId: this.trim(pobj.orderId),
        bstatus: pobj.status,
      }

      return await this.businessmenSve.allPage(condition);
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, "接口异常：" + error.message);
    }
  }

  async info(pobj, pobj2, req) {
    try {
      var condition = {
        id: pobj.id,
      }

      return await this.businessmenSve.info(condition);
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, "接口异常：" + error.message);
    }
  }

  async sign(pobj, pobj2, req) {
    var params = {
      id: pobj.id,
      taxUpType: pobj.taxUpType,
      addValueUpType: pobj.addValueUpType,
      costRate: system.y2f(pobj.costRate),
      taxRate: system.y2f(pobj.taxRate),
      serviceRate: system.y2f(pobj.serviceRate),

      signNotes: this.trim(pobj.signNotes),

      commonTaxLadder: JSON.stringify(pobj.commonTaxLadder),
      commonOtherLadder: JSON.stringify(pobj.commonOtherLadder),
      specialTaxLadder: JSON.stringify(pobj.specialTaxLadder),
      specialOtherLadder: JSON.stringify(pobj.specialOtherLadder),
      invoicecontents: pobj.invoicecontents,
    }
    try {
      return await this.businessmenSve.sign(params);
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, "接口异常：" + error.message);
    }
  }

  async signNames(pobj, pobj2, req) {
    try {
      var condition = {
        bstatuses: ["2020"],
      }
      return await this.businessmenSve.nameList(condition);
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, "接口异常：" + error.message);
    }
  }

  async signPage(pobj, pobj2, req) {
    try {
      var condition = {
        currentPage: pobj.currentPage,
        pageSize: pobj.pageSize,
        businessmenId: pobj.businessmenId,
      }

      return await this.businessmenSve.signPage(condition);
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, "接口异常：" + error.message);
    }
  }

  
  async deliverPage(pobj, pobj2, req) {
    try {
      var condition = {
        currentPage: pobj.currentPage,
        pageSize: pobj.pageSize,
        orderId: pobj.orderId,
        dstatus: pobj.status,
        deliverId: "",
      }

      return await this.businessmenSve.deliverPage(condition);
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, "接口异常：" + error.message);
    }
  }


  // async auditContract(pobj, pobj2, req) {
  //   try {
  //     var id = Number(pobj.id);
  //     var status = Number(pobj.status);
  //     var notes = this.trim(pobj.notes);

  //     return await this.service.auditContract(id, status, notes);
  //   } catch (error) {
  //     console.log(error);
  //     return system.getResultFail(500, "接口异常：" + error.message);
  //   }
  // }

  // async businessmenSign(pobj, pobj2, req) {
  //   var params = {
  //     id: pobj.id,
  //     commonTaxLadder: this.trim(pobj.commonTaxLadder),
  //     commonOtherLadder: this.trim(pobj.commonOtherLadder),
  //     specialTaxLadder: this.trim(pobj.specialTaxLadder),
  //     specialOtherLadder: this.trim(pobj.specialOtherLadder),
  //   }
  //   try {
  //     return await this.service.businessmenSign(params);
  //   } catch (error) {
  //     console.log(error);
  //     return system.getResultFail(500, "接口异常：" + error.message);
  //   }
  // }
}
module.exports = BusinessmenCtl;