<a name="menu">目录</a>
1. [订单办理](#list)
1. [新建进度](#newStatus)
1. [订单办理查询](#info)
1. [订单办理编辑](#edit)



## **<a name="list"> 订单办理</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript
    {
        "action_process": "test",
        "action_type": "addOrder",
        "action_body": {
            "merchantId": "11064622752480048",          // 商户id
            "channelOrderNo": "xxxxxxxxx111",           // 渠道订单号
            "legalName": "杨庆菊",                       // 法人姓名
            "legalMobile": "杨庆菊手机号",                // 法人手机号
            "legalImg": "法人照片",                      // 法人照皮那
            "idcard": "123身份证",                       // 身份证
            "idcardFront": "在正面",                     // 身份证正面照
            "idcardBack": "反面",                        // 身份证反面照
            "bankNo": "2222",                           // 银行卡号
            "bank": "开户行",                            // 开户行
            "bankImg": "这是银行卡照片",                  // 银行卡照片
            "names": "山驴比1,山驴比2,山驴比3",            // 姓名
            "capital": "到底是多少"                      // 注册资金

            "businessScope_id": "1221812759600065",    // 经营范围id
            "businessType": "太难了",                   // 经营范围
            "businessScope": "太狠了",                  // 经营范围详情
        }
    }


```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success",
        "data": {
            "count": 16,
            "rows": [
                {
                    "id": "12113463373001693",                      // 办理id
                    "order_id": "13180532598003688",                // 订单id

                    "status": "1020",                               // 订单状态
                    "statusName": "执照办理11",                      // 订单状态名称
                    "nextStatus": "1030",                           // 订单下一个状态
                    "nextStatusName": "已出执照",                    // 订单下一个状态名称

                    "deliver_id": "13120681466000118",              // 交付商id
                    "deliverName": "杨庆菊交付商222",                 // 交付商名称
                    "deliverDivide": 3311,                          // 交付商分成（分）
                    "deliverDivide_y": "33.11",                     // 交付商分成（元）
                    "breakReason": null,                            // 终止原因
                    "created_at": "2019-10-05 09:47:10",            // 创建时间
                    
                    "order": {                                      // 交付商关联的订单
                        "id": "13180532598003688",                  // 订单id
                        "merchantId": "11064622752480048",          // 商户id
                        "channelOrderNo": "xxxxxxxxx111",           // 渠道订单号
                        "legalName": "杨庆菊",                       // 法人姓名
                        "legalMobile": "杨庆菊手机号",                // 法人手机号
                        "legalImg": "法人照片",                      // 法人照皮那
                        "idcard": "123身份证",                       // 身份证
                        "idcardFront": "在正面",                     // 身份证正面照
                        "idcardBack": "反面",                        // 身份证反面照
                        "bankNo": "2222",                           // 银行卡号
                        "bank": "开户行",                            // 开户行
                        "bankImg": "这是银行卡照片",                  // 银行卡照片
                        "names": "山驴比1,山驴比2,山驴比3",            // 姓名
                        "capital": "到底是多少"                      // 注册资金

                        "businessScope_id": "1221812759600065",    // 经营范围id
                        "businessType": "太难了",                   // 经营范围
                        "businessScope": "太狠了",                  // 经营范围详情
                    }
                },
            ]
        },
        "requestid": "6ae7c9592fbe41beae1ed68a15d9ca92"
    }
```


## **<a name="newStatus"> 新建进度 </a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript
    {
        "action_process": "test",
        "action_type": "addOrder",
        "action_body": {
            // 公共变量，所有情况都需要传
            "id": "1",                              // 订单办理id
            "status": "1010",                       // 订单状态
            
            // 出执照
            "name": "杨庆菊有限公司",                 // 个体工商户名称
            "creditCode": "xxxxxx333333333",        // 社会统一信用代码
            "businessPlace": "来广营地铁站",         // 经营场所
            "businessScope": "1,2，3,4,5，",         // 经营范围
            "regDate": "2019-01-22",                // 注册时间
            "businessImg": "http:1.png"             // 执照照片

            // 刻章办理
            "gongzhang": "http://gongzhang.png",            // 公章
            "caiwuzhang": "http://caiwuzhang.png",          // 财务章
            "fapiaozhang": "http://fapiaozhang.png",        // 发票章
            "hetongzhang": "http://hetongzhang.png",        // 合同章
            "farenzhang": "http://farenzhang.png"           // 法人章

            // 银行开户
            "isBank":"1",                                   // 是否开户 0否 1是
            "bankName":"https://bankName",                  // 账户名称
            "bankNo":"https://bankNo",                      // 账户号
            "bank":"https://bank",                          // 开户行
            "bankImg":"https://bankImg",                    // 账户信息

            // 税务报到
            "caImg": "12313212",                    // CA认证图
            "taxRegDay": "2019-01-01",              // 税务登记日
            "taxOrg": "12333"                       // 税务机构名称
            
            // 已邮寄
            "courierNo": "111111111"              // 快递单号
            "courierImg": "快递交接图片"            // courierImg`
        }
    }

```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "success",
}

```

## **<a name="info"> 订单办理查询 </a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript
    {
        "action_process": "test",
        "action_type": "orderDeliverInfo",
        "action_body": {
            "id": "12113458131000120"           // 订单办理id
        }
    }

```

#### 返回结果
```javascript

    {
        "status": 0,
        "msg": "success",
        "data": {

            // 订单办理信息
            "deliverOrder": {
                "id": "12113463373001693",                      // 办理id
                "order_id": "13180532598003688",                // 订单id

                "status": "1020",                               // 订单状态
                "statusName": "执照办理11",                      // 订单状态名称
                "nextStatus": "1030",                           // 订单下一个状态
                "nextStatusName": "已出执照",                    // 订单下一个状态名称

                "deliver_id": "13120681466000118",              // 交付商id
                "deliverName": "杨庆菊交付商222",                 // 交付商名称
                "deliverDivide": 3311,                          // 交付商分成（分）
                "deliverDivide_y": "33.11",                     // 交付商分成（元）
                "breakReason": null,                            // 终止原因
                "created_at": "2019-10-05 09:47:10",            // 创建时间
            },
            // 订单信息
            "order": {
                "id": "13180527789003380",                          // 订单号\订单号
                "merchant_id": "11064622752480048",                 // 商户id
                "channelOrderNo": "xxxxxxxxx111",                   // 渠道订单号
                "price": 300000,                                    // 订单价格（分）
                "price_y": "3000",                                  // 订单价格（元）
                "legalName": "杨庆菊",                               // 法人姓名
                "legalMobile": "杨庆菊手机号",                        // 法人手机号
                "legalImg": "法人照片",                              // 法人照片
                "idcard": "123身份证",                               // 身份证号码
                "idcardFront": "在正面",                             // 身份证正面图
                "idcardBack": "反面",                                // 身份证反面图
                "bankNo": "2222",                                   // 银行卡号
                "bank": "开户行",                                    // 开户行
                "bankImg": "这是银行卡照片",                          // 银行卡照片
                "names": "山驴比1,山驴比2,山驴比3",                    // 2～3个注册名称，逗号分割

                "businessScope_id": "12218127596000645",            // 经营范围id
                "businessType": "太难了",                            // 经营范围
                "businessScope": "太狠了",                           // 经营范围详情
                "capital": "到底是多少",                              // 注册资本
                "statusName": "未付款",                              // 订单状态名称
                "status": "1000",                                   // 订单状态
                "assignTime": null,                                 // 分配时间
                "created_at": "2019-10-05 06:57:28",                // 创建时间
            },

            // 个体工商户信息
            "businessmen": {
                "id": "12795594625000138",                          // 个体户id
                "order_id": "13180532689003786",                    // 订单编号
                "channelOrderNo": "xxxxxxxxx116",                   // 渠道订单那好
                "status": "1100",                                   // 个体户状态
                "statusName": "待签约",                              // 个体户状态名称

                // 个体工商户执照信息
                "legalName": "杨庆菊",                               // 法人姓名
                "legalMobile": "杨庆菊手机号",                        // 法人手机号
                "legalIdcard": "2222222222",                        // 法人身份证号
                "name": "杨庆菊有限公司",                             // 个体户名称
                "creditCode": "xxxxxx333333333",                    // 统一社会信用代码
                "businessPlace": "来广营地铁站",                      // 经营场所
                "businessScope": "1,2，3,4,5，",                     // 经营范围
                "regDate": "2019-01-22",                            // 注册日期
                "businessImg": "http:1.png",                        // 执照照片


                // 个体工商户刻章信息
                "gongzhang": "http://gongzhang.png",                // 公章
                "caiwuzhang": "http://caiwuzhang.png",              // 财务章
                "fapiaozhang": "http://fapiaozhang.png",            // 发票章
                "hetongzhang": "http://hetongzhang.png",            // 合同章
                "farenzhang": "http://farenzhang.png",              // 法人章


                // 个体户开户信息   
                "isBank": 1,                                        // 是否开户 0否 1是
                "bankName": "https://bankName",                     // 账户名称
                "bankNo": "https://bankNo",                         // 帐号
                "bank": "https://bank",                             // 开户行
                "bankImg": "https://bankImg",                       // 账户图片

                "caImg": "12313212",                                // CA照片
                "taxRegDay": "2019-01-01",                          // 税务登记日
                "taxOrg": "12333",                                  // 税务机构名称

                "courierNo": "111111111",                           // 快递单号
                "courierImg": "快递交接图片",                         // 快递交接图片
                "created_at": "2019-10-06 07:19:07",
                "updated_at": "2019-10-06 07:38:57"
            }
        },
        "requestid": "ce549dd87309421e94db1d50df06086d"
    }

```

## **<a name="edit"> 订单办理编辑 </a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript
    {
        "action_process": "test",
        "action_type": "addOrder",
        "action_body": {
            // 订单对象
            "order": {
                "id": "13180527789003380",                          // 订单id\订单号
                "legalName": "杨庆菊",                               // 法人姓名
                "idcard": "123身份证",                               // 身份证号码

                "legalMobile": "杨庆菊手机号",                        // 法人手机号
                "bankNo": "2222",                                   // 银行卡号
                "capital": "到底是多少",                              // 注册资本
                "names": "山驴比1,山驴比2,山驴比3",                    // 2～3个个体工商户名称
                "businessType": "太难了",                            // 经营范围
                "businessScope": "太狠了",                           // 经营范围详情

                "idcardFront": "在正面",                             // 身份证正面图
                "idcardBack": "反面",                                // 身份证反面图
            },

            // 个体工商户信息
            "businessmen": {
                "id": "12795594625000138",                          // 个体户id

                // 个体工商户执照信息
                "name": "杨庆菊有限公司",                             // 个体户名称
                "creditCode": "xxxxxx333333333",                    // 统一社会信用代码
                "businessPlace": "来广营地铁站",                      // 经营场所
                "legalName": "杨庆菊",                               // 法人姓名
                "legalMobile": "杨庆菊手机号",                        // 法人手机号
                "legalIdcard": "2222222222",                        // 法人身份证号
                "regDate": "2019-01-22",                            // 注册日期
                "businessScope": "1,2，3,4,5，",                     // 经营范围
                "businessImg": "http:1.png",                        // 执照照片


                // 个体工商户刻章信息
                "gongzhang": "http://gongzhang.png",                // 公章
                "caiwuzhang": "http://caiwuzhang.png",              // 财务章
                "fapiaozhang": "http://fapiaozhang.png",            // 发票章
                "hetongzhang": "http://hetongzhang.png",            // 合同章
                "farenzhang": "http://farenzhang.png",              // 法人章


                // 个体户开户信息   
                "isBank": 1,                                        // 是否开户 0否 1是
                "bankName": "https://bankName",                     // 账户名称
                "bankNo": "https://bankNo",                         // 帐号
                "bank": "https://bank",                             // 开户行
                "bankImg": "https://bankImg",                       // 账户图片

                // 税务报道信息
                "caImg": "12313212",                                // CA照片
                "taxRegDay": "2019-01-01",                          // 税务登记日
                "taxOrg": "12333",                                  // 税务机构名称

                // 邮寄信息
                "courierNo": "111111111",                           // 快递单号
                "courierImg": "快递交接图片",                         // 快递交接图片
            }
        }
    }

```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "success",
}

```



