var path = require('path');
var ENVINPUT = {
  DB_HOST: process.env.DB_HOST,
  DB_PORT: process.env.DB_PORT,
  DB_USER: process.env.DB_USER,
  DB_PWD: process.env.DB_PWD,
  DB_NAME: process.env.XGGSVEORDER_DB_NAME,
  REDIS_HOST: process.env.REDIS_HOST,
  REDIS_PORT: process.env.REDIS_PORT,
  REDIS_PWD: process.env.REDIS_PWD,
  REDIS_DB: process.env.XGGSVEORDER_REDIS_DB,
  APP_ENV: process.env.APP_ENV ? process.env.APP_ENV : "dev"
};
var settings = {
  env: ENVINPUT.APP_ENV,
  platformid: 1,
  platformcompanyid: 1,
  commonroleid: 1,
  passroleid: 2,
  tanentroleid: 1,
  protocalPrefix: "http://",
  appKey: "40d64e586551405c9bcafab87266bb04",
  secret: "f99d413b767f09b5dff0b3610366cc46",
  salt: "%iatpD1gcxz7iF#B",
  defaultpwd: "987456",
  basepath: path.normalize(path.join(__dirname, '../..')),
  port: process.env.NODE_PORT || 3103,
  reqEsAddr: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return "http://43.247.184.94:7200/"; //localsettings.reqEsDevUrl;
    } else {
      return "http://43.247.184.94:7200/";
    }
  },
  apiconfig: {
    opLogUrl: function () {
      return settings.reqEsAddr() + "bigdata_zc_op_log/_doc?pretty";
    },
    opLogEsIsAdd: function () {
      return 1;
    },
  },
  homePage: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return localsettings.reqHomePageDevUrl;
    } else {
      return "http://open.gongsibao.com/";
    }
  },
  authUrl: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return localsettings.reqAuthUrl;
    } else {
      return "http://open.gongsibao.com/auth";
    }
  },
  docUrl: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return localsettings.docUrl;
    } else {
      return "http://open.gongsibao.com/web/common/metaCtl/getApiDoc";
    }
  },
  redis: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return localsettings.redis;
    } else {
      return {
        host: ENVINPUT.REDIS_HOST,
        port: ENVINPUT.REDIS_PORT,
        password: ENVINPUT.REDIS_PWD,
        db: ENVINPUT.REDIS_DB,
      };
    }
  },
  database: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return localsettings.database;
    } else {
      return {
        dbname: ENVINPUT.DB_NAME,
        user: ENVINPUT.DB_USER,
        password: ENVINPUT.DB_PWD,
        config: {
          host: ENVINPUT.DB_HOST,
          dialect: 'mysql',
          operatorsAliases: false,
          pool: {
            max: 5,
            min: 0,
            acquire: 90000000,
            idle: 1000000
          },
          debug: false,
          dialectOptions: {
            requestTimeout: 999999,
            // instanceName:'DEV'
          } //设置MSSQL超时时间
        },
      };
    }
  }
};
settings.ENVINPUT = ENVINPUT;
module.exports = settings;