const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("iborder", {
    merchant_id: DataTypes.STRING(32),
    channelOrderNo: DataTypes.STRING(64),
    price: DataTypes.BIGINT,
    legalName: DataTypes.STRING(20),
    legalMobile: DataTypes.STRING(20),
    legalImg: DataTypes.STRING(300),
    idcard: DataTypes.STRING(20),
    idcardFront: DataTypes.STRING(300),
    idcardBack: DataTypes.STRING(300),

    bankNo: DataTypes.STRING(30),
    bank: DataTypes.STRING(200),
    bankImg: DataTypes.STRING(300),

    names: DataTypes.STRING(300),

    domicile_id: DataTypes.STRING(32),
    domicileName: DataTypes.STRING(20),

    businessScope_id: DataTypes.STRING(32),
    businessType: DataTypes.STRING(100),
    businessScope: DataTypes.STRING(500),

    capital: DataTypes.STRING(100),

    // 平台状态 1000未付款, 1010待处理, 1020执照办理中, 1030已出执照, 1040刻章办理中, 1050已刻章, 
    //         1060银行开户中, 1070银行已开户, 1080税务报道中, 1090已税务报道, 1100已完成
    status: DataTypes.STRING(10),

    // 订单状态：1000未付款, 1010订单关闭, 1030待处理, 1050执照办理中, 1060已出执照, 1070刻章办理中, 
    //          1080已刻章, 1090银行开户中, 1100银行卡已开户, 1110税务报道中, 1120已税务报道, 1170已完成
    ostatus: DataTypes.STRING(10),

    notes: DataTypes.STRING,   // 备注
    opNotes: DataTypes.STRING, // 操作备注

    bdId: DataTypes.STRING,
    bdPath: DataTypes.STRING,

    userId: DataTypes.STRING,

    mailAddr: DataTypes.STRING,
    mailTo: DataTypes.STRING,
    mailMobile: DataTypes.STRING,

    assignTime: DataTypes.DATE,
    assignUcname: DataTypes.STRING,
    orderDeliverId: DataTypes.STRING,

    deliverType: DataTypes.STRING,
    deliverNo: DataTypes.STRING,
    deliverImg: DataTypes.STRING,
  }, {
    paranoid: true, //假的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    //freezeTableName: true,
    // define the table's name
    tableName: 'ib_order',
    validate: {},
    indexes: [
      // Create a unique index on email
      //  {
      //    unique: true,
      //    fields: ['email']
      //  },
      //
      //  // Creates a gin index on data with the jsonb_path_ops operator
      //  {
      //    fields: ['data'],
      //    using: 'gin',
      //    operator: 'jsonb_path_ops'
      //  },
      //
      //  // By default index name will be [table]_[fields]
      //  // Creates a multi column partial index
      //  {
      //    name: 'public_by_author',
      //    fields: ['author', 'status'],
      //    where: {
      //      status: 'public'
      //    }
      //  },
      //
      //  // A BTREE index with a ordered field
      //  {
      //    name: 'title_index',
      //    method: 'BTREE',
      //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
      //  }
    ]
  });
}