const system = require("../../../system");
const settings = require("../../../../config/settings");
module.exports = (db, DataTypes) => {
  return db.define("businessmen", {
    order_id: DataTypes.STRING(32),
    merchant_id: DataTypes.STRING(32),
    channelOrderNo: DataTypes.STRING(64),

    // 业务状态: 2000办理中, 2010待签约, 2020已完成
    bstatus: DataTypes.STRING(10),
    // 客户状态: 2000办理中, 2020已完成
    gstatus: DataTypes.STRING(10),
    // 客户状态: 2000办理中, 2020已完成
    dstatus: DataTypes.STRING(10),

    legalName: DataTypes.STRING(20),
    legalMobile: DataTypes.STRING(20),
    legalIdcard: DataTypes.STRING(30),

    name: DataTypes.STRING(100),
    creditCode: DataTypes.STRING(100),
    businessPlace: DataTypes.STRING(100),
    businessScope: DataTypes.STRING(500),
    regDate: DataTypes.DATE,
    businessImg: DataTypes.STRING(300),
    gongzhang: DataTypes.STRING(300),
    caiwuzhang: DataTypes.STRING(300),
    fapiaozhang: DataTypes.STRING(300),
    hetongzhang: DataTypes.STRING(300),
    farenzhang: DataTypes.STRING(300),
    isBank: {
      type: DataTypes.BOOLEAN,
      defaultValue: false
    },
    bankName: DataTypes.STRING(50),
    bankNo: DataTypes.STRING(30),
    bank: DataTypes.STRING(100),
    bankImg: DataTypes.STRING(300),
    caImg: DataTypes.STRING(300),
    taxRegDay: DataTypes.DATE,
    taxOrg: DataTypes.STRING(100),
    courierNo: DataTypes.STRING(100),
    courierImg: DataTypes.STRING(100),
    contractStartData: DataTypes.DATE,
    contractEndData: DataTypes.DATE,
    contract: DataTypes.STRING(300), //个体户合同
    notes: DataTypes.STRING, //备注
    opNotes: DataTypes.STRING, //操作备注

    // 个体户签约相关字段
    taxUpType: DataTypes.STRING,
    addValueUpType: DataTypes.STRING,
    costRate: DataTypes.INTEGER,
    taxRate: DataTypes.INTEGER,
    serviceRate: DataTypes.INTEGER,
    signNotes: DataTypes.STRING,

    commonTaxLadder: DataTypes.STRING(1000),
    commonOtherLadder: DataTypes.STRING(1000),
    specialTaxLadder: DataTypes.STRING(1000),
    specialOtherLadder: DataTypes.STRING(1000),

    signTime: DataTypes.DATE,

    bdId: DataTypes.STRING,
    bdPath: DataTypes.STRING,

    userId: DataTypes.STRING,
  }, {
    paranoid: true, //假的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    //freezeTableName: true,
    // define the table's name
    tableName: 'ib_businessmen',
    validate: {},
    indexes: [
      // Create a unique index on email
      //  {
      //    unique: true,
      //    fields: ['email']
      //  },
      //
      //  // Creates a gin index on data with the jsonb_path_ops operator
      //  {
      //    fields: ['data'],
      //    using: 'gin',
      //    operator: 'jsonb_path_ops'
      //  },
      //
      //  // By default index name will be [table]_[fields]
      //  // Creates a multi column partial index
      //  {
      //    name: 'public_by_author',
      //    fields: ['author', 'status'],
      //    where: {
      //      status: 'public'
      //    }
      //  },
      //
      //  // A BTREE index with a ordered field
      //  {
      //    name: 'title_index',
      //    method: 'BTREE',
      //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
      //  }
    ]
  });
}