const system = require("../../../system");
const Dao = require("../../dao.base");
class IborderdeliverDao extends Dao {
  constructor() {
    super(Dao.getModelName(IborderdeliverDao));
    this.statusMap = {
      "1030": "待处理",
      "1040": "关闭订单",
      "1050": "执照办理中",
      "1060": "已出执照",
      "1070": "刻章办理中",
      "1080": "已刻章",
      "1090": "银行开户中",
      "1100": "银行卡已开户",
      "1110": "税务报道中",
      "1120": "已税务报道",
      "1130": "待审核",
      "1140": "审核失败",
      "1150": "审核通过",
      "1160": "已邮寄",
    };
  }

  async findAssignedOrder(orderId) {
    var sql = "SELECT * FROM `ib_order_deliver` WHERE order_id = :orderId AND `status` <> '1040' LIMIT 1";

    var list = await this.customQuery(sql, {
      orderId: orderId
    });

    return list && list.length > 0 ? list[0] : null;
  }

  async findMapByOrderIds(orderIds) {
    var result = {};
    var sql = "SELECT * FROM `ib_order_deliver` WHERE order_id IN (:orderIds) AND `status` <> '1040' LIMIT 1";

    var list = await this.customQuery(sql, {
      orderIds: orderIds
    });

    if (!list || list.length == 0) {
      return result;
    }

    for (var item of list) {
      await this.setRowCodeName(item, "status");
      result[item.order_id] = item;
    }
    return result;
  }

  async findMapByOrderIds(orderIds) {
    var result = {};
    var sql = "SELECT * FROM `ib_order_deliver` WHERE order_id IN (:orderIds) AND `status` <> '9000'";

    var list = await this.customQuery(sql, {
      orderIds: orderIds
    });

    if (!list || list.length == 0) {
      return result;
    }

    for (var item of list) {
      await this.setRowCodeName(item, "status");
      result[item.order_id] = item;
    }
    return result;
  }

  async findMapByIds(ids) {
    var result = {};
    var sql = "SELECT * FROM `ib_order_deliver` WHERE id IN (:ids)";

    var list = await this.customQuery(sql, {
      ids: ids
    });

    if (!list || list.length == 0) {
      return result;
    }

    for (var item of list) {
      await this.setRowCodeName(item, "status");
      result[item.id] = item;
    }
    return result;
  }

  async countStat(params) {
    var sql = [];
    sql.push("SELECT");
    sql.push("COUNT(DISTINCT deliver_id) AS total");
    sql.push("FROM `ib_order_deliver`");
    sql.push("WHERE 1 = 1");

    this.setCondition(params, sql);

    var list = await this.customQuery(sql.join(" "), params);
    return list && list.length > 0 ? (list[0].total || 0) : 0;
  }

  async queryStat(params, startRow, pageSize) {
    var sql = [];
    // SELECT deliver_id, deliverName, SUM(deliverDivide) AS servicePrice FROM `ib_order_deliver` GROUP BY deliver_id;
    sql.push("SELECT");
    sql.push("deliver_id, deliverName, SUM(deliverDivide) AS servicePrice");
    sql.push("FROM `ib_order_deliver` ");
    sql.push("WHERE 1 = 1");

    this.setCondition(params, sql);

    sql.push("GROUP BY deliver_id");
    sql.push("LIMIT :startRow, :pageSize");

    params.startRow = startRow;
    params.pageSize = pageSize;

    var list = await this.customQuery(sql.join(" "), params);
    return list;
  }

  async statDeliverByStatus(params) {
    var sql = [];
    sql.push("SELECT");
    sql.push("deliver_id, `status`, COUNT(1) AS orderCount");
    sql.push("FROM `ib_order_deliver`");
    sql.push("WHERE 1 = 1");

    if(params.deliverIds) {
      sql.push("AND deliver_id IN (:deliverIds)")
    }
    if (params.begin) {
      sql.push("AND created_at >= :begin");
    }
    if (params.end) {
      sql.push("AND created_at <= :end");
    }
    sql.push("GROUP BY `status`");

    var result = {};
    var list = await this.customQuery(sql.join(" "), params);
    if (!list || list.length == 0) {
      return result;
    }

    for (var item of list) {
      result[item.deliver_id + "_" + item.status] = item.orderCount || 0;
    }
    return result;
  }

  setCondition(params, sql) {
    if (params.begin) {
      sql.push("AND created_at >= :begin");
    }
    if (params.end) {
      sql.push("AND created_at <= :end");
    }
  }
}
module.exports = IborderdeliverDao;