const system = require("../../../system");
const Dao = require("../../dao.base");
class IborderDao extends Dao {
  constructor() {
    super(Dao.getModelName(IborderDao));

    this.statusMap = {
      "1000": "未付款",
      "1010": "订单关闭",
      "1020": "待分配",
      "1030": "待处理",
      "1040": "交付商关闭",
      "1050": "执照办理中",
      "1060": "已出执照",
      "1070": "刻章办理中",
      "1080": "已刻章",
      "1090": "银行开户中",
      "1100": "银行卡已开户",
      "1110": "税务报道中",
      "1120": "已税务报道",
      "1130": "待审核",
      "1140": "审核失败",
      "1150": "审核通过",
      "1160": "已邮寄",
      "1170": "已完成",
    };
    this.ostatusMap = {
      "1000": "未付款",
      "1010": "订单关闭",
      "1030": "待处理",
      "1050": "执照办理中",
      "1060": "已出执照",
      "1070": "刻章办理中",
      "1080": "已刻章",
      "1090": "银行开户中",
      "1100": "银行卡已开户",
      "1110": "税务报道中",
      "1120": "已税务报道",
      "1170": "已完成",
    };

    this.deliverTypeMap = {
      "10": "交付商交付",
      "20": "平台交付",
      "30": "平台保存无需交付",
    }
  }

  async statOrderByTime(begin, end) {
    var sql = [];
    sql.push("SELECT");
    sql.push("COUNT(1) AS orderCount, SUM(price) AS orderPrice");
    sql.push("FROM `ib_order`");
    sql.push("WHERE 1 = 1");

    var params = {
      begin: begin,
      end: end
    };
    if (begin) {
      sql.push("AND created_at >= :begin");
    }
    if (end) {
      sql.push("AND created_at <= :end");
    }
    var list = await this.customQuery(sql.join(" "), params);

    if (!list || list.length == 0) {
      return {
        orderCount: 0,
        orderPrice: 0,
      }
    }
    var item = list[0];
    return {
      orderCount: item.orderCount || 0,
      orderPrice: item.orderPrice || 0,
    }
  }

  async statDayByTime(begin, end) {
    var result = {};
    var sql = [];
    sql.push("SELECT");
    sql.push("DATE_FORMAT(created_at, '%Y-%m-%d') AS `day`, SUM(price) AS orderPrice, COUNT(1) AS orderCount");
    sql.push("FROM `ib_order`");
    sql.push("WHERE 1 = 1");

    var params = {
      begin: begin,
      end: end
    };
    if (begin) {
      sql.push("AND created_at >= :begin");
    }
    if (end) {
      sql.push("AND created_at <= :end");
    }
    sql.push("GROUP BY `day` ORDER BY `day` ASC");
    var list = await this.customQuery(sql.join(" "), params);

    if (!list || list.length == 0) {
      return result;
    }
    for (var item of list) {
      result[item.day] = item;
    }
    return result;
  }

  async statMonthByTime(begin, end) {
    var result = {};
    var sql = [];
    sql.push("SELECT");
    sql.push("DATE_FORMAT(created_at, '%Y-%m') AS `month`, SUM(price) AS orderPrice, COUNT(1) AS orderCount");
    sql.push("FROM `ib_order`");
    sql.push("WHERE 1 = 1");

    var params = {
      begin: begin,
      end: end
    };
    if (begin) {
      sql.push("AND created_at >= :begin");
    }
    if (end) {
      sql.push("AND created_at <= :end");
    }

    sql.push("GROUP BY `month` ORDER BY `month` ASC");
    var list = await this.customQuery(sql.join(" "), params);

    if (!list || list.length == 0) {
      return result;
    }

    for (var idx = 0; idx < list.length; idx++) {
      var item = list[idx];
      result[item.month] = item;

      if (idx == 0) {
        result.begin = item.month;
      }

      if (idx == list.length - 1) {
        result.end = item.month;
      }
    }

    return result;
  }

  async statByStatus(begin, end) {
    var sql = [];
    sql.push("SELECT");
    sql.push("`status`, COUNT(1) AS orderCount ");
    sql.push("FROM `ib_order`");
    sql.push("WHERE 1 = 1");
    var params = {
      begin: begin,
      end: end
    };

    if (begin) {
      sql.push("AND created_at >= :begin");
    }
    if (end) {
      sql.push("AND created_at <= :end");
    }

    sql.push("GROUP BY `status`");

    var result = {};
    var list = await this.customQuery(sql.join(" "), params);
    if(!list || list.length == 0) {
      return result;
    }

    for(var item of list) {
      result[item.status] = item.orderCount || 0;
    }
    return result;
  }

}
module.exports = IborderDao;