const system = require("../../../system");
const Dao = require("../../dao.base");
class BusinessmenDao extends Dao {
  constructor() {
    super(Dao.getModelName(BusinessmenDao));
    this.bstatusMap = {
      "2000": "办理中",
      "2010": "待签约",
      "2020": "已完成",
    }
    this.gstatusMap = {
      "2000": "办理中",
      "2020": "已完成",
    }
    this.dstatusMap = {
      "2000": "办理中",
      "2020": "已完成",
    }
  }

  async nameList(bstatuses) {
    var sql = "SELECT id, name FROM " + this.model.tableName + " WHERE 1 = 1 ";
    var params = {};
    if (bstatuses && bstatuses.length > 0) {
      sql = sql + " AND bstatus IN (:bstatuses)  ";
      params.bstatuses = bstatuses;
    }
    return this.customQuery(sql, params);
  }

  async getByOrderId(orderId, attrs) {
    if (!orderId) {
      return null;
    }

    attrs = attrs || "*";
    var sql = "SELECT " + attrs + " FROM " + this.model.tableName + " where order_id = :orderId ";
    var list = await this.customQuery(sql, {
      orderId: orderId
    });
    return list && list.length > 0 ? list[0] : null;
  }

  async getByChannelOrderNo(merchantId, channelOrderNo, attrs) {
    if (!merchantId || !channelOrderNo) {
      return null;
    }
    var params = {
      merchantId: merchantId,
      channelOrderNo: channelOrderNo,
    }

    attrs = attrs || "*";
    var sql = "SELECT " + attrs + " FROM " + this.model.tableName + " where merchant_id = :merchantId AND channelOrderNo = :channelOrderNo LIMIT 1";
    var list = await this.customQuery(sql, params);
    return list && list.length > 0 ? list[0] : null;
  }

  async getByCreditCodes(params, attrs) {
    var creditCodes = params.creditCodes;
    var statuses = params.statuses;
    var result = {};
    if (!creditCodes || creditCodes.length == 0) {
      return result;
    }

    attrs = attrs || "*";
    var sql = "SELECT " + attrs + " FROM " + this.model.tableName + " where creditCode IN (:creditCodes) ";
    if (statuses && statuses.length > 0) {
      sql = sql + " AND bstatus IN (:statuses) "
    }
    return await this.customQuery(sql, params);
  }

  async getMapByCreditCodes(params, attrs) {
    var result = {};
    var list = this.getByCreditCodes(params, attrs);
    if (!list) {
      return result;
    }
    for (var item of list) {
      result[item.creditCode] = item;
    }
    return result;
  }
}
module.exports = BusinessmenDao;