const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
//缓存首次登录的赠送的宝币数量
class VCodeCache extends CacheBase {
  constructor() {
    super();
    this.smsUtil = system.getObject("util.smsClient");
  }
  // isdebug() {
  //   return settings.env == "dev";
  // }
  desc() {
    return "缓存给手机发送的验证码60妙";
  }
  prefix() {
    return "g_vcode:appkey_"
  }
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    //【XXX】您的验证码是：602639（5分钟内有效），工作人员不会索取，请勿泄露。-------描述在模板中配置
    var pobj = val;
    var vcode = await this.smsUtil.getUidStr(6, 10);
    if (pobj && pobj.reqType) {
      switch (pobj.reqType) {
        case "defaultVcode":
          this.smsUtil.sendMsg(pobj.mobile, vcode);
          break;
        case "defaultOtherVcode":
          this.smsUtil.aliSendMsg(pobj.mobile, pobj.tmplCode, pobj.signName, JSON.stringify({ code: vcode }));
          break;
        case "otherVcode":
          this.smsUtil.aliOtherSendMsg(pobj.mobile, pobj.accessKeyId, pobj.accessKeySecret, pobj.tmplCode,
            pobj.signName, JSON.stringify({ code: vcode }));
          break;
        default:
          break;
      }
    }
    return JSON.stringify({ vcode: vcode });
  }
}
module.exports = VCodeCache;
