const APIBase = require("../../api.base");
const system = require("../../../system");
const settings = require("../../../../config/settings");

var db = system.getObject("db.common.connection").getCon();

/**
 * 用户端调用订单相关接口
 */
class Templateconfig extends APIBase {
    constructor() {
        super();
        this.imginfoSve = system.getObject("service.configmag.imginfoSve");
        this.forminfoSve = system.getObject("service.configmag.forminfoSve")
        this.templateinfoSve = system.getObject("service.template.templateinfoSve");
        this.templatelinkSve = system.getObject("service.template.templatelinkSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        var self = this;
        pobj.clientIp = req.clientIp;
        pobj.xctx = req.xctx;
        switch (action_type) {
            case "test"://测试
                opResult = system.getResultSuccess("测试接口");
                break;
            case "getImgList":     // 查询图片
                pobj.actionBody["company_id"] = pobj.company_id;
                opResult = await this.imginfoSve.getImgList(pobj.actionBody);
                break;  
            case "createImginfo":   // 添加图片 
                opResult = await this.imginfoSve.createImginfo(pobj.actionBody);
                break;
            // case "getTemplateList":     // 获取模板列表 
            //     opResult = await this.templateinfoSve.getTemplateList(pobj.actionBody);
            //     // opResult = await this.templateinfoSve.findByCompanyId(pobj.actionBody);
            //     break;
            case "editTemplate":        // 编辑模板信息
                opResult = await this.templateinfoSve.editTemplate(pobj);
                break;
            case "getFormList":     // 获取表单列表
                var actionBody = pobj.actionBody || {};
                actionBody["company_id"] = pobj.company_id;
                opResult = await this.forminfoSve.getFormList(pobj.actionBody);
                break;
            case "getTemplateAndLinkInfo":  // 根据链接参数获取模板链接信息 
                opResult = await this.templatelinkSve.getTemplateAndLinkInfo2(pobj);
                break;
            case "copyFormInfo":        // 复制表单
                opResult = await this.forminfoSve.copyFormInfo(pobj.actionBody);
                break;
            case "deleteFormInfo":      // 删除表单
                opResult = await this.forminfoSve.deleteFormInfo(pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = Templateconfig;
