const APIBase = require("../../api.base");
const system = require("../../../system");
const settings = require("../../../../config/settings");
/**
 * 用户端调用订单相关接口
 */
class Template extends APIBase {
    constructor() {
        super();
        this.templateinfoSve = system.getObject("service.template.templateinfoSve");
        this.templatelinkSve = system.getObject("service.template.templatelinkSve");
        this.formsubmitrecordSve= system.getObject("service.configmag.formsubmitrecordSve");
        this.forminfoSve= system.getObject("service.configmag.forminfoSve");
        this.redisClient = system.getObject("util.redisClient");
        this.formCache={};
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        var self = this;
        pobj.clientIp = req.clientIp;
        pobj.xctx = req.xctx;
        switch (action_type) {
            case "editTemplateContent"://修改模板内容
                opResult = await this.templateinfoSve.editTemplateContent(pobj);
                break;
            case "findOneByCode"://模板查询
                opResult = await this.templateinfoSve.getTemplateInfoByCode(pobj);
                break;
            case "getTemplateAndLinkInfo"://根据链接参数获取模板链接信息
                console.log("getTemplateAndLinkInfo+++++++++++++++++++++++++++");
                console.log(JSON.stringify(pobj));
                opResult = await this.templatelinkSve.getTemplateAndLinkInfo2(pobj);
                break;
            case "submitFormRecord"://提交表单记录
                opResult = await this.formsubmitrecordSve.submitFormRecord(pobj);
                break;
            case "pushFormInfo2Fq"://推送需求表单信息至蜂擎
                opResult = await this.formsubmitrecordSve.pushFormInfo2Fq();
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

    async getFormInfoById(pobj, qobj, req){
        var shaStr = "forminfo_"+pobj.id;
        var rtn = null;
        console.log(this.formCache,"+++++++++++++getFormInfoById++++++++++++++++++++++");
        if(this.formCache[shaStr]){
            rtn = this.formCache[shaStr];
        }else{
            rtn = await this.redisClient.get(shaStr);     // 先试图从redis读取数据 
            if(rtn){
                this.formCache[shaStr] = rtn;
            }
        }
        //---- 从redis中读取到数据
        if (rtn) {    
            var rtnObj = JSON.parse(rtn);
            return system.getResult(rtnObj);
        } else {
            let result = await this.forminfoSve.findOne({id:pobj.id},[]);
            // 将数据保存到redis中
            await this.redisClient.set(shaStr, JSON.stringify(result));
            this.formCache[shaStr] = JSON.stringify(result);
            return system.getResult(result);
        }  
    }
    //删除表单缓存
    async delTemplateFormCache(key){
        if(key && this.formCache[key]){
            delete this.formCache[key];
        }
    }
}
module.exports = Template;
