const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
class PuttypeService extends ServiceBase {
  constructor() {
    super("configmag", ServiceBase.getDaoName(PuttypeService));
    this.templateLink = system.getObject("db.template.templatelinkDao");;
  }

  async create(pobj) {
    if (!pobj.name) {
      return system.getResultFail(-101, 'name can not be empty');
    }
    if (!pobj.code) {
      return system.getResultFail(-102, 'code can not be empty');
    }
    let whereParams = {
      code: pobj.code
    }
    let searchResult = await this.findOne(whereParams, []);
    if (searchResult) {
      return system.getResultFail(-103, '投放方式参数已存在，请勿重复添加');
    }
    return system.getResultSuccess(this.dao.create(pobj));
  }

  async update(pobj) {
    let whereParams = {
      id: pobj.id
    }
    let searchResult = await this.findOne(whereParams, []);
    if (searchResult && searchResult.code) {
      let linkWhere = {
        lauch_type_code: searchResult.code,
        is_enabled:1
      }
      let searchLink = await this.templateLink.findOne(linkWhere, []);
      if (searchLink) {
        return system.getResultFail(-104, '该业务正在投放中，不能修改');
      }
    }
    return system.getResultSuccess(this.dao.update(pobj));
  }

  async delete(pobj) {
    let whereParams = {
      id: pobj.id
    }
    let searchResult = await this.findOne(whereParams, []);
    if (searchResult && searchResult.code) {
      let linkWhere = {
        lauch_type_code: searchResult.code,
        is_enabled:1
      }
      let searchLink = await this.templateLink.findOne(linkWhere, []);
      if (searchLink) {
        return system.getResultFail(-105, '该业务正在投放中，不能删除');
      }
    }
    return system.getResultSuccess(this.dao.delete(pobj));
  }
}
module.exports = PuttypeService;