var system = require("../../../system");
const http = require("http");
const querystring = require('querystring');
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctl.base");
const moment = require("moment");
class NewdeliverCtl extends CtlBase {
    constructor() {
        super("delivery", CtlBase.getServiceName(NewdeliverCtl));
    }

    // 查询 详情
    async findInfo(pobj, qobj, req) {
        try {
            if (!pobj.id) {
                throw new Error("参数错误")
            }
            const rs = await this.service.findInfo(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }


    // 提交材料
    async submitMaterials(pobj, qobj, req) {
        try {
            if (!pobj.deliver_id) {
                throw new Error("参数错误")
            }
            const rs = await this.service.submitMaterials(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }

    // 更改状态
    async changeDeliveryStatus(pobj, qobj, req) {
        try {
            if (!pobj.id) {
                throw new Error("参数错误")
            }
            const rs = await this.service.changeDeliveryStatus(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }

    async addQualification(pobj, qobj, req) {
        if (!pobj.id) {
            return system.getResult(null, "deliver_id  can not be empty，100290");
        }
        if (!pobj.file || !pobj.file.url) {
            return system.getResult(null, "file  can not be empty，100290");
        }
        try {
            let rs = await this.service.addQualification(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }
}
module.exports = NewdeliverCtl;
