var system = require("../../../system");
const CtlBase = require("../../ctl.base");
class CompanycaseCtl extends CtlBase {
    constructor() {
        super("delivery", CtlBase.getServiceName(CompanycaseCtl));
    }

    /* 接受到百度推送过来的工商注册申请材料 */
    async receiveSubmitMaterialsFormBaidu(pobj) {
        let data = pobj.d;
        console.log("接受到百度推送过来的工商注册申请材料:"+JSON.stringify(data))
        try {
            await this.service.receiveSubmitMaterialsFormBaidu(data);
        } catch (err) {
            console.log(err)
            return system.getResult(null, err.message)
        }
    }


    // 提交材料
    async submitMaterials(pobj, qobj, req) {
        try {
            if (!pobj.deliver_id) {
                throw new Error("参数错误")
            }
            const rs = await this.service.submitMaterials(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }
    // 工商通用产品 提交材料
    async companyCaseDeliverCommonSubmitMaterials(pobj, qobj, req) {
        try {
            if (!pobj.deliver_id) {
                throw new Error("参数错误")
            }
            const rs = await this.service.companyCaseDeliverCommonSubmitMaterials(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }
    // 工商通用产品 提交交付物
    async companyCaseDeliverCommonSubmitQualification(pobj, qobj, req) {
        try {
            if (!pobj.deliver_id) {
                throw new Error("参数错误")
            }
            const rs = await this.service.companyCaseDeliverCommonSubmitQualification(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }


    // 更改状态
    async changeDeliveryStatus(pobj, qobj, req) {
        try {
            if (!pobj.id) {
                throw new Error("参数错误")
            }
            const rs = await this.service.changeDeliveryStatus(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }

    // 改变工商状态。工商信息初审未通过、工商信息提交中、工商局审核未通过、工商局审核通过、补正复审中、补正复审未通过、刻章中、刻章完成、证件已上传、证件已邮寄
    async updateGongshangStatus(pobj, qobj, req) {
        try {
            if (!pobj.id) {
                throw new Error("参数错误")
            }
            const rs = await this.service.updateGongshangStatus(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }
}
module.exports = CompanycaseCtl;
