﻿var url = require("url");
var System = require("../../base/system");
const utilszxbankSve = System.getObject("service.utilszxbankSve");
const utilstlbankSve = System.getObject("service.utilstlbankSve");
const xml2js = require("xml2js");
module.exports = function (app) {
	app.use("/api/zx/zxNotify", function (req, res, next) {
		// 获取XML内容
		var buf = '';
		req.setEncoding('utf8');
		req.on('data', function (chunk) {
			buf += chunk;
		});
		// 内容接收完毕
		req.on('end', async function () {
			xml2js.parseString(buf, function (err, json) {
				if (err) {
					err.status = 400;
				} else {
					req.body = json;
				}
			});
			var client_ip = System.get_client_ip(req);
			var result = await utilszxbankSve.receiveCallBackNotify(req.body.root, client_ip);
			res.end(result);
		});
	});

	app.use("/api/tl/zxNotify", async function (req, res, next) {
		var client_ip = System.get_client_ip(req);
		var result = await utilstlbankSve.receiveCallBackNotify(req.body, client_ip);
		res.end(result);
	});

	app.get('/api/:qname/:method', function (req, res) {
		var classPath = req.params["qname"];
		var methodName = req.params["method"];
		var params = [];
		console.log(classPath);
		console.log(methodName);
		console.log("req.query");
		console.log(req.query);
		for (let k in req.query) {
			params.push(req.query[k]);
		}
		console.log(params);
		var p = null;
		var invokeObj = System.getObject("api." + classPath);
		if (invokeObj[methodName]) {
			p = invokeObj[methodName].apply(invokeObj, params);
		}
		p.then(r => {
			res.end(JSON.stringify(r));
		})
	});
	app.post('/api/:qname/:method', function (req, res) {
		var classPath = req.params["qname"];
		var methodName = req.params["method"];
		var params = [];
		for (let k in req.query) {
			params.push(req.query[k]);
		}
		params.push(req.body);
		var p = null;
		var invokeObj = System.getObject("api." + classPath);
		if (invokeObj[methodName]) {
			p = invokeObj[methodName].apply(invokeObj, params);
		}
		p.then(r => {
			res.end(JSON.stringify(r));
		}).then(() => {

		});
	});
};
