const system = require("../../system");
const ServiceBase = require("../sve.base")
const settings = require("../../../config/settings")
class MoneyJourneyService extends ServiceBase {
  constructor() {
    super(ServiceBase.getDaoName(MoneyJourneyService));
    this.companyDao = system.getObject("db.companyDao");
  }
  async fetchRecvExpense(companyid, user) {//进十二个月的回款费用变动图---在使用
    var result = null;
    var isRole = await this.isCheckRole(user, "boss");
    if (isRole) {
      result = await this.db.query(
        'SELECT date_format(created_at, "%Y-%m") as month, sum(channelProfitSum) as receive ,sum(totalPublicExpense) as pay from `biz_order` where orderPayStatus="yfk" and created_at>date_add(last_day(date_sub(curdate(), interval 1 year)), interval 1 day)  and company_id=:status group by date_format(created_at, "%Y-%m")',
        { replacements: { status: companyid }, type: this.db.QueryTypes.SELECT });
    } else {
      result = await this.db.query(
        'SELECT date_format(created_at, "%Y-%m") as month, sum(channelProfitSum) as receive ,sum(totalPublicExpense) as pay from `biz_order` where orderPayStatus="yfk" and created_at>date_add(last_day(date_sub(curdate(), interval 1 year)), interval 1 day)  and company_id=:status and createuser_id=:createuser_id group by date_format(created_at, "%Y-%m")',
        { replacements: { status: companyid, createuser_id: user.id }, type: this.db.QueryTypes.SELECT });
    }

    // if (companyid == 1) {//平台
    //   result = await this.db.query(
    //     'SELECT date_format(created_at, "%Y-%m") as month, sum(pfProfitSum) as receive ,sum(totalPublicExpense) as pay from `biz_order` where orderPayStatus="yfk" and created_at>date_add(last_day(date_sub(curdate(), interval 1 year)), interval 1 day) group by date_format(created_at, "%Y-%m")',
    //     { type: this.db.QueryTypes.SELECT });
    // } else {//非平台
    //   var company = this.companyDao.findOne({ where: { id: companyid }, raw: true });
    //   if (company.companyType == "self") {//独立运作
    //     result = await this.db.query(
    //       'SELECT date_format(created_at, "%Y-%m") as month, sum(totalProfitSum) as receive ,sum(totalPublicExpense) as pay from `biz_order` where orderPayStatus="yfk" and created_at>date_add(last_day(date_sub(curdate(), interval 1 year)), interval 1 day)  and company_id=:status group by date_format(created_at, "%Y-%m")',
    //       { replacements: { status: companyid }, type: this.db.QueryTypes.SELECT });
    //   } else {//委托
    //     result = await this.db.query(
    //       'SELECT date_format(created_at, "%Y-%m") as month, sum(channelProfitSum) as receive ,sum(totalPublicExpense) as pay from `biz_order` where orderPayStatus="yfk" and created_at>date_add(last_day(date_sub(curdate(), interval 1 year)), interval 1 day)  and company_id=:status group by date_format(created_at, "%Y-%m")',
    //       { replacements: { status: companyid }, type: this.db.QueryTypes.SELECT });
    //   }
    // }
    console.log("-------fetchRecvExpense---------");
    var d = new Date();
    var month = d.getMonth() + 1;
    var year = d.getFullYear();
    var a = [];
    if (month == 12) {
      for (var i = 1; i <= 12; i++) {
        if (i < 10) {
          var b = year + "-0" + i;
        } else {
          var b = year + "-" + i;
        }
        a.push({ name: b, receive: 0, pay: 0 });
      }
    } else {
      var b = month;
      var c = year - 1;
      for (var i = 1; i <= 12; i++) {
        b = b + 1;
        if (b <= 12) {
          if (b < 10) {
            var d = c + "-0" + b;
          } else {
            var d = c + "-" + b;
          }
          a.push({ month: d, receive: 0, pay: 0 })
        }
        if (b == 12) {
          c = c + 1;
          b = 0
        };
      }
    }
    var p = { month: [], obj1: [], obj2: [] }
    for (var i = 0; i < a.length; i++) {
      for (var j = 0; j < result.length; j++) {
        if (a[i].month == result[j].month) {
          a[i].receive = result[j].receive;
          a[i].pay = result[j].pay;
        }
      }
      p.month.push(a[i].month);
      p.obj1.push(Number(a[i].pay));
      p.obj2.push(Number(a[i].receive));
    }
    console.log(p);

    return p;
  }
}
module.exports = MoneyJourneyService;
