const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
    // this.db.models.wxapp.belongsTo(this.db.models.company, { as: 'company', constraints: false, });
    return db.define("wxapp", {
        appid: {//公众号appid
            type: DataTypes.STRING,
            allowNull: false,
        },
        authorizer_refresh_token: {//刷新令牌（在授权的公众号具备API权限时，才有此返回值），刷新令牌主要用于公众号第三方平台获取和刷新已授权用户的access_token，只会在授权时刻提供，请妥善保存。 一旦丢失，只能让用户重新授权，才能再次拿到新的刷新令牌
            type: DataTypes.STRING,
            allowNull: false,
        },
        authorized_status_name:DataTypes.STRING(50),
        authorized_status:{//授权状态  "wxop_authorized_status":{"authorized":"授权成功","unauthorized":"取消授权","updateauthorized":"授权更新"},
            type: DataTypes.ENUM,
            values: Object.keys(uiconfig.config.pdict.wxop_authorized_status),
            set: function (val) {
              this.setDataValue("authorized_status", val);
              this.setDataValue("authorized_status_name", uiconfig.config.pdict.wxop_authorized_status[val]);
            }
        },
        nick_name:DataTypes.STRING(50),//授权方昵称
        head_img:DataTypes.STRING(50),//授权方头像
        service_type_info:DataTypes.STRING(50),//授权方公众号类型，0代表订阅号，1代表由历史老帐号升级后的订阅号，2代表服务号
        verify_type_info:DataTypes.STRING(50),//授权方认证类型，-1代表未认证，0代表微信认证，1代表新浪微博认证，2代表腾讯微博认证，3代表已资质认证通过但还未通过名称认证，4代表已资质认证通过、还未通过名称认证，但通过了新浪微博认证，5代表已资质认证通过、还未通过名称认证，但通过了腾讯微博认证
        original_id:DataTypes.STRING(50),//授权方公众号的原始ID
        principal_name:DataTypes.STRING(50),//公众号的主体名称
        alias:DataTypes.STRING(50),//授权方公众号所设置的微信号，可能为空
        qrcode_url:DataTypes.STRING(50),//二维码图片的URL，开发者最好自行也进行保存
        notes: DataTypes.STRING,//备注
        op_notes: DataTypes.STRING(50),//操作备注   
        
    }, {
        paranoid: true,//假的删除
        underscored: true,
        version: true,
        freezeTableName: true,
        //freezeTableName: true,
        // define the table's name
        tableName: 'wx_app',
        validate: {},
        indexes: [
            // Create a unique index on email
            //  {
            //    unique: true,
            //    fields: ['email']
            //  },
            //
            //  // Creates a gin index on data with the jsonb_path_ops operator
            //  {
            //    fields: ['data'],
            //    using: 'gin',
            //    operator: 'jsonb_path_ops'
            //  },
            //
            //  // By default index name will be [table]_[fields]
            //  // Creates a multi column partial index
            //  {
            //    name: 'public_by_author',
            //    fields: ['author', 'status'],
            //    where: {
            //      status: 'public'
            //    }
            //  },
            //
            //  // A BTREE index with a ordered field
            //  {
            //    name: 'title_index',
            //    method: 'BTREE',
            //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
            //  }
        ]
    });
}
