const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  var base = require("../basemodel/codenamebase")(db, DataTypes);
  return db.define("moneyjourney", Object.assign({
    // //订单流程表引用用户信息
    // this.db.models.moneyjourney.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    // this.db.models.moneyjourney.belongsTo(this.db.models.company, { as: 'createcompany', constraints: false, });//创建收款单的公司
    //基类 code: 账单号（自动生成）
    //基类 name: ---暂时没有用

    accountType: {
      //帐户类型:"cash": "现金", "bank": "银行" ,"wx":"微信","alipay":"支付宝","other":"其它"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.accountType),
      set: function (val) {
        this.setDataValue("accountType", val);
        this.setDataValue("accountTypeName", uiconfig.config.pdict.accountType[val]);
      },
      defaultValue: "wx",
    },
    accountTypeName: {//帐户类型名称
      type: DataTypes.STRING,
      defaultValue: "微信",
    },
    directionTypeName: DataTypes.STRING,
    directionType: {//凭单类型,"sr": "收","zc": "支"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.direction_type),
      set: function (val) {
        this.setDataValue("directionType", val);
        this.setDataValue("directionTypeName", uiconfig.config.pdict.direction_type[val]);
      }
    },
    voucherDate: DataTypes.DATE,//凭单时间
    recvAmount: DataTypes.DECIMAL(12, 3),//收总额
    payAmount: DataTypes.DECIMAL(12, 3),//支总额
    sourceTypeName: DataTypes.STRING,
    sourceType: {//来源类型 "order": "订单","expensevoucher": "费用单","receiptvoucher": "收款单", "trademark": "商标单"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.source_type),
      set: function (val) {
        this.setDataValue("sourceType", val);
        this.setDataValue("sourceTypeName", uiconfig.config.pdict.source_type[val]);
      }
    },
    sourceOrderNo: DataTypes.STRING,//来源单号
    auditStatusName: {
      type: DataTypes.STRING(50),
      defaultValue: "待审核",
    },
    auditStatus: {//审核状态"dsh": "待审核", "btg": "不通过", "tg": "通过"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.audit_status),
      set: function (val) {
        this.setDataValue("auditStatus", val);
        this.setDataValue("auditStatusName", uiconfig.config.pdict.audit_status[val]);
      },
      defaultValue: "dsh",
    },
    notes: DataTypes.STRING,//备注
    opNotes: DataTypes.STRING,//操作备注
    payOrderNo: DataTypes.STRING,//支付凭证流水单号，如：微信支付凭证单号
    busPayOrderCode: DataTypes.STRING(100),//业务支付订单号
    buyerOpenId: DataTypes.STRING,//用户在商户appid下的唯一标识或买家在支付宝的用户id
    passTradeNo: DataTypes.STRING,//通道的统一订单号
    buyerAliLogonId: DataTypes.STRING,//买家支付宝账号
  }, base), {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'biz_moneyjourney',
      validate: {
      }
    });
}
