const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {//费用单：
  var base = require("../basemodel/voucherbase")(db, DataTypes);
  return db.define("expensevoucher", Object.assign({
    // //费用表引用帐户信息
    // this.db.models.expensevoucher.belongsTo(this.db.models.moneyaccount, { constraints: false, });
    // //费用表引用用户信息
    // this.db.models.expensevoucher.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    // this.db.models.expensevoucher.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });


    //基类 code: 费用单号（自动生成）
    //基类 name:  ---暂时没有用
    //基类 creator: 创建者
    //基类 updator:/更新者
    //基类 auditor: 审核者
    //基类 opNotes: 操作备注
    //基类 auditStatusName: //审核状态名称
    //基类 auditStatus: //审核状态:ENUM=audit_status，"dsh": "待审核", "btg": "不通过", "tg": "通过"
    //基类 sourceTypeName: //来源类型名称
    //基类 sourceType: //来源类型:ENUM=source_type，"order": "订单","expensevoucher": "费用单","receiptvoucher": "收款单", "trademark": "商标单" 
    //基类 sourceOrderNo: DataTypes.STRING,//来源单号（如：订单号等）
    busPayOrderCode: DataTypes.STRING(100),//业务支付订单号
    payOrderNo: DataTypes.STRING, //支付凭证流水单号，如：微信支付凭证单号
    certifyFileUrl: DataTypes.STRING(500), //证明文件Url
    expenseTypeName: DataTypes.STRING,
    expenseType: {//收款类型，gf: 官费, sxf: 手续费, tax: 税金, salary: 薪酬, sale: 销售费用, mag: 管理费用, channelSettleProfit: 订单渠道分润结算
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.expense_type),
      set: function (val) {
        this.setDataValue("expenseType", val);
        this.setDataValue("expenseTypeName", uiconfig.config.pdict.expense_type[val]);
      }
    },
    totalSum: DataTypes.DECIMAL(12, 3),//总额
    notes: DataTypes.STRING,//备注    
  }, base), {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'biz_expensevoucher',
      validate: {
      }
    });
}
