const pmgnode = require("../subsys/pmg");
const entcenternode = require("../subsys/entcenter");
const personcenternode = require("../subsys/personcenter");
module.exports = {
    "appid": "wx76a324c5d201d1a4",
    "label": "知识产权运营平台",
    "config": {
        "rstree": {
            "code": "toolroot",
            "label": "工具箱",
            "children": [
                {
                    "code": "roleview",
                    "bizCode": "roleview",
                    "isleft": true,
                    "label": "每日概览",
                    "icon": "el-icon-menu",
                    "isMenu": true,
                    "bizConfig": null,
                    "path": "",
                    "isctl": "no"
                },
                pmgnode,
                entcenternode,
                personcenternode,
                {
                    "code": "toolCenter",
                    "label": "辅助工具配置",
                    "src": "",
                    "isSubmenu": false,
                    "isMenu": false,
                    "children": [
                        {
                            "code": "tools", "isGroup": true, "label": "发票申请相关", "children": [
                                {
                                    "code": "invoiceorderreference",
                                    "label": "订单参照",
                                    "bizCode": "invoiceorderreference",
                                    "bizConfig": null,
                                    "path": ""
                                },

                            ],
                            "code": "tools", "isGroup": true, "label": "单据联查相关", "children": [
                                {
                                    "code": "linkquery",
                                    "label": "单据联查",
                                    "bizCode": "linkquery",
                                    "bizConfig": null,
                                    "path": ""
                                },

                            ],
                        }
                    ],
                },
                {
                    "code": "forus",
                    "istop": true,
                    "icon": "",
                    "isMenu": true,
                    "label": "为了你们",
                    "bizCode": "forus",
                    "bizConfig": null,
                    "path": "",
                    "isctl": "no"
                },
                {
                    "code": "opmethods",
                    "istop": true,
                    "icon": "",
                    "isMenu": true,
                    "label": "解决方案",
                    "bizCode": "opmethods",
                    "bizConfig": null,
                    "path": "",
                    "isctl": "no"
                },
                {
                    "code": "solvr",
                    "istop": true,
                    "icon": "",
                    "isMenu": true,
                    "label": "功能介绍",
                    "bizCode": "solvr",
                    "bizConfig": null,
                    "path": "",
                    "isctl": "no"
                },
                {
                    "code": "clientdemos",
                    "istop": true,
                    "icon": "",
                    "isMenu": true,
                    "label": "合作伙伴",
                    "bizCode": "clientdemos",
                    "bizConfig": null,
                    "path": "",
                    "isctl": "no"
                },
                {
                    "code": "home",
                    "istop": true,
                    "icon": "",
                    "isMenu": true,
                    "label": "首页",
                    "bizCode": "home",
                    "bizConfig": null,
                    "path": "",
                    "isctl": "no"
                },
                {
                    "code": "zcfw",
                    "istop": true,
                    "icon": "",
                    "isMenu": true,
                    "label": "知产服务",
                    "bizCode": "zcfw",
                    "bizConfig": null,
                    "path": "",
                    "isctl": "no"
                },
                {
                    "code": "servicecat",
                    "istop": true,
                    "icon": "",
                    "isMenu": true,
                    "label": "服务类目",
                    "bizCode": "servicecat",
                    "bizConfig": null,
                    "path": "",
                    "isctl": "no"
                },
                {
                    "code": "policyquery",
                    "bizCode": "policyquery",
                    "istop": true,
                    "label": "政策查询",
                    "icon": "",
                    "isMenu": true,
                    "bizConfig": null,
                    "path": "",
                    "isctl": "no"
                },
                {
                    "code": "bycquerytm",
                    "bizCode": "bycquerytm",
                    "istop": true,
                    "label": "商标检索",
                    "icon": "",
                    "isMenu": true,
                    "bizConfig": null,
                    "path": "",
                    "isctl": "no"
                },
                {
                    "code": "bytmmonit",
                    "bizCode": "bytmmonit",
                    "istop": true,
                    "label": "商标监控",
                    "icon": "",
                    "isMenu": true,
                    "bizConfig": null,
                    "path": "",
                    "isctl": "no"
                },
                {
                    "code": "tmtransactionmarket",
                    "bizCode": "tmtransactionmarket",
                    "istop": true,
                    "label": "商标交易",
                    "icon": "",
                    "isMenu": true,
                    "bizConfig": null,
                    "path": "",
                    "isctl": "no"
                },
                {
                    "code": "patentsearch",
                    "bizCode": "patentsearch",
                    "istop": true,
                    "label": "专利检索",
                    "icon": "",
                    "isMenu": true,
                    "bizConfig": null,
                    "path": "",
                    "isctl": "no"
                },
                {
                    "code": "areapatentmonitor",
                    "bizCode": "areapatentmonitor",
                    "istop": true,
                    "label": "区域专利监控",
                    "icon": "",
                    "isMenu": true,
                    "bizConfig": null,
                    "path": "",
                    "isctl": "no"
                },
                {
                    "code": "entdecide",
                    "bizCode": "entdecide",
                    "istop": true,
                    "label": "企业决策",
                    "icon": "",
                    "isMenu": true,
                    "bizConfig": null,
                    "path": "",
                    "isctl": "no"
                },
                {
                    "code": "siteapply",
                    "bizCode": "siteapply",
                    "istop": true,
                    "label": "网站开通",
                    "icon": "",
                    "isMenu": true,
                    "bizConfig": null,
                    "path": "",
                    "isctl": "no"
                },
                // {
                //     "code": "openPlatform",
                //     "bizCode": "openPlatform",
                //     "istop": true,
                //     "label": "开放平台",
                //     "icon": "",
                //     "isMenu": true,
                //     "bizConfig": null,
                //     "path": "",
                //     "isctl": "no"
                // },
                {
                    "code": "moreservice",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "首页更多服务",
                    "bizCode": "moreservice",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "servicedetails",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "服务详情",
                    "bizCode": "servicedetails",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "bycdetailtm",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "商标查询详情",
                    "bizCode": "bycdetailtm",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "bycnoticedetailtm",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "商标公告详情",
                    "bizCode": "bycnoticedetailtm",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "bycncldetail",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "商标尼斯查询",
                    "bizCode": "bycncldetail",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "bycnoticetm",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "商标公告查询",
                    "bizCode": "bycnoticetm",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "bycnoticeindex",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "商标公告查询",
                    "bizCode": "bycnoticeindex",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "aboutus",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "关于我们",
                    "bizCode": "aboutus",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "register",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "注册",
                    "bizCode": "register",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "login",
                    "icon": "fa fa-home",
                    "path": "login",
                    "isMenu": false,
                    "label": "登录",
                    "bizCode": "login",
                    "bizConfig": null,
                    "path": "",
                    "istop": true
                },
                {
                    "code": "orderpay",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "订单支付",
                    "bizCode": "orderpay",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "paysuccess",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "支付成功",
                    "bizCode": "paysuccess",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "bytmmonitlist",
                    "label": "商标监控列表",
                    "bizCode": "bytmmonitlist",
                    "bizConfig": null,
                    "path": ""
                },
                {
                    "code": "bytmmonitlist",
                    "label": "商标监控列表",
                    "bizCode": "bytmmonitlist",
                    "bizConfig": null,
                    "path": ""
                },
                {
                    "code": "bytmmonitagency",
                    "label": "商标监控代理机构",
                    "bizCode": "bytmmonitagency",
                    "bizConfig": null,
                    "path": ""
                },
                {
                    "code": "bytmmonitdynamics",
                    "label": "商标监控动态",
                    "bizCode": "bytmmonitdynamics",
                    "bizConfig": null,
                    "path": ""
                },
                {
                    "code": "bytmmonitlistdetails",
                    "label": "商标监控列表详情搜索",
                    "bizCode": "bytmmonitlistdetails",
                    "bizConfig": null,
                    "path": ""
                },
                //工商
                {
                    "code": "icorder",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "订单支付",
                    "bizCode": "icorder",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "entdrawing",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "订单支付",
                    "bizCode": "entdrawing",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "icnameresult",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "订单支付",
                    "bizCode": "icnameresult",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "icproductdetail",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "订单支付",
                    "bizCode": "icproductdetail",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "iframehtml",
                    "icon": "fa fa-search",
                    "label": "网页嵌入",
                    "bizCode": "iframehtml",
                    "bizConfig": null,
                    "path": ""
                },
                //mobile
                {
                    "code": "mobilehome",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobilehome",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobiletest",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobiletest",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobilemanagedocument",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobilemanagedocument",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobilemy",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobilemy",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobiledocapply",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobiledocapply",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobileaddress",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobileaddress",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobilenewaddress",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobilenewaddress",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobileservicetype",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobileservicetype",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobileinvoice",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobileinvoice",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobileinvoicetext",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobileinvoicetext",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobileinvoicedetail",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobileinvoicedetail",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobileinvoicesubmit",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobileinvoicesubmit",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobileinvoiceedit",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobileinvoiceedit",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobilecommoninvoice",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobilecommoninvoice",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobileinvoiceeditspecial",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobileinvoiceeditspecial",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobileabout",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobileabout",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobilemyindent",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobilemyindent",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobilemyindentdetail",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobilemyindentdetail",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobiletypedetail",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobiletypedetail",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobilesearch",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobilesearch",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobilesearchlist",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobilesearchlist",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobilesearchdetail",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobilesearchdetail",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobilesearchflow",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobilesearchflow",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobilebulletin",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobilebulletin",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobilepdf",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobilepdf",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobilelog",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobilelog",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobileserverdetail",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobileserverdetail",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobilesubmitdemand",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobilesubmitdemand",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobilewxauthoback",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobilewxauthoback",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobilesearchservices",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobilesearchservices",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobilesearchdemo",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobilesearchdemo",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobilereport",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobilereport",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobiledeal",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobiledeal",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobiledealdetail",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobiledealdetail",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobiledealsearch",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobiledealsearch",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobiledeallist",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobiledeallist",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "mobilepatent",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "移动测试",
                    "bizCode": "mobilepatent",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "patentanalysis",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "专利分析",
                    "bizCode": "patentanalysis",
                    "bizConfig": null,
                    "path": "",
                },    
                {
                    "code": "patentdetail",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "专利详情",
                    "bizCode": "patentdetail",
                    "bizConfig": null,
                    "path": "",
                },          
                {
                    "code": "declare",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "申报通知",
                    "bizCode": "declare",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "policybigdata",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "政策大数据",
                    "bizCode": "policybigdata",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "projectpublicity",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "立项公式",
                    "bizCode": "projectpublicity",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "managementmeasures",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "管理办法",
                    "bizCode": "managementmeasures",
                    "bizConfig": null,
                    "path": "",
                },

 
            ],
        },
        "bizs": {
            "recommen": {"title": "政策推荐", "config": null, "path":"/recommen", "comname": "recommen"},
            "pay": {"title": "支付订阅", "config": null, "path":"/pay", "comname": "pay"},
            "subscription": {"title": "政策订阅", "config": null, "path":"/subscription", "comname": "subscription"},
            "patentanalysis": { "title": "专利分析", "config": null, "path": "/patentanalysis", "comname": "patentanalysis" },
            "declare": { "title": "申报通知", "config": null, "path": "/declare", "comname": "declare" },
            "managementmeasures": { "title": "管理办法", "config": null, "path": "/managementmeasures", "comname": "managementmeasures" },
            "projectpublicity": { "title": "立项公式", "config": null, "path": "/projectpublicity", "comname": "projectpublicity" },
            "policybigdata": { "title": "政策大数据", "config": null, "path": "/policybigdata", "comname": "policybigdata" },
            "patentdetail": { "title": "专利详情", "config": null, "path": "/patentdetail", "comname": "patentdetail" },
            "policyquery": { "title": "政策列表", "config": null, "path": "/policyquery", "comname": "policyquery" },
            "entdrawing": { "title": "企业画像", "config": null, "path": "/entdrawing", "comname": "entdrawing" },
            "mobilepatent": { "title": "企业画像", "config": null, "path": "/mobilepatent", "comname": "mobilepatent" },
            "mobiledeallist": { "title": "企业画像", "config": null, "path": "/mobiledeallist", "comname": "mobiledeallist" },
            "mobiledealsearch": { "title": "企业画像", "config": null, "path": "/mobiledealsearch", "comname": "mobiledealsearch" },
            "mobiledealdetail": { "title": "企业画像", "config": null, "path": "/mobiledealdetail", "comname": "mobiledealdetail" },
            "mobiledeal": { "title": "企业画像", "config": null, "path": "/mobiledeal", "comname": "mobiledeal" },
            "mobilereport": { "title": "企业画像", "config": null, "path": "/mobilereport", "comname": "mobilereport" },
            "mobilesearchdemo": { "title": "企业画像", "config": null, "path": "/mobilesearchdemo", "comname": "mobilesearchdemo" },
            "mobilesearchservices": { "title": "企业画像", "config": null, "path": "/mobilesearchservices", "comname": "mobilesearchservices" },
            "mobilewxauthoback": { "title": "企业画像", "config": null, "path": "/mobilewxauthoback", "comname": "mobilewxauthoback" },
            "mobiletest": { "title": "移动测试", "config": null, "path": "/mobiletest", "comname": "mobiletest" },
            "mobilesubmitdemand": { "title": "移动测试", "config": null, "path": "/mobilesubmitdemand", "comname": "mobilesubmitdemand" },
            "mobileserverdetail": { "title": "移动测试", "config": null, "path": "/mobileserverdetail", "comname": "mobileserverdetail" },
            "mobilelog": { "title": "移动测试", "config": null, "path": "/mobilelog", "comname": "mobilelog" },
            "mobilepdf": { "title": "移动测试", "config": null, "path": "/mobilepdf", "comname": "mobilepdf" },
            "mobilebulletin": { "title": "移动测试", "config": null, "path": "/mobilebulletin", "comname": "mobilebulletin" },
            "mobilesearchflow": { "title": "移动测试", "config": null, "path": "/mobilesearchflow", "comname": "mobilesearchflow" },
            "mobilesearchdetail": { "title": "移动测试", "config": null, "path": "/mobilesearchdetail", "comname": "mobilesearchdetail" },
            "mobilesearchlist": { "title": "移动测试", "config": null, "path": "/mobilesearchlist", "comname": "mobilesearchlist" },
            "mobilesearch": { "title": "移动测试", "config": null, "path": "/mobilesearch", "comname": "mobilesearch" },
            "mobiletypedetail": { "title": "移动测试", "config": null, "path": "/mobiletypedetail", "comname": "mobiletypedetail" },
            "mobilemyindentdetail": { "title": "移动测试", "config": null, "path": "/mobilemyindentdetail", "comname": "mobilemyindentdetail" },
            "mobilemyindent": { "title": "移动测试", "config": null, "path": "/mobilemyindent", "comname": "mobilemyindent" },
            "mobileabout": { "title": "移动测试", "config": null, "path": "/mobileabout", "comname": "mobileabout" },
            "mobileinvoiceeditspecial": { "title": "移动测试", "config": null, "path": "/mobileinvoiceeditspecial", "comname": "mobileinvoiceeditspecial" },
            "mobilehome": { "title": "移动测试", "config": null, "path": "/mobilehome", "comname": "mobilehome" },
            "mobilecommoninvoice": { "title": "移动测试", "config": null, "path": "/mobilecommoninvoice", "comname": "mobilecommoninvoice" },
            "mobileinvoiceedit": { "title": "移动测试", "config": null, "path": "/mobileinvoiceedit", "comname": "mobileinvoiceedit" },
            "mobileinvoicesubmit": { "title": "移动测试", "config": null, "path": "/mobileinvoicesubmit", "comname": "mobileinvoicesubmit" },
            "mobileinvoicedetail": { "title": "移动测试", "config": null, "path": "/mobileinvoicedetail", "comname": "mobileinvoicedetail" },
            "mobileservicetype": { "title": "移动测试", "config": null, "path": "/mobileservicetype", "comname": "mobileservicetype" },
            "mobileinvoicetext": { "title": "移动测试", "config": null, "path": "/mobileinvoicetext", "comname": "mobileinvoicetext" },
            "mobileinvoice": { "title": "移动测试", "config": null, "path": "/mobileinvoice", "comname": "mobileinvoice" },
            "mobilemanagedocument": { "title": "移动测试", "config": null, "path": "/mobilemanagedocument", "comname": "mobilemanagedocument" },
            "mobilemy": { "title": "移动测试", "config": null, "path": "/mobilemy", "comname": "mobilemy" },
            "mobiledocapply": { "title": "移动测试", "config": null, "path": "/mobiledocapply", "comname": "mobiledocapply" },
            "mobileaddress": { "title": "移动测试", "config": null, "path": "/mobileaddress", "comname": "mobileaddress" },
            "mobilenewaddress": { "title": "移动测试", "config": null, "path": "/mobilenewaddress", "comname": "mobilenewaddress" },

            "iframehtml": { "title": "网页嵌入", "config": null, "path": "/iframehtml", "comname": "iframehtml" },
            "iframehtmlone": { "title": "网页嵌入", "config": null, "path": "/iframehtmlone", "comname": "iframehtmlone" },
            "iframehtmltwo": { "title": "网页嵌入", "config": null, "path": "/iframehtmltwo", "comname": "iframehtmltwo" },
            "pmproduct": { "title": "项目产品管理", "config": null, "path": "/pmproduct", "comname": "pmproduct" },
            "pmproject": { "title": "项目管理", "config": null, "path": "/pmproject", "comname": "pmproject" },
            "pmfollow": { "title": "项目跟进", "config": null, "path": "/pmfollow", "comname": "pmfollow" },
            "mypmfollow": { "title": "我的跟进", "config": null, "path": "/mypmfollow", "comname": "pmfollow" },
            "pmquestion": { "title": "问题管理", "config": null, "path": "/pmquestion", "comname": "pmquestion" },
            "mypmquestion": { "title": "我的问题", "config": null, "path": "/mypmquestion", "comname": "pmquestion" },
            "mysubpmquestion": { "title": "我提交的问题", "config": null, "path": "/mysubpmquestion", "comname": "pmquestion" },

            "icorder": { "title": "问题管理", "config": null, "path": "/icorder", "comname": "icorder" },
            "icnameresult": { "title": "我的问题", "config": null, "path": "/icnameresult", "comname": "icnameresult" },
            "icproductdetail": { "title": "我提交的问题", "config": null, "path": "/icproductdetail", "comname": "icproductdetail" },

            "linkquery": { "title": "每日概览", "config": null, "path": "/linkquery", "comname": "linkquery" },
            "roleview": { "title": "每日概览", "config": null, "path": "/roleview", "comname": "roleview" },
            "company": { "title": "公司站点", "config": null, "path": "/company", "comname": "company" },
            "wxapp": { "title": "授权列表", "config": null, "path": "/wxapp", "comname": "wxapp" },
            "licensecode": { "title": "提报授权", "config": null, "path": "/licensecode", "comname": "licensecode" },
            "cachearches": { "title": "缓存档案", "config": null, "path": "/cachearches", "comname": "cachearches" },
            "tasks": { "title": "平台任务", "config": null, "path": "/tasks", "comname": "tasks" },
            "home": { "title": "首页", "config": null, "path": "/", "comname": "home" },
            "moreservice": { "title": "首页更多服务", "config": null, "path": "/moreservice", "comname": "moreservice" },
            "servicedetails": { "title": "服务详情", "config": null, "path": "/servicedetails", "comname": "servicedetails" },
            "bycdetailtm": { "title": "商标查询详情", "config": null, "path": "/bycdetailtm", "comname": "bycdetailtm" },
            "bycnoticedetailtm": { "title": "商标公告详情", "config": null, "path": "/bycnoticedetailtm", "comname": "bycnoticedetailtm" },
            "bycncldetail": { "title": "商标尼斯查询", "config": null, "path": "/bycncldetail", "comname": "bycncldetail" },
            "bycnoticetm": { "title": "商标公告查询", "config": null, "path": "/bycnoticetm", "comname": "bycnoticetm" },
            "bycnoticeindex": { "title": "商标公告查询", "config": null, "path": "/bycnoticeindex", "comname": "bycnoticeindex" },
            "aboutus": { "title": "关于我们", "config": null, "path": "/aboutus", "comname": "aboutus" },
            "orderpay": { "title": "订单支付", "config": null, "path": "/orderpay", "comname": "orderpay" },
            "paysuccess": { "title": "支付成功", "config": null, "path": "/paysuccess", "comname": "paysuccess" },
            "register": { "title": "注册", "config": null, "path": "/register", "comname": "register" },
            "login": { "title": "登录", "config": null, "path": "/login", "comname": "login" },
            "newschannel": { "title": "频道管理", "config": null, "path": "/newschannel", "comname": "newschannel" },
            "article": { "title": "资讯管理", "config": null, "path": "/article", "comname": "article" },
            "loopplay": { "title": "轮播管理", "config": null, "path": "/loopplay", "comname": "loopplay" },
            "articledetail": { "title": "文章查看", "config": null, "path": "/articledetail/:id", "comname": "articledetail" },
            "systemregist": { "title": "系统报名", "config": null, "path": "/systemregist", "comname": "systemregist" },
            "siteservicestatistic": { "title": "站点业务统计", "config": null, "path": "/siteservicestatistic", "comname": "siteservicestatistic" },
            "sitestatisticorderlist": { "title": "订单列表", "config": null, "path": "/sitestatisticorderlist", "comname": "sitestatisticorderlist" },
            "businesscompany": { "title": "平台线索池", "config": null, "path": "/businesscompany", "comname": "businesscompany" },
            "businessdetail": { "title": "线索详情", "config": null, "path": "/businessdetail", "comname": "businessdetail" },
            "sbadministration": { "title": "站点线索管理", "config": null, "path": "/sbadministration", "comname": "sbadministration" },
            "channelquery": { "title": "按频道查看", "config": null, "path": "/channelquery/:id", "comname": "channelquery" },
            "users": { "title": "用户管理", "config": null, "path": "/users", "comname": "users" },
            "weblink": { "title": "网站链接管理", "config": null, "path": "/weblink", "comname": "weblink" },
            "datapriv": { "title": "用户管理", "config": null, "path": "/datapriv", "comname": "datapriv" },
            "roles": { "title": "角色管理", "config": null, "path": "/roles", "comname": "roles" },
            "bycquerytm": { "title": "标眼查", "config": null, "path": "/bycquerytm", "comname": "bycquerytm" },
            "bytmmonit": { "title": "商标监控", "config": null, "path": "/bytmmonit", "comname": "bytmmonit" },
            "openPlatform": { "title": "开放平台", "config": null, "path": "/openPlatform", "comname": "openPlatform" },
            "tmregister": { "title": "商标注册", "config": null, "path": "/tmregister", "comname": "tmregister" },
            "siteapply": { "title": "网站开通", "config": null, "path": "/siteapply", "comname": "siteapply" },
            "siteinfo": { "title": "站点信息", "config": null, "path": "/siteinfo", "comname": "siteapply" },
            "bindSubscription": { "title": "公众号信息", "config": null, "path": "/bindSubscription", "comname": "bindSubscription" },
            "footerinfo": { "title": "公司信息", "config": null, "path": "/footerinfo", "comname": "footerinfo" },
            "companytheme": { "title": "站点主题", "config": null, "path": "/companytheme", "comname": "companytheme" },
            "sitetheme": { "title": "站点主题", "config": null, "path": "/sitetheme", "comname": "sitetheme" },
            "clientneed": { "title": "客户需求", "config": null, "path": "/clientneed", "comname": "clientneed" },
            "producttype": { "title": "产品类型", "config": null, "path": "/producttype", "comname": "producttype" },
            "productcrud": { "title": "产品维护", "config": null, "path": "/productcrud", "comname": "productcrud" },
            "businesspool": { "title": "商机超市", "config": null, "path": "/businesspool", "comname": "businesscompany" },
            "mybusiness": { "title": "我的商机", "config": null, "path": "/mybusiness", "comname": "businesscompany" },
            "mybusinessdetail": { "title": "商机详情", "config": null, "path": "/mybusinessdetail", "comname": "mybusinessdetail" },
            "businesstmorder": { "title": "商机订单", "config": null, "path": "/businesstmorder", "comname": "businesstmorder" },
            "order": { "title": "订单管理", "config": null, "path": "/order", "comname": "order" },
            "myordermag": { "title": "我的订单", "config": null, "path": "/myordermag", "comname": "order" },
            "agencytmreg": { "title": "代理商标注册", "config": null, "path": "/agencytmreg/:code=dlrfzzc", "comname": "agencytmreg" },
            "agencyotherreg": { "title": "代下他订单", "config": null, "path": "/agencyotherreg", "comname": "agencyotherreg" },
            "invoiceapply": { "title": "发票管理", "config": null, "path": "/invoiceapply", "comname": "myinvoiceapply" },
            "receiptvoucher": { "title": "收款管理", "config": null, "path": "/receiptvoucher", "comname": "receiptvoucher" },
            "expensevoucher": { "title": "费用管理", "config": null, "path": "/expensevoucher", "comname": "expensevoucher" },
            "moneyaccount": { "title": "企业账户", "config": null, "path": "/moneyaccount", "comname": "moneyaccount" },
            "moneyjourney": { "title": "交易报表", "config": null, "path": "/moneyjourney", "comname": "moneyjourney" },
            "profitrpt": { "title": "利润报表", "config": null, "path": "/profitrpt", "comname": "profitrpt" },
            "profitsplit": { "title": "分润报表", "config": null, "path": "/profitsplit", "comname": "profitsplit" },
            "tmofficial": { "title": "官文管理", "config": null, "path": "/tmofficial", "comname": "tmofficial" },
            "flowaudit": { "title": "流程审核", "config": null, "path": "/flowaudit", "comname": "flowaudit" },
            "customerinfo": { "title": "客户档案", "config": null, "path": "/customerinfo", "comname": "customerinfo" },
            "mycustomerinfo": { "title": "我的客户", "config": null, "path": "/mycustomerinfo", "comname": "customerinfo" },
            "myorder": { "title": "我的订单", "config": null, "path": "/myorder", "comname": "order" },
            "myinvoiceapply": { "title": "我的发票", "config": null, "path": "/myinvoiceapply", "comname": "myinvoiceapply" },
            "myarcmag": { "title": "我的官文", "config": null, "path": "/myarcmag", "comname": "myarcmag" },
            "useraddr": { "title": "地址管理", "config": null, "path": "/useraddr", "comname": "useraddr" },
            "actsetting": { "title": "账号设置", "config": null, "path": "/actsetting", "comname": "actsetting" },
            "patentsearch": { "title": "专利检索", "config": null, "path": "/patentsimplesearch", "comname": "patentsimplesearch" },
            "areapatentmonitor": { "title": "区域专利监控", "config": null, "path": "/iframehtml", "comname": "iframehtml" },
            "entdecide": { "title": "企业决策", "config": null, "path": "/iframehtml", "comname": "iframehtml" },
            "bytmmonitlist": {
                "title": "商标监控列表",
                "config": null,
                "path": "/bytmmonitlist",
                "comname": "bytmmonitlist"
            },
            "bytmmonitagency": {
                "title": "商标监控代理机构",
                "config": null,
                "path": "/bytmmonitagency",
                "comname": "bytmmonitagency"
            },
            "bytmmonitdynamics": {
                "title": "商标监控动态",
                "config": null,
                "path": "/bytmmonitdynamics",
                "comname": "bytmmonitdynamics"
            },
            "bytmmonitlistdetails": {
                "title": "商标监控列表详情搜索",
                "path": "/bytmmonitlistdetails",
                "comname": "bytmmonitlistdetails"
            },
            "createwts": {
                "title": "生成委托书",
                "config": null,
                "path": "/createwts",
                "comname": "createwts"
            },
            "tmOrderEdit": {
                "title": "商标订单修改",
                "config": null,
                "path": "/tmOrderEdit",
                "comname": "tmOrderEdit"
            },
            "icporderedit": {
                "title": "icp订单修改",
                "config": null,
                "path": "/icporderedit",
                "comname": "icporderedit"
            },
            "icpOrderDetail":{
                "title": "ICP订单详情",
                "config": null,
                "path": "/icpOrderDetail",
                "comname": "icpOrderDetail"
            },
            "tmOrderDetail": {
                "title": "商标订单详情",
                "config": null,
                "path": "/tmOrderDetail",
                "comname": "tmOrderDetail"
            },
            "patentsimplesearch":{
                "title": "专眼查普通检索",
                "config": null,
                "isDynamicRoute": false,
                "path": "/patentsimplesearch",
                "comname": "patentsimplesearch"
              },
            "tmtransactionmarket": { "title": "商标交易", "config": null, "path": "/tmtransactionmarket", "comname": "tmtransactionmarket" },
            "selftmreg": { "title": "自助商标注册", "config": null, "path": "/selftmreg", "comname": "selftmreg" },
            "selficpreg": { "title": "icp注册", "config": null, "path": "/selficpreg", "comname": "selficpreg" },
            "tmtransactiondetail": { "title": "商标详情", "config": null, "path": "/tmtransactiondetail", "comname": "tmtransactiondetail" },
            "ptmtransactiondetail": { "title": "商标详情", "config": null, "path": "/ptmtransactiondetail", "comname": "ptmtransactiondetail" },
            "ptmtransactiondetailpmg": { "title": "商标详情", "config": null, "path": "/ptmtransactiondetailpmg", "comname": "ptmtransactiondetail" },
            "allfqtm": { "title": "蜂擎商标档案", "config": null, "path": "/allfqtm", "comname": "allfqtm" },
            "tmtneed": { "title": "商标交易需求", "config": null, "path": "/tmtneed", "comname": "tmtneed" },
            "mytmtransaction": { "title": "商标交易库", "config": null, "path": "/mytmtransaction", "comname": "mytmtransaction" },
            "tmtransactionbatchrelease": { "title": "批量发布出售商标", "config": null, "path": "/tmtransactionbatchrelease", "comname": "tmtransactionbatchrelease" },
            "tmtransactionentrelease": { "title": "企业发布出售商标", "config": null, "path": "/tmtransactionentrelease", "comname": "tmtransactionentrelease" },
            "tmtransactionpmg": { "title": "商标交易库", "config": null, "path": "/tmtransactionpmg", "comname": "tmtransactionpmg" },
            "transactionspecialperformance": { "title": "交易专场", "config": null, "path": "/transactionspecialperformance", "comname": "transactionspecialperformance" },
        },
        "pauths": [
            "add", "edit", "delete", "export", "show"
        ],
        "pdict": {
            "pfSettleProfit": { "0": "未结算", "1": "已结算" },
            "tmCompanyAuditStatus": { "0": "待审核", "1": "审核通过", "2": "审核驳回", "3": "已过期" },
            "businessallowstatus": { "1": "待接单", "2": "已接单", "4": "拒接", "8": "成功", "16": "失败" },
            "noticeType": { "sms": "短信", "email": "邮件", "wechat": "微信" },
            "eflowstatus": { 0: "草稿", 1: "签署中", 2: "已完成", 3: "已撤销", 4: "已终止", 5: "已过期", 6: "已删除", 7: "已拒签" },
            "authType": { "add": "新增", "edit": "编辑", "delete": "删除", "export": "导出", "show": "查看" },
            "mediaType": { "vd": "视频", "ad": "音频", "qt": "其它" },
            "usageType": { "kt": "课堂", "taxkt": "财税课堂", "qt": "其它" },
            "opstatus": { "0": "失败", "1": "成功" },
            "sex": { "male": "男", "female": "女" },
            "configType": { "price": "宝币兑换率", "initGift": "初次赠送" },
            // "productCata": {
            //     "ip": "商标服务", "pa": "专利服务", "ic": "版权服务", "iso": "海外业务", "common": "增值服务", "icbc": "工商服务",
            //     "zscq": "知识产权", "cwfw": "财务服务", "hyzz": "行业资质", "gqzr": "股权转让", "xzsp": "行政审批"
            // },
            "productCata": { "ip": "商标服务", "pa": "专利服务", "ic": "版权服务", "icbc": "工商服务", "tax": "财税服务" },
            "funcCata": { "clueDig": "商机挖掘", "query": "常见查询", "prof": "专用工具", "cp": "版权工具", "common": "常用工具", "pat": "专利工具" },
            "logLevel": { "debug": 0, "info": 1, "warn": 2, "error": 3, "fatal": 4 },
            "tradeType": {
                "fill": "充值宝币", "consume": "消费宝币", "gift": "赠送宝币", "giftMoney": "红包", "refund": "退款", "payment": "付款",
                "orderTrade": "订单交易", "orderRefund": "订单退款", "orderPersonFee": "订单个人分润", "orderPlatformFee": "订单平台分润",
                "recommendFee": "推荐分润", "tmSubDeductCoin": "商标提报宝币扣除", "cashWithdrawal": "现金提现", "platUseFee": "平台使用费",
                "publicExpense": "官费", "invoiceTaxes": "税费", "subPublicExpense": "上缴官费", "returnPublicExpense": "官费退回"
            },
            "tradeStatus": { "unSettle": "未结算", "settled": "已结算" },
            "tmNclOne": {
                "1": "第01类 化学原料", "2": "第02类 颜料油漆", "3": "第03类 日化用品", "4": "第04类 燃料油脂", "5": "第05类 医药",
                "6": "第06类 金属材料", "7": "第07类 机械设备", "8": "第08类 手工器械", "9": "第09类 科学仪器", "10": "第10类 医疗器械",
                "11": "第11类 灯具空调", "12": "第12类 运输工具", "13": "第13类 军火烟火", "14": "第14类 珠宝钟表", "15": "第15类 乐器",
                "16": "第16类 办公用品", "17": "第17类 橡胶制品", "18": "第18类 皮革皮具", "19": "第19类 建筑材料", "20": "第20类 家具",
                "21": "第21类 厨房洁具", "22": "第22类 绳网袋篷", "23": "第23类 纱线丝", "24": "第24类 布料床单", "25": "第25类 服装鞋帽",
                "26": "第26类 纽扣拉链", "27": "第27类 地毯席垫", "28": "第28类 健身器材", "29": "第29类 食品", "30": "第30类 方便食品",
                "31": "第31类 饲料种籽", "32": "第32类 啤酒饮料", "33": "第33类 酒", "34": "第34类 烟草烟具", "35": "第35类 广告销售",
                "36": "第36类 金融物管", "37": "第37类 建筑修理", "38": "第38类 通讯服务", "39": "第39类 运输贮藏", "40": "第40类 材料加工",
                "41": "第41类 教育娱乐", "42": "第42类 网站服务", "43": "第43类 餐饮住宿", "44": "第44类 医疗园艺", "45": "第45类 社会服务"
            },
            "chineseSearchOption": { "py": "查拼音", "tyz": "同音字", "xsz": "形似字", "ywty": "英文同义" },
            "partnerinfoSkill": { "tm": "商标", "pa": "专利", "sc": "软件著作权" },
            "englishSearchOption": { "zwty": "中文同义", "tyhz": "同音汉字" },
            "tm_status": { "dsz": "待审中", "ycs": "已初审", "yxzc": "有效注册", "ybh": "已驳回", "yxw": "已销亡" },
            "tm_form_type": { "3": "文字", "4": "图形", "5": "文字+图形" },
            "tm_form_type2": { "1": "立体", "3": "字", "4": "图", "5": "字图", "6": "颜色", "7": "彩色" },
            "tm_type": { "p": "普通商标", "j": "集体商标", "z": "证明商标", "t": "特殊商标" },
            "ncl_calc_status": { 1: "未创建订单", 2: "已创建订单" },
            "copyright_status": { 1: "未关联订单", 2: "已关联订单" },
            "ncl_calc_calcType": { 1: "自主创建", 2: "商标特殊处理" },
            "product_unit": { 0: "人民币", 1: "美元" },
            "order_type": { "zzdd": "自主订单", "dkxd": "代客下单" },
            "receipt_type": { "sk": "收款", "tk": "退款", "zz": "转账", "csrz": "初始入账", "ptdsk": "平台代收款", "ptzz": "平台转账" },
            "expense_type": { "gf": "官费", "sxf": "手续费", "tax": "税金", "salary": "薪酬", "sale": "销售费用", "mag": "管理费用", "channelSettleProfit": "订单渠道分润结算" },
            "stuff_type": { "csty": "彩色图样", "wts": "委托书", "gzwts": "盖章委托书", "ty": "图样", "sywj": "声音文件", "smwj": "说明文件" },
            "payType": { "wx": "微信", "zfb": "支付宝", "yh": "银行卡" },
            "payResult": { "Fail": "失败", "Success": "成功" },
            "tmSourceType": { 1: "PC", 2: "移动端", 4: "渠道", 8: "beehive" },
            "loopplay_type": { "PC": "PC轮播图", "YD": "移动端轮播图", "PCAD": "PC广告图", "YDAD": "移动端广告图" },
            "user_show_order_status": { 1: "显示", 2: "用户删除", 4: "系统过期删除" },
            "order_pay_status": { "dfk": "未付款", "yfk": "已付款", "pzshwtg": "凭证审核未通过", "zfpz": "已上传支付凭证", "ddqx": "订单取消", "tkclz": "退款处理中", "ytk": "已退款" },
            "order_flow_status": { "1": "提交订单", "2": "已付款", "3": "已审核-待递交", "4": "已递交", "5": "已完成" },
            "order_status": { "1": "提交订单", "2": "待上传材料", "3": "待审核", "4": "审核不通过", "5": "待递交", "6": "部分递交异常", "7": "已完成" },
            "company_type": { "self": "独立运作", "full": "全委托", "part": "部分委托" },
            "audit_status": { "dsh": "待审核", "btg": "不通过", "tg": "通过" },
            "direction_type": { "sr": "收", "zc": "支" },
            "msg_notice_type": { "friend": "朋友", "boss": "老板" },
            "customer_type": { "ent": "企业", "person": "个人" },
            "invoice_status": { "submitted": "已提交", "processing": "处理中", "finished": "已完成" },
            "tm_apply_type": { "ent": "企业", "person": "个人" },
            "tm_apply_types": { "ent": "企业" },
            "op_type": { "applying": "申请中", "issued": "已发放", "issueError": "发放异常" },
            "sub_type": { "platform": "平台", "self": "自己" },
            "tmFirstOrder": { 0: "否", 1: "是" },
            "partnerStatus": { 0: "禁用", 1: "启用" },
            "invoice_type": { "1": "电子普通发票", "2": "纸质普通发票", "3": "纸质专用发票" },
            "invoice_apply_status": { "1": "未申请", "2": "已申请", "3": "已开票" },
            "copyright_type": { "rjzz": "软件著作权", "zpzz": "作品著作权" },
            "composition_type": {
                "wz": "文字", "ks": "口述", "yl": "音乐", "xj": "戏剧", "qy": "曲艺", "wd": "舞蹈", "zjys": "杂技艺术", "ms": "美术", "jz": "建筑", "sy": "摄影", "dy": "电影和类似摄制电影方法创作的作品",
                "tx": "图形", "mj": "模型", "qt": "其他"
            },
            "statusProgress_status": { 1: "待上传材料", 2: "待审核", 4: "审核不通过", 8: "待递交", 16: "待下回执", 32: "部分递交异常", 64: "不予受理", 128: "待邮件申请表", 256: "已完成" },
            "patents_type": { "fm": "发明专利", "wg": "外观专利", "syxx": "实用新型" },
            "applicantrequire_type": { "fyjh": "费用减缓", "yqyxq": "要求优先权", "qqtqgk": "请求提前公开", "szsc": "实质审查", "qlyqcx": "权力要求超项", "bmsc": "保密审查" },
            "source_type": { "order": "订单", "expensevoucher": "费用单", "receiptvoucher": "收款单", "trademark": "商标单" },//order与订单表的bizcode保持一致
            "official_type": {
                "1": "商标注册申请书", "2": "商标注册申请补正通知书", "3": "商标注册申请受理通知书", "4": "商标注册申请不予受理通知书", "5": "商标注册同日申请补送使用证据通知书",
                "6": "商标注册同日申请协商通知书商标注册同日申请抽签通知书", "7": "商标驳回通知书", "8": "商标部分驳回通知书", "9": "商标注册申请初步审定公告通知书",
                "10": "商标异议答辩通知书", "11": "异议裁定书", "12": "纸质版商标注册证", "13": "电子版商标注册证"
            },
            "op_log_type": { "other": "其他", "payCallback": "支付回调", "pfTransfer": "平台转账", "officialDownload": "官文下载", "publicExpense": "官费扣除", "orderSettlement": "订单利润结算" },
            "op_log_status": { "fail": "失败", "success": "成功", "waitingProcess": "等待处理" },
            "official_mail_type": { "1": "待申请", "2": "待邮寄", "3": "已邮寄" },
            "opType": { "person": "人工", "machine": "机器人" },
            "case_type": { "sbzc": "商标注册", "sbbg": "商标变更", "sbbh": "商标驳回" },
            "msgType": { "sys": "系统", "single": "单点", "multi": "群发", "mryzSingle": "每日易照单点", "mryzLicense": "群发", },
            "log_type": { "orderlog": "订单日志", "tmlog": "商标流程日志" },
            "tm_tscl_type": { "NOTRECVED": "不予受理", "FILLEXCEPTION": "填报异常" },
            "chance_type": { "tmReg": "商标注册" },
            "icp_customer_type": { "enterprise": "企业法人", "socialorganization": "社会组织法人","institutional":"事业单位法人" },//法人类型
            "icp_credentials_type":{"idcard":"身份证","passport":"护照","gaidcard":"港澳居民往来内地通行证或港澳身份证","tidcard":"台湾居民往来大陆通行证或台湾身份证","officerscard":"中国人民解放军军官证"},//企业法定代表人证件类型
            "need_status": { "1": "待服务", "2": "跟进中", "4": "已完成" },
            "platform_chance_type": { "common": "普通" },
            "service_evaluation": { "0": "差评", "5": "一般", "10": "好评" },
            "account_log_type": { "platform": "平台", "user": "用户" },
            "profitRatioType": { "platformWork": "委托作业", "selfWork": "自助作业" },
            "totalType": { "zxbxl": "店铺咨询变现率", "kdl": "合伙人开店率", "yhfll": "合伙人分裂率" },
            //cms_servicesitem项目服务表，渠道类型
            "channelType": { "hhr": "合伙人端", "boss": "boss端", "wssy": "微商水印" },
            //b_customer_roll_pic图片资源表，图片类型
            "picType": { "roll": "滚动图片", "placard": "海报图片" },
            //b_customer_roll_pic图片资源表，图片分类
            "picCategory": { "ip": "商标", "ic": "版权", "pa": "专利", "common": "增值" },
            //h_business_chance需求表，商机类型
            "chanceType": {
                "ip": "商标", "ic": "版权", "pa": "专利", "iso": "海外业务", "common": "增值服务", "icbc": "工商注册",
                "zscq": "知识产权", "cwfw": "财务服务", "hyzz": "行业资质", "gqzr": "股权转让", "xzsp": "行政审批"
            },
            //cms_servicesitem  项目小类
            "serviceSmallClassType": {
                "sbzc": "商标注册", "sbxxbg": "商标信息变更", "hjsbza": "化解商标障碍", "yytrsb": "异议他人商标", "hwsbzc": "海外商标注册", "bqdjyw": "版权登记业务",
                "bqqtyw": "版权其他业务", "zlsqyw": "专利申请业务"
            },
            //h_icbc_info工商表，工商类型
            "icbcType": { "hongkong": "香港", "gn": "国内", "gnjssqs": "国内江苏省宿迁市" },
            //h_icbc_info工商表，货币类型
            "regCapitalUnitsType": { "RMB": "万人民币", "HKD": "万港币", "USD": "万美元", "GBP": "万英镑", "JPY": "万日元" },
            "isRecommend": { "0": "否", "1": "是" },
            "paymentPlatformType": { "wx": "微信", "offline": "线下" },
            "sellStatus": { "1": "待售", "2": "已售" },
            "channelProfitType": { 1: "比例分成", 2: "每单分成" },
            "taxType": { "gzxj": "工资薪金" },
            "iit_status": { "0": "未提交", "1": "已提交" },
            "customer_channel_type": { "yjs": "友金所" },
            "companyProperty": { 1: "小规模", 2: "一般" },
            "invoiceVersion": { 1: "十万版", 2: "万元版", 2: "百万版" },
            "changeService": { 1: "包变更", 2: "买家变更" },
            "publishedSources": { 1: "公司", 2: "个人" },
            "registeredCapital": { 1: "小于100万", 2: "100-500万", 4: "501-1000万", 8: "1001-5000万", 16: "大于1000万" },
            "trackType": { 1: "收藏", 2: "访问" },
            "accountType": { "cash": "现金", "bank": "银行", "wx": "微信", "alipay": "支付宝", "other": "其它" },
            "question_status": { "waithandle": "待解决", "inmiddle": "解决中", "waitcheck": "待验证", "success": "成功解决", "invalid": "无效问题" },
            "urgent_status": { "urgent": "紧急", "general": "一般" },
            "data_priv": { "company": "公司", "moneyaccount": "账户" },
            "tm_company_type": { "xz": "商标续展", "kz": "商标宽展", "bh": "商标驳回复审", "bysl": "商标不予受理", "yy": "商标异议", "bg": "商标变更" },
            "business_status": { "wrl": "未认领", "yrl": "已认领", "bhz": "保护中", "wx": "无效" },
            "dispose_status": { "wxd": "未下单", "yxd": "已下单" },
            "order_source": { "gsay": "公司案源", "ptsj": "平台商机", "wzzx": "网站咨询" },
            "customer_intention": { "yxyb": "意向一般", "yxhg": "重要意向", "wjt": "未接通" },
            "site_theme": { "default": "默认", "normal":"常规","spring": "九宫格", "autumn": "交易", "summer": "工商", "winter": "专利", "meihua": "综合","policy":"政策","policyShop":"政策商城"},//, "summer": "夏天", "autumn": "秋天", "winter": "冬天" },
            "site_theme2": { "autumn": "秋天" },//用于交易专场---》秋天主题首页专场信息维护
            "tm_transaction_publish_status": { "audit": "审核中", "fail": "审核不通过", "success": "审核通过", "uppershelf": "上架", "lowershelf": "下架" },//商标交易发布状态
            "big_class_icon": {
                "http://gsb-zc.oss-cn-beijing.aliyuncs.com/default/zcsyhdsbtu.jpg": "商标大类图标",
                "http://gsb-zc.oss-cn-beijing.aliyuncs.com/default/zcsyhdzl.jpg": "专利大类图标",
                "http://gsb-zc.oss-cn-beijing.aliyuncs.com/default/zcsyhdbq.jpg": "版权大类图标",
                "http://gsb-zc.oss-cn-beijing.aliyuncs.com/default/zcsyhdgs.jpg": "工商大类图标",
                "http://gsb-zc.oss-cn-beijing.aliyuncs.com/default/zcsyhdcs.jpg": "财税大类图标",
                "http://gsb-zc.oss-cn-beijing.aliyuncs.com/default/zcsyhdjy.jpg": "商标交易大类图标"
            },//产品类型大类图标
            "tm_transaction_type": { "ordinary": "普通商标", "specialoffer": "特价商标", "highquality": "精品商标", "hot": "热门商标", "recommended": "推荐商标" },
            "wxop_authorized_status": { "authorized": "授权成功", "unauthorized": "取消授权", "updateauthorized": "授权更新" },
            "wxop_subscribe_status": { "subscribe": "订阅", "unsubscribe": "取消订阅" },
            "opus_indite_kind": { "yc": "原创", "gb": "改编", "fy": "翻译", "hb": "汇编", "zs": "注释", "zl": "整理", "qt": "其他" },
            "publish_status": { 1: "已发表", 2: "未发表" },
            "obtain_mode": { "ys": "原始", "jc": "继承", "cs": "承受", "qt": "其他" },
            "right_own_mode": { "grzp": "个人作品", "hzzp": "合作作品", "frzp": "法人作品", "zwzp": "职务作品", "wtzp": "委托作品" },
            "range_type": { 1: "全部", 2: "部分" },
            "apply_type": { 1: "由著作权人申请", 2: "由代理人申请" },
            "desc_type": { 1: "原创", 2: "修改" },
            "dev_way": { 1: "独立开发", 2: "合作开发", 3: "委托开发", 4: "下达任务开发" },
            "get_way": { 1: "原始取得", 2: "继受取得" },
            "deposit_type": { 1: "一般交存", 2: "例外交存" },
            "tm_flow_Status": { 1: "创建订单", 2: "已付款", 4: "待上传材料", 8: "待审核", 16: "审核不通过", 32: "待递交", 64: "部分递交异常", 128: "已递交", 256: "已完成" },
            "cr_flow_Status": { 1: "创建订单", 2: "已付款", 4: "待上传材料", 8: "待审核", 16: "审核不通过", 32: "待递交", 64: "部分递交异常", 128: "已递交", 256: "不予受理", 512: "待邮寄材料", 1024: "已完成" },
        }
    }
}
