const system = require("../../system");
const Dao = require("../dao.base");
class MoneyAccountDao extends Dao {
  constructor() {
    super(Dao.getModelName(MoneyAccountDao));
  }
  async getOneItemByCompanyId(company_id) {
    this.dao.model.findOne({
      where: { company_id: company_id, accountType: "bank", isPlatformAutopay: 1 },
      attributes: ["id", "code", "name", "payeeName", "certificateNo", "balance", "transferRate", "company_id"],
      raw: true
    });
  }
}
module.exports = MoneyAccountDao;
