var System = require("../../system")
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
class PatentycCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(PatentycCtl));
    this.GsbByChinaPatentSearchApi = System.getObject("api.chinapatentsearch");
    this.GsbByWorldPatentSearchApi = System.getObject("api.wordpatentsearch");
    this.GsbByChinaAffairSearchApi = System.getObject("api.chinaaffairsearch");
  }

  //专利价值评价
  async patentrank(pobj,obj,req){
    var result = await this.service.patentrank(obj);
    return System.getResult2(result,null);
  }  

  //专利价值评价报告
  async obtainreport(pobj,obj,req){
    var result = await this.service.obtainreport(obj);
    return System.getResult2(result,null);
  }  

  //申请人分析-申请人排名
  async applierRank(pobj, obj, req) {
    var result = await this.service.applierRank(obj);
    return System.getResult2(result, null);
  };
  
  //申请人分析-申请人归属国分析
  async applierCity(pobj, obj, req) {
    var result = await this.service.applierCity(obj);
    return System.getResult2(result, null);
  };
  //申请人分析-申请人IPC分析
  async applierIpc(pobj, obj, req) {
    var result = await this.service.applierIpc(obj);
    return System.getResult2(result, null);
  };
  //申请人分析-申请人专利类型分布
  async applierPatenttype(pobj, obj, req) {
    var result = await this.service.applierPatenttype(obj);
    return System.getResult2(result, null);
  };
  //申请人分析-申请人专利法律效力
  async applierPatentStatus(pobj, obj, req) {
    var result = await this.service.applierPatentStatus(obj);
    return System.getResult2(result, null);
  };

  //申请人分析-申请人申请趋势分析
  async applierTrend(pobj, obj, req) {
    var result = await this.service.applierTrend(obj);
    return System.getResult2(result, null);
  };

  //申请人分析-申请人发明授权率
  async applierAuthRate(pobj, obj, req) {
    var result = await this.service.applierAuthRate(obj);
    return System.getResult2(result, null);
  };

  //发明人分析-发明人排名
  async inventorRank(pobj, obj, req) {
    var result = await this.service.inventorRank(obj);
    return System.getResult2(result, null);
  };

  //发明人分析-主要发明人技术构成
  async mainInventorIpc(pobj, obj, req) {
    var result = await this.service.mainInventorIpc(obj);
    return System.getResult2(result, null);
  };

  //发明人分析-主要发明人专利类型分布
  async mainInventorPatenttype(pobj, obj, req) {
    var result = await this.service.mainInventorPatenttype(obj);
    return System.getResult2(result, null);
  };

  //发明人分析-主要发明人专利法律效力*/
  async mainInventorPatentstatus(pobj, obj, req) {
    var result = await this.service.mainInventorPatentstatus(obj);
    return System.getResult2(result, null);
  };

  //发明人分析-主要发明人申请趋势
  async mainInventorApplyTrend(pobj, obj, req) {
    var result = await this.service.mainInventorApplyTrend(obj);
    return System.getResult2(result, null);
  };

  //发明人分析-主要发明人公开趋势*/
  async mainInventorPublicTrend(pobj, obj, req) {
    var result = await this.service.mainInventorPublicTrend(obj);
    return System.getResult2(result, null);
  };

  async countrywidePatnet(pobj, obj, req) {//*区域分析-全国专利分布
    var result = await this.service.countrywidePatnet(obj);
    return System.getResult2(result, null);
  };

  async everyCountryPatent(pobj, obj, req) {//区域分析-各国专利分布
    var result = await this.service.everyCountryPatent(obj);
    return System.getResult2(result, null);
  };

  async foreignApplyInChina(pobj, obj, req) {//区域分析-外国在华申请分布
    var result = await this.service.foreignApplyInChina(obj);
    return System.getResult2(result, null);
  };

  async mainCountryIpc(pobj, obj, req) {//区域分析-主要国家IPC分布
    var result = await this.service.mainCountryIpc(obj);
    return System.getResult2(result, null);
  };

  async reportGeneration(pobj, obj, req) {//导出报告
    var result = await this.service.reportGeneration(obj);
    return System.getResult2(result, null);
  };

  async mainCountryApplyTrend(pobj, obj, req) {//区域分析-主要国家申请趋势
    var result = await this.service.mainCountryApplyTrend(obj);
    return System.getResult2(result, null);
  };


  async patentIpc(pobj, obj, req) {//技术结构分析-专利IPC分析
    var result = await this.service.patentIpc(obj);
    return System.getResult2(result, null);
  };

  async wgsjPatent(pobj, obj, req) {//技术结构分析-外观设计分类分析
    var result = await this.service.wgsjPatent(obj);
    return System.getResult2(result, null);
  };

  async foreignInChinaPatent(pobj, obj, req) {//技术结构分析-外国在华专利IPC分布
    var result = await this.service.foreignInChinaPatent(obj);
    return System.getResult2(result, null);
  };

  async fmPatentIpc(pobj, obj, req) {//技术结构分析-发明专利IPC 分布
    var result = await this.service.fmPatentIpc(obj);
    return System.getResult2(result, null);
  };

  async mainIpcTrend(pobj, obj, req) {//技术结构分析-主要IPC趋势分析
    var result = await this.service.mainIpcTrend(obj);
    return System.getResult2(result, null);
  };

  async applyTrend(pobj, obj, req) {//趋势分析-申请趋势
    var result = await this.service.applyTrend(obj);
    return System.getResult2(result, null);
  };

  async publicTrend(pobj, obj, req) {//趋势分析-公开趋势
    var result = await this.service.publicTrend(obj);
    return System.getResult2(result, null);
  };

  async authorizeTrend(pobj, obj, req) {//趋势分析-授权趋势
    var result = await this.service.authorizeTrend(obj);
    return System.getResult2(result, null);
  };

  async patenttypeStatus(pobj, obj, req) {//法律状态分析-各专利类型分布
    var result = await this.service.patenttypeStatus(obj);
    return System.getResult2(result, null);
  };

  async statusEffect(pobj, obj, req) {//法律状态分析-法律效力分布
    var result = await this.service.statusEffect(obj);
    return System.getResult2(result, null);
  };

  async nowStatus(pobj, obj, req) {//法律状态分析-当前法律状态分布
    var result = await this.service.nowStatus(obj);
    return System.getResult2(result, null);
  };

  async authStatus(pobj, obj, req) {//法律状态分析-授权状态分布
    var result = await this.service.authStatus(obj);
    return System.getResult2(result, null);
  };

  async everyApplyTrend(pobj, obj, req) {//法律状态分析-各专利类型申请趋势
    var result = await this.service.everyApplyTrend(obj);
    return System.getResult2(result, null);
  };

  async everyPublicTrend(pobj, obj, req) {//法律状态分析-各专利类型公开趋势
    var result = await this.service.everyPublicTrend(obj);
    return System.getResult2(result, null);
  };

  async agentRank(pobj, obj, req) {//代理人/机构分析-代理机构排名
    var result = await this.service.agentRank(obj);
    return System.getResult2(result, null);
  };

  async agentApplyTrend(pobj, obj, req) {  //代理人/机构分析-代理机构专利申请趋势
    var result = await this.service.agentApplyTrend(obj);
    return System.getResult2(result, null);
  };

  async agentPatenttype(pobj, obj, req) {  //代理人/机构分析-代理机构专利类型分布
    var result = await this.service.agentPatenttype(obj);
    return System.getResult2(result, null);
  };

  async agentFmAuthorize(pobj, obj, req) {//代理人/机构分析-代理机构发明授权率
    var result = await this.service.agentFmAuthorize(obj);
    return System.getResult2(result, null);
  };

  async agentIpc(pobj, obj, req) {//代理人/机构分析-代理机构IPC分布
    var result = await this.service.agentIpc(obj);
    return System.getResult2(result, null);
  };

  async agentPersonRank(pobj, obj, req) {//代理人/机构分析-代理人排名
    var result = await this.service.agentPersonRank(obj);
    return System.getResult2(result, null);
  };

  async mainAgentPatenttype(pobj, obj, req){//代理人/机构分析-主要代理人专利类型分布
    var result = await this.service.mainAgentPatenttype(obj);
    return System.getResult2(result, null);
  };

  async advancedsearch(pobj, obj) {
    console.log("--------------advancedsearch---------------");
    console.log(obj);
    var datalist = [];
    var patent1 = [];
    var patent2 = [];
    var total = 0;
    var total1 = 0;
    var total2 = 0;
    var range1 = obj.range.china.join();
    var database = "";
    if (range1.indexOf("香港") >= 0) {
      if (database) {
        database = database + "+" + "HKPATENT";
      } else {
        database = database + "HKPATENT";
      }
    }
    if (range1.indexOf("台湾") >= 0) {
      if (database) {
        database = database + "+" + "TWZL";
      } else {
        database = database + "TWZL";
      }
    }
    if (range1.indexOf("澳门") >= 0) {
      if (database) {
        database = database + "+" + "MACZL";
      } else {
        database = database + "MACZL";
      }
    }
    for (var i = 0; i < obj.range.main.length; i++) {
      if (obj.range.main[i] == "EPO") {
        if (database) {
          database = database + "+" + "EPPATENT";
        } else {
          database = database + "EPPATENT";
        }
      }
      if (obj.range.main[i] == "WIPO") {
        if (database) {
          database = database + "+" + "WOPATENT";
        } else {
          database = database + "WOPATENT";
        }
      }
      if (obj.range.main[i] == "美国") {
        if (database) {
          database = database + "+" + "USPATENT";
        } else {
          database = database + "USPATENT";
        }
      }
      if (obj.range.main[i] == "日本") {
        if (database) {
          database = database + "+" + "JPPATENT";
        } else {
          database = database + "JPPATENT";
        }
      }
      if (obj.range.main[i] == "韩国") {
        if (database) {
          database = database + "+" + "KRPATENT";
        } else {
          database = database + "KRPATENT";
        }
      }
      if (obj.range.main[i] == "英国") {
        if (database) {
          database = database + "+" + "GBPATENT";
        } else {
          database = database + "GBPATENT";
        }
      }
      if (obj.range.main[i] == "法国") {
        if (database) {
          database = database + "+" + "FRPATENT";
        } else {
          database = database + "FRPATENT";
        }
      }
      if (obj.range.main[i] == "德国") {
        if (database) {
          database = database + "+" + "DEPATENT";
        } else {
          database = database + "DEPATENT";
        }
      }
      if (obj.range.main[i] == "俄罗斯") {
        if (database) {
          database = database + "+" + "RUPATENT";
        } else {
          database = database + "RUPATENT";
        }
      }
      if (obj.range.main[i] == "瑞士") {
        if (database) {
          database = database + "+" + "CHPATENT";
        } else {
          database = database + "CHPATENT";
        }
      }
    }
    for (var i = 0; i < obj.range.other.length; i++) {
      if (obj.range.other[i] == "奥地利") {
        if (database) {
          database = database + "+" + "ATPATENT";
        } else {
          database = database + "ATPATENT";
        }
      }
      if (obj.range.other[i] == "澳大利亚") {
        if (database) {
          database = database + "+" + "AUPATENT";
        } else {
          database = database + "AUPATENT";
        }
      }
      if (obj.range.other[i] == "西班牙") {
        if (database) {
          database = database + "+" + "ESPATENT";
        } else {
          database = database + "ESPATENT";
        }
      }
      if (obj.range.other[i] == "意大利") {
        if (database) {
          database = database + "+" + "ITPATENT";
        } else {
          database = database + "ITPATENT";
        }
      }
      if (obj.range.other[i] == "加拿大") {
        if (database) {
          database = database + "+" + "CAPATENT";
        } else {
          database = database + "CAPATENT";
        }
      }
      if (obj.range.other[i] == "瑞典") {
        if (database) {
          database = database + "+" + "SEPATENT";
        } else {
          database = database + "SEPATENT";
        }
      }
    }
    if (range1.indexOf("中国大陆") >= 0 && database.length != 0) {
      var size = obj.pagesize / 2;
    } else {
      var size = obj.pagesize;
    }
    if (range1.indexOf("中国大陆") != -1) {
      console.log("-----------------中国大陆--------");
      var data1 = {
        appKey: "9d9bcbb6a82f44dbbdb185afe28032bc",
        pagesize: size,
        page: obj.currentpage,
        title: obj.patentname,
        abstr: obj.abstract,
        filingno: obj.applynum,
        pubno: obj.publishnum,
        priorno: obj.priornum,
        applname: obj.applier,
        invname: obj.inventor,
        ipcno: obj.ipc,
        filingdate1: obj.applydate1,
        filingdate2: obj.applydate2,
        pubdate1: obj.publishdate1,
        pubdate2: obj.publishdate2,
        grdate1: obj.grantdate1,
        grdate2: obj.grantdate2
      };
      var patentinfo1 = await this.GsbByChinaPatentSearchApi.seniorSearch(data1);
    }
    if (range1.indexOf("香港") != -1 || range1.indexOf("澳门") != -1 || range1.indexOf("台湾") != -1
      || obj.range.main.length != 0 || obj.range.other.length != 0) {
      console.log("-----------------国外--------");
      var data2 = {
        appKey: "9d9bcbb6a82f44dbbdb185afe28032bc",
        pagesize: size,
        page: obj.currentpage,
        danames: database,
        title: obj.patentname,
        abstr: obj.abstract,
        filingno: obj.applynum,
        pubno: obj.publishnum,
        priorno: obj.priornum,
        applname: obj.applier,
        invname: obj.inventor,
        ipcno: obj.ipc,
        filingdate1: obj.applydate1,
        filingdate2: obj.applydate2,
        pubdate1: obj.publishdate1,
        pubdate2: obj.publishdate2,
        grdate1: obj.grantdate1,
        grdate2: obj.grantdate2
      };
      var patentinfo2 = await this.GsbByWorldPatentSearchApi.seniorSearch(data2);
    }
    if (patentinfo1) {
      if (patentinfo1.status == 0) {
        console.log("----------patentdata1-------------");
        console.log(patentinfo1);
        total1 = patentinfo1.data.total;
        var patentdata1 = patentinfo1.data.hits;
        for (var i = 0; i < patentinfo1.data.hits.length; i++) {
          var publish_num = "";
          var publish_date = "";
          if (patentinfo1.data.hits[i]._source.pub_type == "发明") {
            publish_num = patentinfo1.data.hits[i]._source.pub_no;
            publish_date = patentinfo1.data.hits[i]._source.pub_time;
          } else {
            publish_num = patentinfo1.data.hits[i]._source.gr_no;
            publish_date = patentinfo1.data.hits[i]._source.gr_time;
          }
          var applierinfo = "";
          if (patentinfo1.data.hits[i]._source.applicant_name != null) {
            for (var j = 0; j < patentinfo1.data.hits[i]._source.applicant_name.length; j++) {
              if (applierinfo) {
                applierinfo = applierinfo + "," + patentinfo1.data.hits[i]._source.applicant_name[j];
              } else {
                applierinfo = applierinfo + patentinfo1.data.hits[i]._source.applicant_name[j];
              }
            }
          }
          var inventorinfo = "";
          if (patentinfo1.data.hits[i]._source.inventor_name != null) {
            for (var j = 0; j < patentinfo1.data.hits[i]._source.inventor_name.length; j++) {
              if (inventorinfo) {
                inventorinfo = inventorinfo + "," + patentinfo1.data.hits[i]._source.inventor_name[j];
              } else {
                inventorinfo = inventorinfo + patentinfo1.data.hits[i]._source.inventor_name[j];
              }
            }
          }
          var pubstatus = "";
          if (patentinfo1.data.hits[i]._source.pub_status != null) {
            pubstatus = patentinfo1.data.hits[i]._source.pub_status;
          }
          var item = {
            applynum: patentinfo1.data.hits[i]._source.filing_no,
            publishnum: publish_num,
            patentname: patentinfo1.data.hits[i]._source.filing_name,
            applier: applierinfo,
            inventor: inventorinfo,
            applydate: patentinfo1.data.hits[i]._source.filing_time,
            publishdate: publish_date,
            articletype: patentinfo1.data.hits[i]._source.pub_type,
            pubstatus: pubstatus
          }
          patent1.push(item);
        }
      }
    }
    if (patentinfo2) {
      if (patentinfo2.status == 0) {
        console.log("----------patentdata2-------------");
        console.log(patentinfo2);
        total2 = patentinfo2.data.total;
        var patentdata2 = patentinfo2.data.hits;
        for (var i = 0; i < patentinfo2.data.hits.length; i++) {
          var applierinfo = "";
          if (patentinfo2.data.hits[i]._source.applicant_name != null) {
            for (var j = 0; j < patentinfo2.data.hits[i]._source.applicant_name.length; j++) {
              if (applierinfo) {
                applierinfo = applierinfo + "," + patentinfo2.data.hits[i]._source.applicant_name[j];
              } else {
                applierinfo = applierinfo + patentinfo2.data.hits[i]._source.applicant_name[j];
              }
            }
          }
          var inventorinfo = "";
          if (patentinfo2.data.hits[i]._source.inventor_name != null) {
            for (var j = 0; j < patentinfo2.data.hits[i]._source.inventor_name.length; j++) {
              if (inventorinfo) {
                inventorinfo = inventorinfo + "," + patentinfo2.data.hits[i]._source.inventor_name[j];
              } else {
                inventorinfo = inventorinfo + patentinfo2.data.hits[i]._source.inventor_name[j];
              }
            }
          }
          var item = {
            applynum: patentinfo2.data.hits[i]._source.app_number,
            publishnum: patentinfo2.data.hits[i]._source.pub_number,
            patentname: patentinfo2.data.hits[i]._source.title_name,
            applier: applierinfo,
            inventor: inventorinfo,
            applydate: patentinfo2.data.hits[i]._source.app_date,
            publishdate: patentinfo2.data.hits[i]._source.pub_date,
            articletype: patentinfo2.data.hits[i]._source.pub_type,
            pubstatus: ""
          }
          patent2.push(item);
        }
      }
    }
    total = total1 + total2;
    for (var i = 0; i < patent1.length; i++) {
      datalist.push(patent1[i]);
    }
    for (var i = 0; i < patent2.length; i++) {
      datalist.push(patent2[i]);
    }
    var result = {
      total: total,
      dataList: datalist,
    }
    console.log("----------result--------------");
    console.log(result);
    return System.getResult2(result, null);
  };
  async simplesearch(pobj, obj) {
    console.log("--------------obtainpatentinfo---------------");
    console.log(obj);
    var datalist1 = { patenttype: [], status: [], applydate: [], publishdate: [] };
    var datalist2 = [];
    var juhe1 = { patenttype: [], status: [], applydate: [], publishdate: [] };
    var patent1 = [];
    var juhe2 = { patenttype: [], status: [], applydate: [], publishdate: [] };
    var patent2 = [];
    var range1 = obj.range.china.join();
    var database = "";
    var total = 0;
    var total1 = 0;
    var total2 = 0;
    if (range1.indexOf("香港") >= 0) {
      if (database) {
        database = database + "+" + "HKPATENT";
      } else {
        database = database + "HKPATENT";
      }
    }
    if (range1.indexOf("台湾") >= 0) {
      if (database) {
        database = database + "+" + "TWZL";
      } else {
        database = database + "TWZL";
      }
    }
    if (range1.indexOf("澳门") >= 0) {
      if (database) {
        database = database + "+" + "MACZL";
      } else {
        database = database + "MACZL";
      }
    }
    for (var i = 0; i < obj.range.main.length; i++) {
      if (obj.range.main[i] == "EPO") {
        if (database) {
          database = database + "+" + "EPPATENT";
        } else {
          database = database + "EPPATENT";
        }
      }
      if (obj.range.main[i] == "WIPO") {
        if (database) {
          database = database + "+" + "WOPATENT";
        } else {
          database = database + "WOPATENT";
        }
      }
      if (obj.range.main[i] == "美国") {
        if (database) {
          database = database + "+" + "USPATENT";
        } else {
          database = database + "USPATENT";
        }
      }
      if (obj.range.main[i] == "日本") {
        if (database) {
          database = database + "+" + "JPPATENT";
        } else {
          database = database + "JPPATENT";
        }
      }
      if (obj.range.main[i] == "韩国") {
        if (database) {
          database = database + "+" + "KRPATENT";
        } else {
          database = database + "KRPATENT";
        }
      }
      if (obj.range.main[i] == "英国") {
        if (database) {
          database = database + "+" + "GBPATENT";
        } else {
          database = database + "GBPATENT";
        }
      }
      if (obj.range.main[i] == "法国") {
        if (database) {
          database = database + "+" + "FRPATENT";
        } else {
          database = database + "FRPATENT";
        }
      }
      if (obj.range.main[i] == "德国") {
        if (database) {
          database = database + "+" + "DEPATENT";
        } else {
          database = database + "DEPATENT";
        }
      }
      if (obj.range.main[i] == "俄罗斯") {
        if (database) {
          database = database + "+" + "RUPATENT";
        } else {
          database = database + "RUPATENT";
        }
      }
      if (obj.range.main[i] == "瑞士") {
        if (database) {
          database = database + "+" + "CHPATENT";
        } else {
          database = database + "CHPATENT";
        }
      }
    }
    for (var i = 0; i < obj.range.other.length; i++) {
      if (obj.range.other[i] == "奥地利") {
        if (database) {
          database = database + "+" + "ATPATENT";
        } else {
          database = database + "ATPATENT";
        }
      }
      if (obj.range.other[i] == "澳大利亚") {
        if (database) {
          database = database + "+" + "AUPATENT";
        } else {
          database = database + "AUPATENT";
        }
      }
      if (obj.range.other[i] == "西班牙") {
        if (database) {
          database = database + "+" + "ESPATENT";
        } else {
          database = database + "ESPATENT";
        }
      }
      if (obj.range.other[i] == "意大利") {
        if (database) {
          database = database + "+" + "ITPATENT";
        } else {
          database = database + "ITPATENT";
        }
      }
      if (obj.range.other[i] == "加拿大") {
        if (database) {
          database = database + "+" + "CAPATENT";
        } else {
          database = database + "CAPATENT";
        }
      }
      if (obj.range.other[i] == "瑞典") {
        if (database) {
          database = database + "+" + "SEPATENT";
        } else {
          database = database + "SEPATENT";
        }
      }
    }
    if (range1.indexOf("中国大陆") >= 0 && database.length != 0) {
      if (obj.status == "" && obj.patenttype == "") {
        var size = obj.pagesize / 2;
      } else {
        var size = obj.pagesize;
      }
    } else {
      var size = obj.pagesize;
    }
    if (obj.lable == "patentname") {
      if (range1.indexOf("中国大陆") != -1) {
        console.log("---------patentname---------中国大陆--------");
        var data1 = {
          appKey: "9d9bcbb6a82f44dbbdb185afe28032bc",
          pagesize: size,
          page: obj.currentpage,
          title: obj.content,
          pubtype: obj.patenttype,
          pubstatus: obj.status,
          filingyear: obj.applydate,
          pubyear: obj.publishdate
        };
        console.log("----------data1------------");
        console.log(data1);
        var patentinfo1 = await this.GsbByChinaPatentSearchApi.CommomSearchbyTitle(data1);
      }
      if (range1.indexOf("香港") != -1 || range1.indexOf("澳门") != -1 || range1.indexOf("台湾") != -1
        || obj.range.main.length != 0 || obj.range.other.length != 0) {
        console.log("---------patentname---------国外--------");
        var data2 = {
          appKey: "9d9bcbb6a82f44dbbdb185afe28032bc",
          pagesize: size,
          page: obj.currentpage,
          title: obj.content,
          danames: database,
          pubtype: obj.patenttype,
          pubstatus: obj.status,
          filingyear: obj.applydate,
          pubyear: obj.publishdate
        };
        console.log("------------data2--------------");
        console.log(data2);
        var patentinfo2 = await this.GsbByWorldPatentSearchApi.CommomSearchbyTitle(data2);
      }

    }
    if (obj.lable == "applynum") {
      if (range1.indexOf("中国大陆") != -1) {
        console.log("---------applynum---------中国大陆--------");
        var data1 = {
          appKey: "9d9bcbb6a82f44dbbdb185afe28032bc",
          pagesize: size,
          page: obj.currentpage,
          filingno: obj.content,
          pubtype: obj.patenttype,
          pubstatus: obj.status,
          filingyear: obj.applydate,
          pubyear: obj.publishdate
        };
        var patentinfo1 = await this.GsbByChinaPatentSearchApi.CommomSearchbyFilingno(data1);
      }
      if (range1.indexOf("香港") != -1 || range1.indexOf("澳门") != -1 || range1.indexOf("台湾") != -1
        || obj.range.main.length != 0 || obj.range.other.length != 0) {
        console.log("---------applynum---------国外--------");
        var data2 = {
          appKey: "9d9bcbb6a82f44dbbdb185afe28032bc",
          pagesize: size,
          page: obj.currentpage,
          filingno: obj.content,
          danames: database,
          pubtype: obj.patenttype,
          pubstatus: obj.status,
          filingyear: obj.applydate,
          pubyear: obj.publishdate
        };
        var patentinfo2 = await this.GsbByWorldPatentSearchApi.CommomSearchbyFilingno(data2);
      }
    }
    if (obj.lable == "publishnum") {
      if (range1.indexOf("中国大陆") != -1) {
        console.log("---------publishnum---------中国大陆--------");
        var data1 = {
          appKey: "9d9bcbb6a82f44dbbdb185afe28032bc",
          pagesize: size,
          page: obj.currentpage,
          pubno: obj.content,
          pubtype: obj.patenttype,
          pubstatus: obj.status,
          filingyear: obj.applydate,
          pubyear: obj.publishdate
        };
        var patentinfo1 = await this.GsbByChinaPatentSearchApi.CommomSearchbyPubno(data1);
      }
      if (range1.indexOf("香港") != -1 || range1.indexOf("澳门") != -1 || range1.indexOf("台湾") != -1
        || obj.range.main.length != 0 || obj.range.other.length != 0) {
        console.log("---------publishnum---------国外--------");
        var data2 = {
          appKey: "9d9bcbb6a82f44dbbdb185afe28032bc",
          pagesize: size,
          page: obj.currentpage,
          pubno: obj.content,
          danames: database,
          pubtype: obj.patenttype,
          pubstatus: obj.status,
          filingyear: obj.applydate,
          pubyear: obj.publishdate
        };
        var patentinfo2 = await this.GsbByWorldPatentSearchApi.CommomSearchbyPubno(data2);
      }
    }
    if (obj.lable == "applier") {
      if (range1.indexOf("中国大陆") != -1) {
        console.log("---------applier---------中国大陆--------");
        var data1 = {
          appKey: "9d9bcbb6a82f44dbbdb185afe28032bc",
          pagesize: size,
          page: obj.currentpage,
          applicant: obj.content,
          pubtype: obj.patenttype,
          pubstatus: obj.status,
          filingyear: obj.applydate,
          pubyear: obj.publishdate
        };
        var patentinfo1 = await this.GsbByChinaPatentSearchApi.CommomSearchbyApplicant(data1);
      }
      if (range1.indexOf("香港") != -1 || range1.indexOf("澳门") != -1 || range1.indexOf("台湾") != -1
        || obj.range.main.length != 0 || obj.range.other.length != 0) {
        console.log("---------applier---------国外--------");
        var data2 = {
          appKey: "9d9bcbb6a82f44dbbdb185afe28032bc",
          pagesize: size,
          page: obj.currentpage,
          applicant: obj.content,
          danames: database,
          pubtype: obj.patenttype,
          pubstatus: obj.status,
          filingyear: obj.applydate,
          pubyear: obj.publishdate
        };
        var patentinfo2 = await this.GsbByWorldPatentSearchApi.CommomSearchbyApplicant(data2);
      }
    }
    if (obj.lable == "inventor") {
      if (range1.indexOf("中国大陆") != -1) {
        console.log("---------inventor---------中国大陆--------");
        var data1 = {
          appKey: "9d9bcbb6a82f44dbbdb185afe28032bc",
          pagesize: size,
          page: obj.currentpage,
          inventor: obj.content,
          pubtype: obj.patenttype,
          pubstatus: obj.status,
          filingyear: obj.applydate,
          pubyear: obj.publishdate
        };
        var patentinfo1 = await this.GsbByChinaPatentSearchApi.CommomSearchbyInventor(data1);
      }
      if (range1.indexOf("香港") != -1 || range1.indexOf("澳门") != -1 || range1.indexOf("台湾") != -1
        || obj.range.main.length != 0 || obj.range.other.length != 0) {
        console.log("---------inventor---------国外--------");
        var data2 = {
          appKey: "9d9bcbb6a82f44dbbdb185afe28032bc",
          pagesize: size,
          page: obj.currentpage,
          inventor: obj.content,
          danames: database,
          pubtype: obj.patenttype,
          pubstatus: obj.status,
          filingyear: obj.applydate,
          pubyear: obj.publishdate
        };
        var patentinfo2 = await this.GsbByWorldPatentSearchApi.CommomSearchbyInventor(data2);
      }
    }
    if (patentinfo1) {
      if (patentinfo1.status == 0) {
        console.log("----------patentdata1-------------");
        console.log(patentinfo1);
        total1 = patentinfo1.data.total;
        var juhedata1 = patentinfo1.buckets;
        for (var i = 0; i < patentinfo1.buckets.group_by_pub_type.buckets.length; i++) {
          if (patentinfo1.buckets.group_by_pub_type.buckets[i].key == "发明") {
            var item = {
              code: "发明",
              lable: "发明申请",
              num: patentinfo1.buckets.group_by_pub_type.buckets[i].doc_count
            };
            juhe1.patenttype.push(item);
          }
          if (patentinfo1.buckets.group_by_pub_type.buckets[i].key == "实用新型") {
            var item = {
              code: "实用新型",
              lable: "实用新型",
              num: patentinfo1.buckets.group_by_pub_type.buckets[i].doc_count
            };
            juhe1.patenttype.push(item);
          }
          if (patentinfo1.buckets.group_by_pub_type.buckets[i].key == "外观设计") {
            var item = {
              code: "外观设计",
              lable: "外观设计",
              num: patentinfo1.buckets.group_by_pub_type.buckets[i].doc_count
            };
            juhe1.patenttype.push(item);
          }
        }
        for (var i = 0; i < patentinfo1.buckets.group_by_pub_status.buckets.length; i++) {
          if (patentinfo1.buckets.group_by_pub_status.buckets[i].key == "有效") {
            var item = {
              code: "有效",
              lable: "有效",
              num: patentinfo1.buckets.group_by_pub_status.buckets[i].doc_count
            };
            juhe1.status.push(item);
          }
          if (patentinfo1.buckets.group_by_pub_status.buckets[i].key == "在审") {
            var item = {
              code: "在审",
              lable: "在审",
              num: patentinfo1.buckets.group_by_pub_status.buckets[i].doc_count
            };
            juhe1.status.push(item);
          }
          if (patentinfo1.buckets.group_by_pub_status.buckets[i].key == "无效") {
            var item = {
              code: "无效",
              lable: "无效",
              num: patentinfo1.buckets.group_by_pub_status.buckets[i].doc_count
            };
            juhe1.status.push(item);
          }
        }
        for (var i = 0; i < patentinfo1.buckets.group_by_filing_year.buckets.length; i++) {
          var item = {
            code: patentinfo1.buckets.group_by_filing_year.buckets[i].key,
            lable: patentinfo1.buckets.group_by_filing_year.buckets[i].key + "年",
            num: patentinfo1.buckets.group_by_filing_year.buckets[i].doc_count
          };
          juhe1.applydate.push(item);
        }
        for (var i = 0; i < patentinfo1.buckets.group_by_pub_year.buckets.length; i++) {
          var item = {
            code: patentinfo1.buckets.group_by_pub_year.buckets[i].key,
            lable: patentinfo1.buckets.group_by_pub_year.buckets[i].key + "年",
            num: patentinfo1.buckets.group_by_pub_year.buckets[i].doc_count
          };
          juhe1.publishdate.push(item);
        }

        var patentdata1 = patentinfo1.data.hits;
        for (var i = 0; i < patentinfo1.data.hits.length; i++) {
          var publish_num = "";
          var publish_date = "";
          if (patentinfo1.data.hits[i]._source.pub_type == "发明") {
            publish_num = patentinfo1.data.hits[i]._source.pub_no;
            publish_date = patentinfo1.data.hits[i]._source.pub_time;
          } else {
            publish_num = patentinfo1.data.hits[i]._source.gr_no;
            publish_date = patentinfo1.data.hits[i]._source.gr_time;
          }
          var applierinfo = "";
          if (patentinfo1.data.hits[i]._source.applicant_name != null) {
            for (var j = 0; j < patentinfo1.data.hits[i]._source.applicant_name.length; j++) {
              if (applierinfo) {
                applierinfo = applierinfo + "," + patentinfo1.data.hits[i]._source.applicant_name[j];
              } else {
                applierinfo = applierinfo + patentinfo1.data.hits[i]._source.applicant_name[j];
              }
            }
          }
          var inventorinfo = "";
          if (patentinfo1.data.hits[i]._source.inventor_name != null) {
            for (var j = 0; j < patentinfo1.data.hits[i]._source.inventor_name.length; j++) {
              if (inventorinfo) {
                inventorinfo = inventorinfo + "," + patentinfo1.data.hits[i]._source.inventor_name[j];
              } else {
                inventorinfo = inventorinfo + patentinfo1.data.hits[i]._source.inventor_name[j];
              }
            }
          }
          var pubstatus = "";
          if (patentinfo1.data.hits[i]._source.pub_status != null) {
            pubstatus = patentinfo1.data.hits[i]._source.pub_status;
          }
          var item = {
            applynum: patentinfo1.data.hits[i]._source.filing_no,
            publishnum: publish_num,
            patentname: patentinfo1.data.hits[i]._source.filing_name,
            applier: applierinfo,
            inventor: inventorinfo,
            applydate: patentinfo1.data.hits[i]._source.filing_time,
            publishdate: publish_date,
            articletype: patentinfo1.data.hits[i]._source.pub_type,
            pubstatus: pubstatus
          }
          patent1.push(item);
        }
      }
    };
    if (patentinfo2) {
      if (patentinfo2.status == 0) {
        console.log("----------patentinfo2-------------");
        console.log(patentinfo2);
        total2 = patentinfo2.data.total;
        var juhedata2 = patentinfo2.buckets;
        for (var i = 0; i < patentinfo2.buckets.group_by_filing_year.buckets.length; i++) {
          var item = {
            code: patentinfo2.buckets.group_by_filing_year.buckets[i].key,
            lable: patentinfo2.buckets.group_by_filing_year.buckets[i].key + "年",
            num: patentinfo2.buckets.group_by_filing_year.buckets[i].doc_count
          };
          juhe2.applydate.push(item);
        }
        for (var i = 0; i < patentinfo2.buckets.group_by_pub_year.buckets.length; i++) {
          var item = {
            code: patentinfo2.buckets.group_by_pub_year.buckets[i].key,
            lable: patentinfo2.buckets.group_by_pub_year.buckets[i].key + "年",
            num: patentinfo2.buckets.group_by_pub_year.buckets[i].doc_count
          };
          juhe2.publishdate.push(item);
        }
        var patentdata2 = patentinfo2.data.hits;
        for (var i = 0; i < patentinfo2.data.hits.length; i++) {
          var applierinfo = "";
          if (patentinfo2.data.hits[i]._source.applicant_name != null) {
            for (var j = 0; j < patentinfo2.data.hits[i]._source.applicant_name.length; j++) {
              if (applierinfo) {
                applierinfo = applierinfo + "," + patentinfo2.data.hits[i]._source.applicant_name[j];
              } else {
                applierinfo = applierinfo + patentinfo2.data.hits[i]._source.applicant_name[j];
              }
            }
          }
          var inventorinfo = "";
          if (patentinfo2.data.hits[i]._source.inventor_name != null) {
            for (var j = 0; j < patentinfo2.data.hits[i]._source.inventor_name.length; j++) {
              if (inventorinfo) {
                inventorinfo = inventorinfo + "," + patentinfo2.data.hits[i]._source.inventor_name[j];
              } else {
                inventorinfo = inventorinfo + patentinfo2.data.hits[i]._source.inventor_name[j];
              }
            }
          }
          var item = {
            applynum: patentinfo2.data.hits[i]._source.app_number,
            publishnum: patentinfo2.data.hits[i]._source.pub_number,
            patentname: patentinfo2.data.hits[i]._source.title_name,
            applier: applierinfo,
            inventor: inventorinfo,
            applydate: patentinfo2.data.hits[i]._source.app_date,
            publishdate: patentinfo2.data.hits[i]._source.pub_date,
            articletype: patentinfo2.data.hits[i]._source.pub_type,
            pubstatus: ""
          }
          patent2.push(item);
        }
      }
    }
    total = total1 + total2;
    datalist1.patenttype = juhe1.patenttype;
    datalist1.status = juhe1.status;
    datalist1.applydate = juhe2.applydate;
    for (var i = 0; i < juhe1.applydate.length; i++) {
      var a = datalist1.applydate.findIndex(f => f.code == juhe1.applydate[i].code);
      if (a > -1) {
        datalist1.applydate[a].num = datalist1.applydate[a].num + juhe1.applydate[i].num;
      } else {
        var item = {
          code: juhe1.applydate[i].code,
          lable: juhe1.applydate[i].lable,
          num: juhe1.applydate[i].num
        };
        datalist1.applydate.push(item);
      }
    }
    datalist1.applydate.sort(this.compare("code"))
    console.log(datalist1.applydate);
    datalist1.publishdate = juhe2.publishdate;
    for (var i = 0; i < juhe1.publishdate.length; i++) {
      var a = datalist1.publishdate.findIndex(f => f.code == juhe1.publishdate[i].code);
      if (a > -1) {
        datalist1.publishdate[a].num = datalist1.publishdate[a].num + juhe1.publishdate[i].num;
      } else {
        var item = {
          code: juhe1.publishdate[i].code,
          lable: juhe1.publishdate[i].lable,
          num: juhe1.publishdate[i].num
        };
        datalist1.publishdate.push(item);
      }
    }
    datalist1.publishdate.sort(this.compare("code"))
    for (var i = 0; i < patent1.length; i++) {
      datalist2.push(patent1[i]);
    }
    for (var i = 0; i < patent2.length; i++) {
      datalist2.push(patent2[i]);
    }
    var result = {
      total: total,
      dataList1: datalist1,
      dataList2: datalist2
    }
    console.log("----------result--------------");
    console.log(result);
    return System.getResult2(result, null);
  };
  compare(prop) {
    return function (obj1, obj2) {
      var val1 = obj1[prop];
      var val2 = obj2[prop];
      if (!isNaN(Number(val1)) && !isNaN(Number(val2))) {
        val1 = Number(val1);
        val2 = Number(val2);
      }
      if (val1 < val2) {
        return 1;
      } else if (val1 > val2) {
        return -1;
      } else {
        return 0;
      }
    }
  };
  async obtainpatentinfo(pobj, obj) {
    console.log("--------------obtainpatentinfo---------------");
    console.log(obj);
    var result = {
      patentname: "",
      patenttype: "",
      baseinfo: {},
      lawstatus: [],
      abstract: "",
      adstractpic: "",
      claim: "",
      instruction: "",
      figure: ""
    };
    if (obj.publishnum.indexOf("CN") != -1) {
      console.log("中国专利");
      var data = {
        appKey: "9d9bcbb6a82f44dbbdb185afe28032bc",
        applynum: obj.applynum,
        publishnum: obj.publishnum
      };
      var patentinfo = await this.GsbByChinaPatentSearchApi.ObtainChinaPatentInfo(data);
      console.log("---------ctl----patentinfo-------------");
      console.log(patentinfo);
      if (patentinfo.status == 0) {
        patentinfo = patentinfo.data[0]._source;
        console.log("---------ctl----patentinfo-------------");
        console.log(patentinfo);
        result.patentname = patentinfo.filing_name;
        result.patenttype = patentinfo.pub_type;
        if (patentinfo.other_ipc) {
          var otheripc = "";
          for (var i = 0; i < patentinfo.other_ipc.length; i++) {
            if (otheripc) {
              otheripc = otheripc + "," + patentinfo.other_ipc[i];
            } else {
              otheripc = otheripc + patentinfo.other_ipc[i];
            }
          }
        }
        var publishdateinfo = "";
        if (obj.publishnum == patentinfo.pub_no) {
          publishdateinfo = patentinfo.pub_time;
        }
        if (obj.publishnum == patentinfo.gr_no) {
          publishdateinfo = patentinfo.gr_time;
        };
        if (patentinfo.applicant_name) {
          var applierinfo = "";
          for (var i = 0; i < patentinfo.applicant_name.length; i++) {
            if (applierinfo) {
              applierinfo = applierinfo + "," + patentinfo.applicant_name[i];
            } else {
              applierinfo = applierinfo + patentinfo.applicant_name[i];
            }
          }
        }
        if (patentinfo.inventor_name) {
          var inventorinfo = "";
          for (var i = 0; i < patentinfo.inventor_name.length; i++) {
            if (inventorinfo) {
              inventorinfo = inventorinfo + "," + patentinfo.inventor_name[i];
            } else {
              inventorinfo = inventorinfo + patentinfo.inventor_name[i];
            }
          }
        }
        var agentinfo = ""
        if (patentinfo.agent_name1) {
          if (patentinfo.agent_name2) {
            agentinfo = patentinfo.agent_name1 + patentinfo.agent_name2;
          } else {
            agentinfo = patentinfo.agent_name1;
          }
        }
        result.baseinfo = {
          applynum: patentinfo.filing_no,
          mainclassnum: patentinfo.main_ipc,
          applydate: patentinfo.filing_time,
          classnum: otheripc,
          publishnum: obj.publishnum,
          address: patentinfo.appl_address,
          publishdate: publishdateinfo,
          countrycode: patentinfo.country_code,
          applier: applierinfo,
          agent: agentinfo,
          inventor: inventorinfo,
          agency: patentinfo.agency_name,
        };
        result.abstract = patentinfo.abstr_text;
        var patentinfostring = JSON.stringify(patentinfo);
        if (patentinfostring.indexOf("\"claim_text\":") != -1) {
          result.claim = patentinfo.claim_text;
        };
        var imgpathinfo = ""
        if (patentinfo.img_path) {
          imgpathinfo = patentinfo.img_path;
        }
        result.adstractpic = imgpathinfo;
        var affdata = {
          appKey: "9d9bcbb6a82f44dbbdb185afe28032bc",
          filingno: obj.applynum
        };

        var affairinfo = await this.GsbByChinaAffairSearchApi.SearchbyFilingno(affdata);
        if (affairinfo.status == 0) {
          console.log("---------ctl----affairinfo-------------");
          affairinfo.data.hits.forEach(function (d) {
            console.log(d);
            var affobj = { date: d._source.aff_date, status: d._source.aff_info }
            console.log(affobj);
            result.lawstatus.push(affobj);
          })
        }
      }
    } else {
      console.log("外国专利");
      var data = {
        appKey: "9d9bcbb6a82f44dbbdb185afe28032bc",
        applynum: obj.applynum,
        publishnum: obj.publishnum
      };
      var patentinfo = await this.GsbByWorldPatentSearchApi.ObtainWorldPatentInfo(data);
      console.log("---------ctl----patentinfo-------------");
      console.log(patentinfo);
      if (patentinfo.status == 0) {
        patentinfo = patentinfo.data[0]._source;
        console.log("---------ctl----patentinfo-------------");
        console.log(patentinfo);
        result.patentname = patentinfo.title_name;
        result.patenttype = patentinfo.pub_type;
        if (patentinfo.other_ipc) {
          var otheripc = "";
          for (var i = 0; i < patentinfo.other_ipc.length; i++) {
            if (otheripc) {
              otheripc = otheripc + "," + patentinfo.other_ipc[i];
            } else {
              otheripc = otheripc + patentinfo.other_ipc[i];
            }
          }
        }
        if (patentinfo.applicant_name) {
          var applierinfo = "";
          for (var i = 0; i < patentinfo.applicant_name.length; i++) {
            if (applierinfo) {
              applierinfo = applierinfo + "," + patentinfo.applicant_name[i];
            } else {
              applierinfo = applierinfo + patentinfo.applicant_name[i];
            }
          }
        }
        if (patentinfo.inventor_name) {
          var inventorinfo = "";
          for (var i = 0; i < patentinfo.inventor_name.length; i++) {
            if (inventorinfo) {
              inventorinfo = inventorinfo + "," + patentinfo.inventor_name[i];
            } else {
              inventorinfo = inventorinfo + patentinfo.inventor_name[i];
            }
          }
        }
        result.baseinfo = {
          applynum: patentinfo.app_number,
          mainclassnum: patentinfo.main_ipc,
          applydate: patentinfo.app_date,
          classnum: otheripc,
          publishnum: patentinfo.pub_number,
          address: patentinfo.addr_name,
          publishdate: patentinfo.pub_date,
          countrycode: "",
          applier: applierinfo,
          agent: patentinfo.agent_name,
          inventor: inventorinfo,
          agency: patentinfo.agency_name,
        };
        result.abstract = patentinfo.abstr_text;
        result.claim = patentinfo.claim_text;
        var imgpathinfo = ""
        if (patentinfo.img_path) {
          imgpathinfo = patentinfo.img_path;
        }
        result.adstractpic = imgpathinfo;
      }
    }
    return System.getResult2(result, null);
  }

}
module.exports = PatentycCtl;
